/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.special.time;

import crazydev.common.collection.CdComparableArray;
import crazydev.common.collection.CdIComparableList;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.facts.column.list.IOlapFactListFactory;
import crazydev.iccube.olap.schema.OlapSchema;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;

public class OlapTimeDimension
extends OlapDimension {
    private final boolean isDefaultTimeDimension;
    @Nullable
    private final Locale locale;
    @Nullable
    private KeyType keyType;

    public OlapTimeDimension(IOlapBuilderDimensionDef dimensionDef, OlapSchema schema, IOlapFactListFactory listFactory, int dimensionIndex, String name, boolean isDefaultTimeDimension, boolean isFactIndexing, boolean isIndexingByRange, @Nullable Locale locale) {
        super(dimensionDef, schema, listFactory, dimensionIndex, isFactIndexing, name, isIndexingByRange);
        this.isDefaultTimeDimension = isDefaultTimeDimension;
        this.locale = locale;
    }

    @Override
    public boolean isTime() {
        return true;
    }

    @Override
    public boolean isDefaultTimeDimension() {
        return this.isDefaultTimeDimension;
    }

    @Override
    public Comparable adaptKeyValue(Comparable javaNativeDataValue) {
        if (this.keyType == null) {
            return javaNativeDataValue;
        }
        if (this.keyType == KeyType.DATE) {
            if (javaNativeDataValue instanceof LocalDateTime) {
                LocalDateTime dateTime = (LocalDateTime)javaNativeDataValue;
                return dateTime.toLocalDate();
            }
        } else {
            if (javaNativeDataValue instanceof LocalDate) {
                return ((LocalDate)javaNativeDataValue).toLocalDateTime(new LocalTime(0, 0, 0, 0));
            }
            return javaNativeDataValue;
        }
        if (javaNativeDataValue instanceof CdIComparableList) {
            CdIComparableList array = (CdIComparableList)javaNativeDataValue;
            Comparable[] transformedArr = new Comparable[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                Comparable v = array.get(i);
                if (!(v instanceof Comparable) || v instanceof CdIComparableList) {
                    return javaNativeDataValue;
                }
                transformedArr[i] = this.adaptKeyValue(v);
            }
            return new CdComparableArray(transformedArr);
        }
        return javaNativeDataValue;
    }

    public void setKeyType(boolean hasTimeLevel) {
        this.keyType = hasTimeLevel ? KeyType.DATE_TIME : KeyType.DATE;
    }

    @Nullable
    public Locale getLocale() {
        return this.locale;
    }

    static enum KeyType {
        DATE,
        DATE_TIME;

    }
}

