/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.set;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.collection.IOlapIteratorFilter;
import crazydev.iccube.collection.OlapAbstractIteratorFilter;
import crazydev.iccube.collection.OlapDistinctTupleSet;
import crazydev.iccube.collection.OlapIterable;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.OlapLazyDistinctCollection;
import crazydev.iccube.collection.olapiterator.OlapIteratorFactory;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.OlapEntityVarType;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarAbstractEntity;
import crazydev.iccube.olap.entity.scalar.OlapTruncatedString;
import crazydev.iccube.olap.entity.set.OlapListTupleSet;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionalityHelper;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.lambda.IOlapLambdaProcessingEnabled;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;
import crazydev.iccube.olap.eval.select.context.OlapSetFormulaEvaluationContext;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public abstract class OlapTupleSet<T extends OlapTuple>
extends OlapNonScalarAbstractEntity
implements OlapIterable<T>,
IOlapLambdaProcessingEnabled<OlapTupleSet<T>> {
    public static final String FRIENDLY_NAME = "set";

    protected OlapTupleSet() {
    }

    @Override
    public OlapEntityVarType getVarType() {
        return OlapEntityVarType.SET;
    }

    @Override
    public OlapTupleSet<T> forkForParallelLambdaProcessing() {
        return this;
    }

    public abstract OlapTupleSet<T> materialize();

    @Nullable(value="not a member set")
    public abstract @Nullable(value="not a member set") OlapTupleSet<OlapMember> asMemberSet();

    public abstract OlapTupleSet<T> convertToMaterializedNamedSet(OlapSetFormulaEvaluationContext var1, String var2, int var3);

    public abstract OlapTupleSet<T> convertToAsNamedSet(String var1);

    public abstract boolean isSlicerFiltered();

    public abstract boolean isNamedSet();

    public abstract boolean isAsNamedSet();

    public boolean isIdentifiable() {
        return this.isNamedSet() || this.isAsNamedSet();
    }

    @Nullable
    public OlapTupleSet asIdentifiableSet() {
        if (this.isIdentifiable()) {
            return this;
        }
        return null;
    }

    @Nullable
    public abstract String getName();

    @Override
    protected final OlapTupleSet<T> toSet_(IOlapPrepareContext context) {
        return this;
    }

    @Override
    public final boolean isToSetApplicable(IOlapPrepareContext context) {
        return true;
    }

    @Override
    public abstract long fastEstimatedSize();

    @Override
    public abstract boolean mightHaveCalcMember();

    public abstract int _sizeSlow();

    @Nullable
    public abstract T _getSlow(int var1);

    public abstract OlapTupleSet<T> hierarchize(boolean var1);

    public abstract OlapTupleSet<T> head(int var1);

    public abstract OlapTupleSet<T> tail(int var1);

    public abstract OlapTupleSet<T> subset(int var1, int var2);

    public OlapTupleSet<T> range(@Nullable T from, @Nullable T to) {
        if (from == null && to == null) {
            throw new CdProgrammingException("Inconsistent range( null, null ) usage.");
        }
        OlapIterator iterator = this.getIterator(false);
        OlapIterator riterator = OlapIteratorFactory.subset(iterator, from, to);
        return OlapSetFactory.instance(riterator);
    }

    public OlapTupleSet<T> except(IOlapEvaluationExceptionContext context, boolean assertSetDimensionality, OlapTupleSet<? extends OlapTuple> second, boolean retainDuplicate) {
        return this.exceptOrIntersect(context, assertSetDimensionality, second, retainDuplicate, true);
    }

    public OlapTupleSet<T> intersect(IOlapEvaluationExceptionContext context, boolean assertSetDimensionality, OlapTupleSet<? extends OlapTuple> set, boolean retainDuplicate) {
        return this.exceptOrIntersect(context, assertSetDimensionality, set, retainDuplicate, false);
    }

    public OlapTupleSet<T> distinct() {
        OlapIterator iterator = this.getIterator(false);
        OlapIterator diterator = OlapIteratorFactory.distinct(iterator);
        return OlapSetFactory.instance(diterator);
    }

    @Override
    public String getFriendlyTypeName() {
        return FRIENDLY_NAME;
    }

    private OlapTupleSet<T> exceptOrIntersect(IOlapEvaluationExceptionContext context, boolean assertSetDimensionality, OlapTupleSet<? extends OlapTuple> other, boolean retainDuplicate, boolean isExcept) {
        if (assertSetDimensionality) {
            OlapTupleDimensionalityHelper.assertExceptOrIntersectDimensionality(context, this, other);
        }
        if (other instanceof OlapListTupleSet) {
            List tuples = ((OlapListTupleSet)other).tuples;
            OlapTupleSet<T> result = OlapTupleSet.exceptOrIntersect(this, tuples, retainDuplicate, isExcept);
            return result;
        }
        OlapLazyDistinctCollection<? extends OlapTuple> tuples = new OlapLazyDistinctCollection<OlapTuple>(other);
        OlapTupleSet<T> result = OlapTupleSet.exceptOrIntersect(this, tuples, retainDuplicate, isExcept);
        return result;
    }

    private static <T extends OlapTuple> OlapTupleSet<T> exceptOrIntersect(OlapTupleSet<T> tuples, Collection<? extends OlapTuple> others, boolean retainDuplicate, boolean isExcept) {
        if (retainDuplicate) {
            ExceptIteratorFilter filter = new ExceptIteratorFilter(others, isExcept);
            OlapIterator<OlapTuple> filtered = OlapIteratorFactory.filter(tuples.getIterator(false), filter);
            return OlapSetFactory.instance(filtered);
        }
        ExceptIntersectIteratorFilter filter = new ExceptIntersectIteratorFilter(others, isExcept);
        OlapIterator<OlapTuple> filtered = OlapIteratorFactory.filter(tuples.getIterator(false), filter);
        return OlapSetFactory.instance(filtered);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof OlapTupleSet)) {
            return false;
        }
        OlapTupleSet other = (OlapTupleSet)o;
        OlapIterator otuples = other.getIterator(false);
        OlapIterator ttuples = this.getIterator(false);
        return OlapTupleSet.compare(otuples, ttuples);
    }

    private static boolean compare(OlapIterator<?> otuples, OlapIterator<?> ttuples) {
        Object ttuple;
        otuples.reset();
        ttuples.reset();
        while ((ttuple = ttuples.next()) != null) {
            Object otuple = otuples.next();
            if (otuple == null) {
                return false;
            }
            if (ttuple.equals(otuple)) continue;
            return false;
        }
        return otuples.next() == null;
    }

    @Override
    public int hashCode() {
        throw new CdProgrammingException("Too much ;-) ");
    }

    @Override
    public String toMdxString(OlapNameContext nameContext, boolean truncate, int maxSize) {
        OlapTuple tuple;
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        OlapIterator tuples = this.getIterator(false);
        tuples.reset();
        while ((tuple = (OlapTuple)tuples.next()) != null) {
            if (sb.length() > 1) {
                sb.append(",");
            }
            String str = tuple.toMdxString(nameContext, truncate, maxSize);
            sb.append(str);
            if (maxSize == -1 || sb.length() <= maxSize) continue;
            if (!truncate) {
                throw new OlapTruncatedString();
            }
            return sb.substring(0, maxSize) + " ...";
        }
        sb.append("}");
        return sb.toString();
    }

    public abstract OlapListTupleSet<T> asTupleList();

    public abstract boolean isMembersCrossjoin();

    @Nullable
    public OlapTupleSet<T> decorateMemberCrossjoin(Function<OlapIterator<OlapMember>, OlapIterator<OlapMember>> t) {
        return null;
    }

    public abstract void setUnorder();

    public abstract boolean isUnorder();

    @Override
    public String toStringForDebugger() {
        String name = this.getName();
        return name != null ? name : "{...}";
    }

    public abstract boolean _isEmpty();

    public abstract void forEach(Consumer<? super T> var1);

    private static class ExceptIteratorFilter
    implements OlapAbstractIteratorFilter<OlapTuple> {
        private final Collection<? extends OlapTuple> others;
        private final boolean isExcept;

        public ExceptIteratorFilter(Collection<? extends OlapTuple> others, boolean isExcept) {
            this.others = others;
            this.isExcept = isExcept;
        }

        @Override
        public boolean accept(OlapTuple tuple) {
            return this.others.contains(tuple) ^ this.isExcept;
        }

        @Override
        public IOlapIteratorFilter<OlapTuple> newInstance() {
            return this;
        }
    }

    private static class ExceptIntersectIteratorFilter
    implements OlapAbstractIteratorFilter<OlapTuple> {
        private final Collection<? extends OlapTuple> others;
        private final boolean isExcept;
        private OlapDistinctTupleSet<OlapTuple> intersect;

        public ExceptIntersectIteratorFilter(Collection<? extends OlapTuple> others, boolean isExcept) {
            this.others = others;
            this.isExcept = isExcept;
            this.intersect = null;
        }

        @Override
        public void reset() {
            this.intersect = new OlapDistinctTupleSet();
        }

        @Override
        public boolean accept(OlapTuple tuple) {
            if (this.others.contains(tuple) ^ this.isExcept) {
                if (this.intersect.contains(tuple)) {
                    return false;
                }
                this.intersect.add(tuple);
                return true;
            }
            return false;
        }

        @Override
        public IOlapIteratorFilter<OlapTuple> newInstance() {
            return new ExceptIntersectIteratorFilter(this.others, this.isExcept);
        }
    }
}

