/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.set;

import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.olap.entity.result.slicer.OlapSlicerFilter;
import crazydev.iccube.olap.entity.set.OlapIteratorTupleSet;
import crazydev.iccube.olap.entity.set.OlapListTupleSet;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class OlapSetFactory {
    public static <T extends OlapTuple> OlapListTupleSet<T> empty() {
        return OlapListTupleSet.EMPTY_TUPLE_SET;
    }

    public static <T extends OlapTuple> OlapTupleSet<T> instance(@Nullable OlapSlicerFilter filter, OlapTupleSet<T> filtered) {
        if (filter == null) {
            return filtered;
        }
        if (filtered.isSlicerFiltered()) {
            return filtered;
        }
        return new OlapIteratorTupleSet<T>(filter, filtered);
    }

    public static <T extends OlapTuple> OlapTupleSet<T> singleton(@Nullable T tuple) {
        if (tuple == null) {
            return OlapSetFactory.empty();
        }
        if (tuple.isKO()) {
            return OlapSetFactory.empty();
        }
        ArrayList<T> tuples = new ArrayList<T>(1);
        tuples.add(tuple);
        return new OlapListTupleSet(tuples);
    }

    public static <T extends OlapTuple> OlapListTupleSet<T> instance(@Nullable List<T> tuples) {
        if (tuples == null || tuples.isEmpty()) {
            return OlapSetFactory.empty();
        }
        return new OlapListTupleSet<T>(tuples);
    }

    public static <T extends OlapTuple> OlapTupleSet<T> instance(OlapIterator<T> tuples) {
        return new OlapIteratorTupleSet<T>(tuples);
    }

    public static <T extends OlapTuple> OlapTupleSet<T> instance(T ... members) {
        return new OlapListTupleSet<T>(Arrays.asList(members));
    }
}

