/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.set;

import crazydev.common.collection.CdPaginatedList;
import crazydev.iccube.collection.IOlapIteratorFilter;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.OlapIteratorHelper;
import crazydev.iccube.collection.olapiterator.OlapBaseIterator;
import crazydev.iccube.collection.olapiterator.OlapIteratorFactory;
import crazydev.iccube.collection.olapiterator.cache.OlapCachingIterator;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.result.slicer.OlapSlicerFilter;
import crazydev.iccube.olap.entity.set.OlapIteratorAsNamedTupleSet;
import crazydev.iccube.olap.entity.set.OlapIteratorNamedTupleSet;
import crazydev.iccube.olap.entity.set.OlapListTupleSet;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.OlapTupleHierarchizedList;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.select.context.OlapSetFormulaEvaluationContext;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class OlapIteratorTupleSet<T extends OlapTuple>
extends OlapTupleSet<T> {
    private final boolean isSlicerFiltered;
    private volatile OlapIterator<T> tuples;
    private volatile int size = -1;
    private boolean unorder;

    OlapIteratorTupleSet(OlapIterator<T> tuples) {
        this(false, tuples);
    }

    OlapIteratorTupleSet(OlapSlicerFilter slicerFilter, OlapTupleSet<T> filteredSet) {
        OlapIterator iterator = filteredSet.getIterator(false);
        IOlapIteratorFilter<OlapTuple> filter = slicerFilter.asOlapTupleIteratorFilter();
        this.isSlicerFiltered = true;
        this.tuples = OlapIteratorFactory.filter(iterator, filter);
    }

    OlapIteratorTupleSet(boolean isSlicerFiltered, OlapIterator<T> tuples) {
        this.isSlicerFiltered = isSlicerFiltered;
        this.tuples = tuples;
    }

    @Override
    public long fastEstimatedSize() {
        if (this.size != -1) {
            return this.size;
        }
        return this.tuples.fastEstimatedSize();
    }

    @Override
    public boolean mightHaveCalcMember() {
        return this.tuples.mightHaveCalcMember();
    }

    @Override
    public OlapTupleSet<T> materialize() {
        OlapTuple myTuple;
        CdPaginatedList myTuples = new CdPaginatedList();
        OlapIterator<T> myIterator = this.getIterator(false);
        myIterator.reset();
        while ((myTuple = (OlapTuple)myIterator.next()) != null) {
            myTuples.add(myTuple);
        }
        return OlapSetFactory.instance(myTuples);
    }

    @Override
    public boolean isSlicerFiltered() {
        return this.isSlicerFiltered;
    }

    @Override
    public int _sizeSlow() {
        if (this.size == -1) {
            this.size = this.getIterator(false)._sizeSlow();
        }
        return this.size;
    }

    @Override
    @Nullable
    public T _getSlow(int index) {
        if (index < 0) {
            return null;
        }
        return (T)((OlapTuple)this.getIterator(false)._getSlow(index));
    }

    @Override
    public OlapTupleSet<T> head(int count) {
        if (count < 1) {
            return OlapSetFactory.empty();
        }
        OlapIterator<T> hiterator = this.tuples.head(count);
        return OlapSetFactory.instance(hiterator);
    }

    @Override
    public OlapTupleSet<T> tail(int count) {
        if (count < 1) {
            return OlapSetFactory.empty();
        }
        OlapIterator<T> iterator = this.getIterator(false);
        OlapIterator<T> titerator = OlapIteratorFactory.tail(iterator, count);
        return OlapSetFactory.instance(titerator);
    }

    @Override
    public OlapTupleSet<T> subset(int start, int count) {
        if (start < 0 || count == 0) {
            return OlapSetFactory.empty();
        }
        OlapIterator<T> iterator = count < 0 ? this.getIterator(false) : this.tuples.head(start + count);
        OlapIterator<int> siterator = OlapIteratorFactory.subset(iterator, start, count);
        return OlapSetFactory.instance(siterator);
    }

    @Override
    public OlapListTupleSet<T> asTupleList() {
        OlapTuple tuple;
        OlapIterator<T> iter = this.getIterator(false);
        ArrayList<OlapTuple> list = new ArrayList<OlapTuple>();
        iter.reset();
        while ((tuple = (OlapTuple)iter.next()) != null) {
            list.add(tuple);
        }
        list.trimToSize();
        return new OlapListTupleSet(list);
    }

    @Override
    public boolean isMembersCrossjoin() {
        return this.tuples.isMembersCrossjoin();
    }

    @Override
    @Nullable
    public OlapTupleSet<T> decorateMemberCrossjoin(Function<OlapIterator<OlapMember>, OlapIterator<OlapMember>> t) {
        OlapBaseIterator<T> iterator = this.tuples.decorateMemberCrossjoin(t);
        return iterator == null ? null : OlapSetFactory.instance(iterator);
    }

    @Override
    public void setUnorder() {
        this.unorder = true;
    }

    @Override
    public boolean isUnorder() {
        return this.unorder;
    }

    @Override
    public boolean _isEmpty() {
        return this.tuples._isEmpty();
    }

    @Override
    public void forEach(Consumer<? super T> consumer) {
        OlapTuple tuple;
        OlapIterator<T> iter = this.getIterator(false);
        iter.reset();
        while ((tuple = (OlapTuple)iter.next()) != null) {
            consumer.accept(tuple);
        }
    }

    @Override
    public OlapTupleSet<T> hierarchize(boolean post) {
        OlapTuple tuple;
        OlapTupleHierarchizedList list = new OlapTupleHierarchizedList(post);
        OlapIterator<T> myTuples = this.getIterator(false);
        myTuples.reset();
        while ((tuple = (OlapTuple)myTuples.next()) != null) {
            list.add(tuple);
        }
        return new OlapListTupleSet(list.resetAndGetTupleList());
    }

    @Override
    public synchronized OlapIterator<T> getIterator(boolean forceCache) {
        if (forceCache && !this.tuples.isCacheUseless()) {
            this.tuples = new OlapCachingIterator<T>(this.tuples.newInstance());
        }
        return this.tuples.newInstance();
    }

    @Override
    @Nullable
    public OlapTupleDimensionality getTupleDimensionality() {
        return this.tuples.getTupleDimensionality();
    }

    @Override
    public OlapTupleSet<T> convertToMaterializedNamedSet(OlapSetFormulaEvaluationContext context, String name, int limit) {
        List<T> materialized = OlapIteratorHelper.extractTuplesForSetMaterialization(context, this.getIterator(false), name, limit);
        return new OlapIteratorNamedTupleSet<T>(name, this.isSlicerFiltered, OlapIteratorFactory.instance(materialized));
    }

    @Override
    public OlapTupleSet<T> convertToAsNamedSet(String name) {
        return new OlapIteratorAsNamedTupleSet<T>(name, this.isSlicerFiltered, this.getIterator(false));
    }

    @Override
    public boolean isNamedSet() {
        return false;
    }

    @Override
    public boolean isAsNamedSet() {
        return false;
    }

    @Override
    @Nullable
    public String getName() {
        return null;
    }

    @Override
    @Nullable
    public OlapTupleSet<OlapMember> asMemberSet() {
        if (this.getIterator(false).isMemberIterator()) {
            return this;
        }
        return null;
    }

    public boolean isCrossjoin() {
        return this.tuples.isCrossjoin();
    }

    public void hackForNonEmptyX() {
        this.tuples.hackForNonEmptyX();
    }
}

