/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.scalar.tidy;

import crazydev.iccube.olap.entity.scalar.OlapScalarEntityTidyType;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.pub.olap.ITidyColumn;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class TidyColumn
implements ITidyColumn {
    private final String columnName;
    @Nullable
    private final OlapScalarEntityFactColumn<?> column;
    private final IntArrayList rowIds;

    public TidyColumn(String columnName, @Nullable OlapScalarEntityFactColumn<?> column, IntArrayList rowIds) {
        this.columnName = columnName;
        this.column = column;
        this.rowIds = rowIds;
    }

    @Override
    public int size() {
        return this.rowIds.size();
    }

    @Override
    public OlapScalarEntityTidyType getType() {
        return this.column == null ? OlapScalarEntityTidyType.LOGICAL : this.column.getTidyEntityType();
    }

    @Override
    public String getName() {
        return this.columnName;
    }

    @Override
    public String getCaption() {
        return this.getName();
    }

    @Override
    public Comparable get(int index) {
        Objects.checkIndex(index, this.rowIds.size());
        if (this.column == null) {
            return Boolean.valueOf(true);
        }
        int rowId = this.rowIds.getInt(index);
        return this.column.isNullFact(rowId) ? null : this.column.getValueAsObject(rowId);
    }
}

