/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.scalar;

import crazydev.common.lang.CdXmlaOptions;
import crazydev.common.lang.CdXmlaSchemaType;
import crazydev.iccube.common.formatter.ExcelPoiFormatter;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.OlapEntityVarType;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapAbstractScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapAveragingAggrEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericFormattedEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericWithUnitEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntityTidyType;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFCellPropertyEvalContext;
import crazydev.iccube.olap.eval.operator.scalar.OlapScalarOperators;
import crazydev.iccube.pub.olap.IOlapNumeric;
import java.io.Serializable;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public class OlapNumericEntity
extends OlapAbstractScalarEntity<OlapNumericEntity>
implements IOlapNumeric {
    public static final String FRIENDLY_NAME = "numeric";
    public static final CdXmlaSchemaType INT_TYPE = CdXmlaSchemaType.DBTYPE_I8;
    public static final CdXmlaSchemaType DOUBLE_TYPE = CdXmlaSchemaType.DBTYPE_R8;
    public static final OlapNumericEntity ZERO_AS_DOUBLE = new OlapNumericEntity(0.0, true);
    public static final OlapNumericEntity ZERO_AS_LONG = new OlapNumericEntity(0L, true);
    public static final OlapNumericEntity ONE_AS_LONG = new OlapNumericEntity(1L, true);
    public static int operatorIndex = OlapScalarOperators.createIndex(OlapNumericEntity.class);
    protected final boolean constant;
    protected CdXmlaSchemaType kind;
    protected double value;

    public OlapNumericEntity(CdXmlaSchemaType type, long value) {
        this(type, value, true);
    }

    public OlapNumericEntity(CdXmlaSchemaType kind, double value) {
        this(kind, value, true);
    }

    public OlapNumericEntity(long value) {
        this(INT_TYPE, value, true);
    }

    public OlapNumericEntity(long value, boolean constant) {
        this(INT_TYPE, value, constant);
    }

    public OlapNumericEntity(double value) {
        this(DOUBLE_TYPE, value, true);
    }

    public OlapNumericEntity(double value, boolean constant) {
        this(DOUBLE_TYPE, value, constant);
    }

    protected OlapNumericEntity(CdXmlaSchemaType kind, double value, boolean constant) {
        this.kind = kind;
        this.value = value;
        this.constant = constant;
    }

    @Override
    public OlapEntityVarType getVarType() {
        return OlapEntityVarType.NUMERIC;
    }

    public static OlapScalarEntity asZeroForEmpty(boolean emptyIsZeroFloat) {
        if (emptyIsZeroFloat) {
            return new OlapNumericEntity(0.0);
        }
        return new OlapNumericEntity(0L);
    }

    public boolean isConstant() {
        return this.constant;
    }

    @Override
    public double value() {
        return this.value;
    }

    @Override
    public boolean isDecimal() {
        return !this.isDouble();
    }

    @Override
    public boolean isDouble() {
        return this.kind == DOUBLE_TYPE;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public CdXmlaSchemaType getXmlaType(@Nullable CdXmlaOptions options) {
        if (this.kind == CdXmlaSchemaType.DBTYPE_I8 && options != null && options.excelXsdLong && this.value <= 2.147483647E9) {
            return CdXmlaSchemaType.DBTYPE_I4;
        }
        return this.kind;
    }

    public void resetXmlaType(CdXmlaSchemaType xmlaType) {
        this.kind = xmlaType;
    }

    @Override
    public String asXmlaString() {
        if (Double.isNaN(this.value)) {
            return "NaN";
        }
        if (this.value == Double.POSITIVE_INFINITY) {
            return "INF";
        }
        if (this.value == Double.NEGATIVE_INFINITY) {
            return "-INF";
        }
        return this.asString();
    }

    @Override
    public String asString() {
        if (this.isDouble()) {
            return String.valueOf(this.value);
        }
        return Long.toString(this.longValue());
    }

    @Override
    public Object asValue() {
        Number val = this.isDouble() ? (Number)this.value : (Number)this.longValue();
        return val;
    }

    @Override
    public Class getUnderlyingJavaNativeValueType() {
        return this.isDouble() ? Double.TYPE : Long.TYPE;
    }

    @Override
    public boolean doIsConvertibleToJavaType(Class target) {
        return Double.class.equals((Object)target) || Double.TYPE.equals(target) || Long.class.equals((Object)target) || Long.TYPE.equals(target) || Float.class.equals((Object)target) || Float.TYPE.equals(target) || Integer.class.equals((Object)target) || Integer.TYPE.equals(target) || Boolean.TYPE.equals(target) || target.isAssignableFrom(String.class);
    }

    @Override
    public Object doAsJavaNativeValue(Class expectedClazz) {
        if (expectedClazz == Double.TYPE || expectedClazz == Double.class) {
            return this.value;
        }
        if (expectedClazz == Long.TYPE || expectedClazz == Long.class) {
            return this.longValue();
        }
        if (expectedClazz == Float.TYPE || expectedClazz == Float.class) {
            return Float.valueOf(this.floatValue());
        }
        if (expectedClazz == Integer.TYPE || expectedClazz == Integer.class) {
            return this.intValue();
        }
        if (expectedClazz == Boolean.TYPE || expectedClazz == Boolean.class) {
            return this.value != 0.0;
        }
        if (expectedClazz.isAssignableFrom(String.class)) {
            return this.asString();
        }
        return null;
    }

    @Override
    public OlapScalarEntity asInitialValueFor(OlapMember[] members, OlapMember measure, OlapAggregationType aggregationType) {
        switch (aggregationType) {
            case SUM: 
            case SUM_HIGH_PRECISION: 
            case MIN: 
            case MAX: {
                if (this.getClass() == OlapNumericEntity.class) {
                    return this;
                }
                return new OlapNumericEntity(this.kind, this.value, false);
            }
            case AVG_LEAVES: {
                return new OlapAveragingAggrEntity(this, false);
            }
        }
        OlapScalarEntity entity = super.asInitialValueFor(members, measure, aggregationType);
        return entity;
    }

    @Override
    public OlapNumericEntity aggregate(OlapMember[] members, OlapMember measure, OlapScalarEntity entity, OlapAggregationType aggregationType) {
        if (entity.isMdxNull()) {
            return this;
        }
        if (!(entity instanceof OlapNumericEntity)) {
            throw new OlapEvaluationException(IOlapEvaluationExceptionContext.NULL, OlapErrorCode.TYPE_MISMATCH, new Serializable[]{FRIENDLY_NAME, entity.getFriendlyTypeName()});
        }
        OlapNumericEntity xentity = (OlapNumericEntity)entity;
        switch (aggregationType) {
            case SUM: 
            case SUM_HIGH_PRECISION: {
                return this.sum(xentity);
            }
            case MIN: {
                if (xentity.value <= this.value) {
                    return xentity;
                }
                return this;
            }
            case MAX: {
                if (xentity.value >= this.value) {
                    return xentity;
                }
                return this;
            }
        }
        throw new RuntimeException("internal error: inconsistent aggregation for NUMERIC entity [" + String.valueOf((Object)aggregationType) + "]");
    }

    @Override
    public int getOperatorIndex() {
        return operatorIndex;
    }

    @Override
    public String getFriendlyTypeName() {
        return FRIENDLY_NAME;
    }

    @Override
    public OlapScalarEntity asNonAggregating(boolean constant) {
        if (this.constant != constant) {
            return new OlapNumericEntity(this.kind, this.value, constant);
        }
        return this;
    }

    @Override
    public final OlapScalarEntity asConstant() {
        if (this.constant) {
            return this;
        }
        OlapScalarEntity res = this.doAsConstant();
        return res;
    }

    protected OlapScalarEntity doAsConstant() {
        return new OlapNumericEntity(this.kind, this.value, true);
    }

    @Override
    public boolean isFormattingNumeric() {
        return true;
    }

    @Override
    public String javaFormat(GFCellPropertyEvalContext context, Locale locale, String pattern) {
        String formatted = String.format(locale, pattern, this.value);
        return this.asFormatted(formatted);
    }

    protected String asFormatted(String formatted) {
        return formatted;
    }

    @Override
    public String excelFormat(GFCellPropertyEvalContext context, Locale locale, String format) {
        String formatted = ExcelPoiFormatter.formatNumeric(format, locale, this.value);
        return this.asFormatted(formatted);
    }

    @Override
    @Nullable
    public Object toTidyTableValue() {
        if (this.isDouble()) {
            if (Double.isNaN(this.value) || Double.isInfinite(this.value)) {
                return null;
            }
            return this.value;
        }
        return (long)this.value;
    }

    @Override
    @Nullable
    public Object toTidyTableValueEx() {
        if (this.isDouble()) {
            return this.value;
        }
        return (long)this.value;
    }

    @Override
    public OlapScalarEntityTidyType toTidyTableValueType() {
        return OlapScalarEntityTidyType.NUMERIC;
    }

    @Override
    @Nullable
    public Number toLatLongValue() {
        if (Double.isNaN(this.value) || Double.isInfinite(this.value)) {
            return null;
        }
        return this.value;
    }

    @Override
    public OlapScalarEntity multiplyByZero() {
        return new OlapNumericEntity(this.kind, 0.0);
    }

    @Override
    public boolean isZero() {
        return this.value == 0.0;
    }

    @Override
    public String toString() {
        return this.value + " [" + String.valueOf(this.kind) + "] [" + this.constant + "]";
    }

    public OlapNumericEntity sum(OlapNumericEntity other) {
        CdXmlaSchemaType sumkind;
        CdXmlaSchemaType cdXmlaSchemaType = sumkind = this.kind == INT_TYPE && other.kind == INT_TYPE ? INT_TYPE : DOUBLE_TYPE;
        if (this.constant) {
            return this.withNewValue(sumkind, other.value + this.value);
        }
        this.kind = sumkind;
        this.value += other.value;
        return this;
    }

    public OlapNumericEntity minus(OlapNumericEntity other) {
        CdXmlaSchemaType sumkind;
        CdXmlaSchemaType cdXmlaSchemaType = sumkind = this.kind == INT_TYPE && other.kind == INT_TYPE ? INT_TYPE : DOUBLE_TYPE;
        if (this.constant) {
            return this.withNewValue(sumkind, this.value - other.value);
        }
        this.kind = sumkind;
        this.value -= other.value;
        return this;
    }

    public OlapNumericEntity unaryMinus() {
        if (this.constant) {
            return this.withNewValue(this.kind, -this.value);
        }
        this.value = -this.value;
        return this;
    }

    public OlapScalarEntity multiply(OlapNumericEntity other) {
        CdXmlaSchemaType sumkind;
        CdXmlaSchemaType cdXmlaSchemaType = sumkind = this.kind == INT_TYPE && other.kind == INT_TYPE ? INT_TYPE : DOUBLE_TYPE;
        if (this.constant) {
            return this.withNewValue(sumkind, other.value * this.value);
        }
        this.kind = sumkind;
        this.value *= other.value;
        return this;
    }

    public OlapScalarEntity divide(OlapNumericEntity other) {
        CdXmlaSchemaType sumkind = DOUBLE_TYPE;
        if (this.constant) {
            return this.withNewValue(sumkind, this.value / other.value);
        }
        this.kind = sumkind;
        this.value /= other.value;
        return this;
    }

    public OlapScalarEntity power(OlapNumericEntity other) {
        CdXmlaSchemaType sumkind;
        CdXmlaSchemaType cdXmlaSchemaType = sumkind = this.kind == INT_TYPE && other.kind == INT_TYPE ? INT_TYPE : DOUBLE_TYPE;
        if (this.constant) {
            return this.withNewValue(sumkind, Math.pow(this.value, other.value));
        }
        this.kind = sumkind;
        this.value = Math.pow(this.value, other.value);
        return this;
    }

    public OlapNumericEntity withNewValue(CdXmlaSchemaType kind, double value) {
        return new OlapNumericEntity(kind, value, false);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OlapNumericEntity that = (OlapNumericEntity)o;
        if (Double.compare(that.value, this.value) != 0) {
            return false;
        }
        return this.kind == that.kind;
    }

    @Override
    public int hashCode() {
        long valueB = Double.doubleToLongBits(this.value);
        int result = this.kind.hashCode();
        result = 31 * result + (int)(valueB ^ valueB >>> 32);
        return result;
    }

    @Override
    public OlapScalarEntity<OlapNumericEntity> withFormattedValue(String formattedValue) {
        if (formattedValue == null) {
            return new OlapNumericEntity(this.kind, this.value, this.constant);
        }
        return new OlapNumericFormattedEntity(this.kind, this.value, this.constant, formattedValue);
    }

    public OlapNumericEntity withUnit(String unit, boolean errorOnMismatch) {
        return new OlapNumericWithUnitEntity(this.kind, this.value, false, unit, errorOnMismatch);
    }

    public OlapNumericEntity withoutDecoration() {
        return new OlapNumericEntity(this.kind, this.value, false);
    }
}

