/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.scalar;

import crazydev.common.lang.CdXmlaOptions;
import crazydev.common.lang.CdXmlaSchemaType;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.olap.entity.OlapEntityVarType;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.IAggregationScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapAbstractScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntityTidyType;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFCellPropertyEvalContext;
import crazydev.iccube.olap.eval.operator.scalar.OlapScalarOperators;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public class OlapMinMaxAggrEntity
extends OlapAbstractScalarEntity<OlapMinMaxAggrEntity>
implements IAggregationScalarEntity {
    public static final String FRIENDLY_NAME = "min/max";
    private static final long serialVersionUID = -7883097882048630271L;
    private final boolean constant;
    private OlapScalarEntity minMax;

    public OlapMinMaxAggrEntity(OlapScalarEntity entity, boolean constant) {
        this.constant = constant;
        this.minMax = entity;
    }

    @Override
    public OlapEntityVarType getVarType() {
        return OlapEntityVarType.MIN_MAX;
    }

    @Override
    public OlapEntityVarType getValType() {
        return this.minMax.getValType();
    }

    @Override
    public CdXmlaSchemaType getXmlaType(@Nullable CdXmlaOptions options) {
        return this.minMax.getXmlaType(options);
    }

    @Override
    public String asXmlaString() {
        return this.minMax.asXmlaString();
    }

    @Override
    public String asString() {
        return this.minMax.asString();
    }

    @Override
    public Object asValue() {
        return this.minMax.asValue();
    }

    @Override
    public Class getUnderlyingJavaNativeValueType() {
        return this.minMax.getUnderlyingJavaNativeValueType();
    }

    @Override
    public boolean doIsConvertibleToJavaType(Class target) {
        return this.minMax.isConvertibleToJavaNativeValueType(target);
    }

    @Override
    public Object doAsJavaNativeValue(Class expectedClazz) {
        return this.minMax.asJavaNativeValue(expectedClazz);
    }

    @Override
    public int getOperatorIndex() {
        return this.minMax.getOperatorIndex();
    }

    @Override
    public OlapScalarEntity asEntityForOperator() {
        return this.minMax;
    }

    @Override
    public boolean isFormattingNumeric() {
        return this.minMax.isFormattingNumeric();
    }

    @Override
    public String javaFormat(GFCellPropertyEvalContext context, Locale locale, String pattern) {
        return this.minMax.javaFormat(context, locale, pattern);
    }

    @Override
    public String excelFormat(GFCellPropertyEvalContext context, Locale locale, String format) {
        return this.minMax.excelFormat(context, locale, format);
    }

    @Override
    public boolean isMdxNull() {
        return this.minMax.isMdxNull();
    }

    @Override
    @Nullable
    public Object toTidyTableValue() {
        return this.minMax.toTidyTableValue();
    }

    @Override
    public OlapScalarEntityTidyType toTidyTableValueType() {
        return this.minMax.toTidyTableValueType();
    }

    @Override
    @Nullable
    public OlapScalarEntityTidyType toTidyTableValueSubType() {
        return this.minMax.toTidyTableValueSubType();
    }

    @Override
    @Nullable
    public Number toLatLongValue() {
        return this.minMax.toLatLongValue();
    }

    @Override
    public OlapScalarEntity multiplyByZero() {
        return this.minMax.multiplyByZero();
    }

    @Override
    public boolean isZero() {
        return this.minMax.isZero();
    }

    @Override
    public OlapScalarEntity asNonAggregating(boolean constant) {
        return this.minMax.asNonAggregating(constant);
    }

    @Override
    public OlapScalarEntity asConstant() {
        return new OlapMinMaxAggrEntity(this.minMax, true);
    }

    @Override
    public OlapMinMaxAggrEntity aggregate(OlapMember[] members, OlapMember measure, OlapScalarEntity entity, OlapAggregationType aggregationType) {
        if (entity.isMdxNull()) {
            return this;
        }
        switch (aggregationType) {
            case MIN: {
                if (OlapScalarOperators.compare(null, entity, this.minMax) < 0) {
                    if (!this.constant) {
                        this.minMax = entity;
                        return this;
                    }
                    return new OlapMinMaxAggrEntity(entity, false);
                }
                return this;
            }
            case MAX: {
                if (OlapScalarOperators.compare(null, this.minMax, entity) < 0) {
                    if (!this.constant) {
                        this.minMax = entity;
                        return this;
                    }
                    return new OlapMinMaxAggrEntity(entity, false);
                }
                return this;
            }
        }
        throw new RuntimeException("internal error: inconsistent aggregation for MIN-MAX entity [" + String.valueOf((Object)aggregationType) + "]");
    }

    @Override
    public String getFriendlyTypeName() {
        return FRIENDLY_NAME;
    }

    @Override
    public String toStringForDebugger() {
        return "MIN/MAX: " + this.minMax.toStringForDebugger();
    }

    @Override
    public String toString() {
        return this.minMax.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OlapMinMaxAggrEntity that = (OlapMinMaxAggrEntity)o;
        return this.minMax.equals(that.minMax);
    }

    @Override
    public int hashCode() {
        return this.minMax.hashCode();
    }
}

