/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.scalar;

import crazydev.common.math.CdIMatrix;
import crazydev.iccube.olap.entity.scalar.OlapBaseArrayEntity;
import crazydev.iccube.olap.entity.scalar.OlapDoubleVectorEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntityTidyType;
import crazydev.iccube.olap.eval.operator.scalar.OlapScalarOperators;
import org.apache.commons.math3.stat.descriptive.AbstractStorelessUnivariateStatistic;
import org.apache.commons.math3.stat.descriptive.moment.GeometricMean;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.apache.commons.math3.stat.descriptive.moment.Variance;
import org.apache.commons.math3.stat.descriptive.rank.Max;
import org.apache.commons.math3.stat.descriptive.rank.Min;
import org.apache.commons.math3.stat.descriptive.summary.Product;
import org.apache.commons.math3.stat.descriptive.summary.Sum;
import org.apache.commons.math3.stat.descriptive.summary.SumOfLogs;
import org.apache.commons.math3.stat.descriptive.summary.SumOfSquares;
import org.jetbrains.annotations.Nullable;

public class OlapDoubleMatrixEntity
extends OlapBaseArrayEntity {
    public static final String FRIENDLY_NAME = "matrix";
    public static int operatorIndex = OlapScalarOperators.createIndex(OlapDoubleMatrixEntity.class);
    protected final CdIMatrix matrix;

    public OlapDoubleMatrixEntity(CdIMatrix matrix) {
        this.matrix = matrix;
    }

    @Override
    public OlapScalarEntity multiplyByZero() {
        return this.newMatrixEntity(this.matrix.allZero());
    }

    @Override
    public boolean isZero() {
        return this.matrix.isZero();
    }

    @Override
    public String asString() {
        return this.matrix.asString();
    }

    @Override
    public Object toTidyTableValue() {
        return this.matrix.toTidyTableValue();
    }

    @Override
    public OlapScalarEntityTidyType toTidyTableValueType() {
        return OlapScalarEntityTidyType.UNKNOWN;
    }

    public CdIMatrix asValue() {
        return this.matrix;
    }

    @Override
    public Class getUnderlyingJavaNativeValueType() {
        return this.matrix.getClass();
    }

    public int length() {
        return this.cols() * this.rows();
    }

    public int cols() {
        return this.matrix.getColDimension();
    }

    public int rows() {
        return this.matrix.getRowDimension();
    }

    @Nullable
    public OlapDoubleMatrixEntity inverse() {
        CdIMatrix inverse = this.matrix.inverse();
        if (inverse == null) {
            return null;
        }
        return new OlapDoubleMatrixEntity(inverse);
    }

    @Nullable
    public OlapDoubleVectorEntity solve(double[] vector) {
        double[] solution = this.matrix.solve(vector);
        if (solution == null) {
            return null;
        }
        return this.newRowsVector(solution);
    }

    @Override
    public boolean doIsConvertibleToJavaType(Class target) {
        return false;
    }

    @Override
    public Object doAsJavaNativeValue(Class expectedClazz) {
        return null;
    }

    @Override
    public int getOperatorIndex() {
        return operatorIndex;
    }

    @Override
    public String getFriendlyTypeName() {
        return FRIENDLY_NAME;
    }

    public double value(int col, int row) {
        return this.matrix.getValue(row, col);
    }

    public OlapDoubleMatrixEntity round(int precision) {
        return this.newMatrixEntity(this.matrix.round(precision));
    }

    public double mean() {
        return this.apply((AbstractStorelessUnivariateStatistic)new Mean());
    }

    public double geometricMean() {
        return this.apply((AbstractStorelessUnivariateStatistic)new GeometricMean());
    }

    public double max() {
        return this.apply((AbstractStorelessUnivariateStatistic)new Max());
    }

    public double min() {
        return this.apply((AbstractStorelessUnivariateStatistic)new Min());
    }

    public double product() {
        return this.apply((AbstractStorelessUnivariateStatistic)new Product());
    }

    public double sum() {
        return this.apply((AbstractStorelessUnivariateStatistic)new Sum());
    }

    public double sumLog() {
        return this.apply((AbstractStorelessUnivariateStatistic)new SumOfLogs());
    }

    public double sumSq() {
        return this.apply((AbstractStorelessUnivariateStatistic)new SumOfSquares());
    }

    public double variance() {
        return this.apply((AbstractStorelessUnivariateStatistic)new Variance());
    }

    public OlapDoubleMatrixEntity transpose() {
        return this.newMatrixEntity(this.matrix.transpose());
    }

    public double stdev() {
        return Math.sqrt(this.apply((AbstractStorelessUnivariateStatistic)new Variance()));
    }

    public OlapDoubleMatrixEntity sum(OlapNumericEntity numericEntity) {
        CdIMatrix cdIMatrix = this.matrix.sum(numericEntity.value());
        return this.newMatrixEntity(cdIMatrix);
    }

    public OlapDoubleMatrixEntity sum(OlapDoubleMatrixEntity matrixEntity) {
        CdIMatrix cdIMatrix = this.matrix.sum(matrixEntity.matrix);
        return this.newMatrixEntity(cdIMatrix);
    }

    public OlapDoubleMatrixEntity minus(OlapNumericEntity numericEntity) {
        CdIMatrix cdIMatrix = this.matrix.sum(-numericEntity.value);
        return this.newMatrixEntity(cdIMatrix);
    }

    public OlapDoubleMatrixEntity minus(OlapDoubleMatrixEntity matrixEntity) {
        CdIMatrix cdIMatrix = this.matrix.minus(matrixEntity.matrix);
        return this.newMatrixEntity(cdIMatrix);
    }

    public OlapDoubleMatrixEntity multiply(OlapNumericEntity numericEntity) {
        CdIMatrix cdIMatrix = this.matrix.multiply(numericEntity.value);
        return this.newMatrixEntity(cdIMatrix);
    }

    public OlapDoubleMatrixEntity multiply(OlapDoubleMatrixEntity vector) {
        CdIMatrix cdIMatrix = this.matrix.multiply(vector.matrix);
        return this.newMatrixEntity(cdIMatrix);
    }

    public OlapDoubleVectorEntity multiply(OlapDoubleVectorEntity vector) {
        return this.newRowsVector(this.matrix.multiply(vector.values));
    }

    public OlapDoubleMatrixEntity unaryMinus() {
        return this.newMatrixEntity(this.matrix.multiply(-1.0));
    }

    public OlapDoubleMatrixEntity divide(OlapNumericEntity numericEntity) {
        CdIMatrix cdIMatrix = this.matrix.multiply(1.0 / numericEntity.value);
        return this.newMatrixEntity(cdIMatrix);
    }

    public boolean same(OlapDoubleMatrixEntity other) {
        return this.matrix.same(other.matrix);
    }

    public double[] toFlatArray() {
        return this.matrix.toFlatArray();
    }

    protected OlapDoubleMatrixEntity newMatrixEntity(CdIMatrix cdIMatrix) {
        return new OlapDoubleMatrixEntity(cdIMatrix);
    }

    private double apply(AbstractStorelessUnivariateStatistic calculator) {
        this.matrix.eval(calculator);
        return calculator.getResult();
    }

    protected OlapDoubleVectorEntity newRowsVector(double[] solution) {
        return new OlapDoubleVectorEntity(solution);
    }

    @Override
    public String toStringForDebugger() {
        return FRIENDLY_NAME;
    }

    @Override
    public String toStringForDebuggerAsValue() {
        return this.matrix.asString(1024);
    }

    @Override
    public OlapScalarEntity asConstant() {
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OlapDoubleMatrixEntity that = (OlapDoubleMatrixEntity)o;
        return this.matrix.equals((Object)that.matrix);
    }

    @Override
    public int hashCode() {
        return this.matrix.hashCode();
    }
}

