/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.scalar;

import crazydev.common.lang.CdXmlaOptions;
import crazydev.common.lang.CdXmlaSchemaType;
import crazydev.iccube.common.formatter.ExcelPoiFormatter;
import crazydev.iccube.olap.entity.OlapEntityVarType;
import crazydev.iccube.olap.entity.scalar.OlapAbstractScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntityTidyType;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFCellPropertyEvalContext;
import crazydev.iccube.olap.eval.operator.scalar.OlapScalarOperators;
import crazydev.iccube.pub.utils.ic3DateTime;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;
import org.joda.time.CdJodaTimeUtil;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class OlapDateTimeEntity
extends OlapAbstractScalarEntity<OlapDateTimeEntity> {
    public static final String FRIENDLY_NAME = "datetime";
    public static int operatorIndex = OlapScalarOperators.createIndex(OlapDateTimeEntity.class);
    private final LocalDateTime value;

    public OlapDateTimeEntity(LocalDateTime value) {
        this.value = value;
    }

    public OlapDateTimeEntity(Date value) {
        this(new LocalDateTime((Object)value));
    }

    public OlapDateTimeEntity(int year, int month, int day) {
        this.value = new LocalDateTime(year, month, day, 0, 0);
    }

    @Override
    public OlapEntityVarType getVarType() {
        return OlapEntityVarType.DATE_TIME;
    }

    public LocalDate toDate() {
        return this.value.toLocalDate();
    }

    public int dayOfWeek() {
        return this.value.getDayOfWeek();
    }

    public int dayOfMonth() {
        return this.value.getDayOfMonth();
    }

    public int dayOfYear() {
        return this.value.getDayOfYear();
    }

    public int hourOfDay() {
        return this.value.getHourOfDay();
    }

    public int weekyear() {
        return this.value.getWeekyear();
    }

    public int weekOfWeekyear() {
        return this.value.getWeekOfWeekyear();
    }

    public LocalDateTime plusDays(int days) {
        return this.value.plusDays(days);
    }

    public LocalDateTime plusMonths(int months) {
        return this.value.plusMonths(months);
    }

    public LocalDateTime plusYears(int years) {
        return this.value.plusYears(years);
    }

    public LocalDateTime plusHours(int hours) {
        return this.value.plusHours(hours);
    }

    public LocalDateTime plusMinutes(int minutes) {
        return this.value.plusMinutes(minutes);
    }

    public LocalDateTime plusSeconds(int seconds) {
        return this.value.plusSeconds(seconds);
    }

    public LocalDateTime plusMillis(int millis) {
        return this.value.plusMillis(millis);
    }

    public LocalDateTime minusDays(int days) {
        return this.value.minusDays(days);
    }

    public LocalDateTime minusMonths(int months) {
        return this.value.minusMonths(months);
    }

    public LocalDateTime minusYears(int years) {
        return this.value.minusYears(years);
    }

    public LocalDateTime minusHours(int hours) {
        return this.value.minusHours(hours);
    }

    public LocalDateTime minusMinutes(int minutes) {
        return this.value.minusMinutes(minutes);
    }

    public LocalDateTime minusSeconds(int seconds) {
        return this.value.minusSeconds(seconds);
    }

    public LocalDateTime minusMillis(int millis) {
        return this.value.minusMillis(millis);
    }

    public LocalDateTime withYear(int year) {
        return this.value.withYear(year);
    }

    public LocalDateTime withMonthOfYear(int monthOfYear) {
        return this.value.withMonthOfYear(monthOfYear);
    }

    public LocalDateTime withDayOfMonth(int dayOfMonth) {
        return this.value.withDayOfMonth(dayOfMonth);
    }

    public LocalDateTime withDayOfWeek(int dayOfWeek) {
        return this.value.withDayOfWeek(dayOfWeek);
    }

    public LocalDateTime withDayOfYear(int dayOfYear) {
        return this.value.withDayOfYear(dayOfYear);
    }

    public LocalDateTime withHourOfDay(int hourOfDay) {
        return this.value.withHourOfDay(hourOfDay);
    }

    public LocalDateTime withMinuteOfHour(int minuteOfHour) {
        return this.value.withMinuteOfHour(minuteOfHour);
    }

    public LocalDateTime withHourMinute(int hourOfDay, int minuteOfHour) {
        return this.value.withHourOfDay(hourOfDay).withMinuteOfHour(minuteOfHour);
    }

    public LocalDateTime withSecondOfMinute(int secondOfMinute) {
        return this.value.withSecondOfMinute(secondOfMinute);
    }

    public LocalDateTime withMillisOfSecond(int millisOfSecond) {
        return this.value.withMillisOfSecond(millisOfSecond);
    }

    public LocalDateTime startOfWeek() {
        return ic3DateTime.startOfWeek(this.value);
    }

    public LocalDateTime startOfMonth() {
        return ic3DateTime.startOfMonth(this.value);
    }

    public LocalDateTime startOfQuarter() {
        return ic3DateTime.startOfQuarter(this.value);
    }

    public LocalDateTime startOfYear() {
        return ic3DateTime.startOfYear(this.value);
    }

    public LocalDateTime endOfWeek() {
        return ic3DateTime.endOfWeek(this.value);
    }

    public LocalDateTime endOfMonth() {
        return ic3DateTime.endOfMonth(this.value);
    }

    public LocalDateTime endOfQuarter() {
        return ic3DateTime.endOfQuarter(this.value);
    }

    public LocalDateTime endOfYear() {
        return ic3DateTime.endOfYear(this.value);
    }

    public LocalDateTime nextDay() {
        return ic3DateTime.nextDay(this.value);
    }

    public LocalDateTime nextWeek() {
        return ic3DateTime.nextWeek(this.value);
    }

    public LocalDateTime nextMonth() {
        return ic3DateTime.nextMonth(this.value);
    }

    public LocalDateTime nextQuarter() {
        return ic3DateTime.nextQuarter(this.value);
    }

    public LocalDateTime nextYear() {
        return ic3DateTime.nextYear(this.value);
    }

    public LocalDateTime previousDay() {
        return ic3DateTime.previousDay(this.value);
    }

    public LocalDateTime previousWeek() {
        return ic3DateTime.previousWeek(this.value);
    }

    public LocalDateTime previousMonth() {
        return ic3DateTime.previousMonth(this.value);
    }

    public LocalDateTime previousQuarter() {
        return ic3DateTime.previousQuarter(this.value);
    }

    public LocalDateTime previousYear() {
        return ic3DateTime.previousYear(this.value);
    }

    public LocalDateTime value() {
        return this.value;
    }

    public long getLocalMillis() {
        return CdJodaTimeUtil.localMillis((LocalDateTime)this.value);
    }

    @Override
    public CdXmlaSchemaType getXmlaType(@Nullable CdXmlaOptions options) {
        return CdXmlaSchemaType.DBTYPE_DBTIMESTAMP;
    }

    @Override
    public String asXmlaString() {
        return this.asString();
    }

    @Override
    public String asString() {
        return this.value.toString();
    }

    public LocalDateTime asValue() {
        return this.value;
    }

    @Override
    public Class getUnderlyingJavaNativeValueType() {
        return LocalDateTime.class;
    }

    @Override
    public boolean doIsConvertibleToJavaType(Class target) {
        return target.isAssignableFrom(LocalDateTime.class) || target.isAssignableFrom(String.class);
    }

    @Override
    @Nullable
    public Object doAsJavaNativeValue(Class expectedClazz) {
        if (expectedClazz.isAssignableFrom(LocalDateTime.class)) {
            return this.value;
        }
        if (expectedClazz.isAssignableFrom(String.class)) {
            return this.asString();
        }
        return null;
    }

    @Override
    public int getOperatorIndex() {
        return operatorIndex;
    }

    @Override
    public String javaFormat(GFCellPropertyEvalContext context, Locale locale, String pattern) {
        DateTimeFormatterKey key = new DateTimeFormatterKey(locale, pattern);
        DateTimeFormatter df = (DateTimeFormatter)context.getStatementCachedObject(key);
        if (df == null) {
            df = DateTimeFormat.forPattern((String)pattern).withLocale(locale);
            context.addStatementCachedObject(key, df);
        }
        return df.print((ReadablePartial)this.value);
    }

    public static void main(String[] args) {
        LocalDateTime x = new LocalDateTime(1800, 12, 15, 22, 10, 0);
        LocalDateTime y = new LocalDateTime(1500, 12, 15, 22, 10, 0);
        System.out.println("iso : " + x.toString());
        Object df = DateTimeFormat.forPattern((String)"yyyy-MM-dd kk:mm:ss").withLocale(Locale.US);
        System.out.println("joda: " + df.print((ReadablePartial)x));
        df = new SimpleDateFormat("yyyy-MM-dd kk:mm:ss", Locale.US);
        System.out.println("ic3 : " + ((DateFormat)df).format(x.toDateTime().toDate()));
        System.out.println("iso : " + String.valueOf(y));
        df = DateTimeFormat.forPattern((String)"yyyy-MM-dd kk:mm:ss").withLocale(Locale.US);
        System.out.println("joda: " + df.print((ReadablePartial)y));
        df = new SimpleDateFormat("yyyy-MM-dd kk:mm:ss", Locale.US);
        System.out.println("ic3 : " + ((DateFormat)df).format(y.toDateTime().toDate()));
    }

    @Override
    public String excelFormat(GFCellPropertyEvalContext context, Locale locale, String format) {
        String formatted = ExcelPoiFormatter.formatDate(format, locale, this.value);
        return formatted;
    }

    @Override
    public Object toTidyTableValue() {
        return this.value.toString();
    }

    @Override
    public OlapScalarEntityTidyType toTidyTableValueType() {
        return OlapScalarEntityTidyType.DATETIME;
    }

    @Override
    public String toString() {
        return this.value.toString();
    }

    @Override
    public String getFriendlyTypeName() {
        return FRIENDLY_NAME;
    }

    public OlapNumericEntity minus(OlapDateTimeEntity ent2) {
        double days = (this.getLocalMillis() - ent2.getLocalMillis()) / CdJodaTimeUtil.DEFAULT_MILLIS_IN_DAY;
        return new OlapNumericEntity(days);
    }

    public OlapDateTimeEntity plus(OlapNumericEntity ent2) {
        LocalDateTime newValue = this.value.plusMillis((int)(ent2.doubleValue() * (double)CdJodaTimeUtil.DEFAULT_MILLIS_IN_DAY));
        return new OlapDateTimeEntity(newValue);
    }

    public OlapDateTimeEntity minus(OlapNumericEntity ent2) {
        LocalDateTime newValue = this.value.plusMillis((int)(-ent2.doubleValue() * (double)CdJodaTimeUtil.DEFAULT_MILLIS_IN_DAY));
        return new OlapDateTimeEntity(newValue);
    }

    @Override
    public OlapScalarEntity asConstant() {
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OlapDateTimeEntity that = (OlapDateTimeEntity)o;
        return this.value.equals((Object)that.value);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    static class DateTimeFormatterKey {
        private final Locale locale;
        private final String pattern;

        public DateTimeFormatterKey(Locale locale, String pattern) {
            this.locale = locale;
            this.pattern = pattern;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DateTimeFormatterKey that = (DateTimeFormatterKey)o;
            if (!this.locale.equals(that.locale)) {
                return false;
            }
            return this.pattern.equals(that.pattern);
        }

        public int hashCode() {
            int result = this.locale.hashCode();
            result = 31 * result + this.pattern.hashCode();
            return result;
        }
    }
}

