/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.scalar;

import crazydev.common.lang.CdXmlaOptions;
import crazydev.common.lang.CdXmlaSchemaType;
import crazydev.iccube.common.formatter.ExcelPoiFormatter;
import crazydev.iccube.olap.entity.OlapEntityVarType;
import crazydev.iccube.olap.entity.scalar.OlapAbstractScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapDateTimeEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntityTidyType;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFCellPropertyEvalContext;
import crazydev.iccube.olap.eval.operator.scalar.OlapScalarOperators;
import crazydev.iccube.pub.utils.ic3DateTime;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;
import org.joda.time.CdJodaTimeUtil;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class OlapDateEntity
extends OlapAbstractScalarEntity<OlapDateEntity> {
    public static final String FRIENDLY_NAME = "date";
    public static int operatorIndex = OlapScalarOperators.createIndex(OlapDateEntity.class);
    private final LocalDate value;

    public OlapDateEntity(LocalDate value) {
        this.value = value;
    }

    public OlapDateEntity(int year, int monthOfYear, int dayOfMonth) {
        this(new LocalDate(year, monthOfYear, dayOfMonth));
    }

    public OlapDateEntity(Date date) {
        this(new LocalDate((Object)date));
    }

    @Override
    public OlapEntityVarType getVarType() {
        return OlapEntityVarType.DATE;
    }

    public LocalDateTime toDateTime(int hours, int minutes) {
        return this.value.toLocalDateTime(new LocalTime(hours, minutes));
    }

    public LocalDate plusDays(int days) {
        return this.value.plusDays(days);
    }

    public LocalDate plusMonths(int months) {
        return this.value.plusMonths(months);
    }

    public LocalDate plusYears(int years) {
        return this.value.plusYears(years);
    }

    public LocalDate minusDays(int days) {
        return this.value.minusDays(days);
    }

    public LocalDate minusMonths(int months) {
        return this.value.minusMonths(months);
    }

    public LocalDate minusYears(int years) {
        return this.value.minusYears(years);
    }

    public LocalDate withYear(int year) {
        return this.value.withYear(year);
    }

    public LocalDate withMonthOfYear(int monthOfYear) {
        return this.value.withMonthOfYear(monthOfYear);
    }

    public LocalDate withDayOfMonth(int dayOfMonth) {
        return this.value.withDayOfMonth(dayOfMonth);
    }

    public LocalDate withDayOfWeek(int dayOfWeek) {
        return this.value.withDayOfWeek(dayOfWeek);
    }

    public LocalDate withDayOfYear(int dayOfYear) {
        return this.value.withDayOfYear(dayOfYear);
    }

    public LocalDate startOfWeek() {
        return ic3DateTime.startOfWeek(this.value);
    }

    public LocalDate startOfMonth() {
        return ic3DateTime.startOfMonth(this.value);
    }

    public LocalDate startOfQuarter() {
        return ic3DateTime.startOfQuarter(this.value);
    }

    public LocalDate startOfYear() {
        return ic3DateTime.startOfYear(this.value);
    }

    public LocalDate endOfWeek() {
        return ic3DateTime.endOfWeek(this.value);
    }

    public LocalDate endOfMonth() {
        return ic3DateTime.endOfMonth(this.value);
    }

    public LocalDate endOfQuarter() {
        return ic3DateTime.endOfQuarter(this.value);
    }

    public LocalDate endOfYear() {
        return ic3DateTime.endOfYear(this.value);
    }

    public LocalDate nextDay() {
        return ic3DateTime.nextDay(this.value);
    }

    public LocalDate nextWeek() {
        return ic3DateTime.nextWeek(this.value);
    }

    public LocalDate nextMonth() {
        return ic3DateTime.nextMonth(this.value);
    }

    public LocalDate nextQuarter() {
        return ic3DateTime.nextQuarter(this.value);
    }

    public LocalDate nextYear() {
        return ic3DateTime.nextYear(this.value);
    }

    public LocalDate previousDay() {
        return ic3DateTime.previousDay(this.value);
    }

    public LocalDate previousWeek() {
        return ic3DateTime.previousWeek(this.value);
    }

    public LocalDate previousMonth() {
        return ic3DateTime.previousMonth(this.value);
    }

    public LocalDate previousQuarter() {
        return ic3DateTime.previousQuarter(this.value);
    }

    public LocalDate previousYear() {
        return ic3DateTime.previousYear(this.value);
    }

    public LocalDate value() {
        return this.value;
    }

    public int year() {
        return this.value.getYear();
    }

    public int day() {
        return this.value.getDayOfMonth();
    }

    public int month() {
        return this.value.getMonthOfYear();
    }

    public int dayOfWeek() {
        return this.value.getDayOfWeek();
    }

    public int dayOfMonth() {
        return this.value.getDayOfMonth();
    }

    public int dayOfYear() {
        return this.value.getDayOfYear();
    }

    public int weekyear() {
        return this.value.getWeekyear();
    }

    public int weekOfWeekyear() {
        return this.value.getWeekOfWeekyear();
    }

    public long getLocalMillis() {
        return CdJodaTimeUtil.localMillis((LocalDate)this.value);
    }

    @Override
    public CdXmlaSchemaType getXmlaType(@Nullable CdXmlaOptions options) {
        return CdXmlaSchemaType.DBTYPE_DBTIMESTAMP;
    }

    @Override
    public String asXmlaString() {
        return this.value.toLocalDateTime(new LocalTime(0, 0, 0)).toString();
    }

    @Override
    public String asString() {
        return this.value.toString();
    }

    public LocalDate asValue() {
        return this.value;
    }

    @Override
    public Class getUnderlyingJavaNativeValueType() {
        return LocalDate.class;
    }

    @Override
    public boolean doIsConvertibleToJavaType(Class target) {
        return target.isAssignableFrom(LocalDate.class) || target.isAssignableFrom(String.class);
    }

    @Override
    @Nullable
    public Object doAsJavaNativeValue(Class expectedClazz) {
        if (expectedClazz.isAssignableFrom(LocalDate.class)) {
            return this.value;
        }
        if (expectedClazz.isAssignableFrom(String.class)) {
            return this.asString();
        }
        return null;
    }

    @Override
    public int getOperatorIndex() {
        return operatorIndex;
    }

    @Override
    public String javaFormat(GFCellPropertyEvalContext context, Locale locale, String pattern) {
        OlapDateTimeEntity.DateTimeFormatterKey key = new OlapDateTimeEntity.DateTimeFormatterKey(locale, pattern);
        DateTimeFormatter df = (DateTimeFormatter)context.getStatementCachedObject(key);
        if (df == null) {
            df = DateTimeFormat.forPattern((String)pattern).withLocale(locale);
            context.addStatementCachedObject(key, df);
        }
        return df.print((ReadablePartial)this.value);
    }

    public static void main(String[] args) {
        LocalDate x = new LocalDate(1800, 12, 15);
        LocalDate y = new LocalDate(1500, 12, 15);
        System.out.println("iso : " + x.toString());
        Object df = DateTimeFormat.forPattern((String)"yyyy-MM-dd").withLocale(Locale.US);
        System.out.println("joda: " + df.print((ReadablePartial)x));
        df = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
        System.out.println("ic3 : " + ((DateFormat)df).format(x.toDate()));
        System.out.println("iso : " + String.valueOf(y));
        df = DateTimeFormat.forPattern((String)"yyyy-MM-dd").withLocale(Locale.US);
        System.out.println("joda: " + df.print((ReadablePartial)y));
        df = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
        System.out.println("ic3 : " + ((DateFormat)df).format(y.toDate()));
    }

    @Override
    public String excelFormat(GFCellPropertyEvalContext context, Locale locale, String format) {
        String formatted = ExcelPoiFormatter.formatDate(format, locale, this.value);
        return formatted;
    }

    @Override
    public String toTidyTableValue() {
        return this.value.toString();
    }

    @Override
    public OlapScalarEntityTidyType toTidyTableValueType() {
        return OlapScalarEntityTidyType.DATETIME;
    }

    @Override
    public String toString() {
        return this.value.toString();
    }

    @Override
    public String getFriendlyTypeName() {
        return FRIENDLY_NAME;
    }

    public OlapNumericEntity minus(OlapDateEntity ent2) {
        double days = (this.getLocalMillis() - ent2.getLocalMillis()) / CdJodaTimeUtil.DEFAULT_MILLIS_IN_DAY;
        return new OlapNumericEntity(days);
    }

    public OlapDateEntity plus(OlapNumericEntity ent2) {
        LocalDate newValue = this.value.plusDays(ent2.intValue());
        return new OlapDateEntity(newValue);
    }

    public OlapDateEntity minus(OlapNumericEntity ent2) {
        LocalDate newValue = this.value.plusDays(-ent2.intValue());
        return new OlapDateEntity(newValue);
    }

    @Override
    public OlapScalarEntity asConstant() {
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OlapDateEntity that = (OlapDateEntity)o;
        return this.value.equals((Object)that.value);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }
}

