/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.scalar;

import crazydev.common.lang.CdXmlaSchemaType;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.IAggregationScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapAbstractScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;

public class OlapCountAggrEntity
extends OlapNumericEntity
implements IAggregationScalarEntity {
    private static final long serialVersionUID = -5738931646997727799L;

    public OlapCountAggrEntity(OlapAbstractScalarEntity entity) {
        super(0L, false);
        this.aggregate(null, null, entity, OlapAggregationType.COUNT);
    }

    public OlapCountAggrEntity(long count) {
        super(count);
    }

    private OlapCountAggrEntity(CdXmlaSchemaType kind, double value, boolean constant) {
        super(kind, value, constant);
    }

    @Override
    public OlapScalarEntity asNonAggregating(boolean constant) {
        return new OlapNumericEntity(this.kind, this.value, constant);
    }

    @Override
    protected OlapScalarEntity doAsConstant() {
        return new OlapCountAggrEntity(this.kind, this.value, true);
    }

    @Override
    public OlapNumericEntity aggregate(OlapMember[] members, OlapMember measure, OlapScalarEntity entity, OlapAggregationType aggregationType) {
        if (entity.isMdxNull()) {
            return this;
        }
        switch (aggregationType) {
            case COUNT: {
                double value_;
                if (entity instanceof OlapNumericEntity) {
                    OlapNumericEntity aggrEntity = (OlapNumericEntity)entity;
                    value_ = this.value + aggrEntity.value;
                } else {
                    value_ = this.value + 1.0;
                }
                if (!this.constant) {
                    this.value = value_;
                    return this;
                }
                return new OlapCountAggrEntity(this.kind, value_, false);
            }
        }
        throw new RuntimeException("internal error: inconsistent aggregation for COUNTING entity [" + String.valueOf((Object)aggregationType) + "]");
    }

    @Override
    public String toStringForDebugger() {
        return "COUNT: " + this.value;
    }
}

