/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.scalar;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.lang.CdXmlaOptions;
import crazydev.common.lang.CdXmlaSchemaType;
import crazydev.iccube.cluster.shared.schema.S_MeasureDef;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.exception.OlapError;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.exception.OlapException;
import crazydev.iccube.olap.entity.OlapEntityVarType;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapAbstractScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFCellPropertyEvalContext;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public class OlapCellMeasureVectorScalarEntity<T extends OlapScalarEntity<T>>
extends OlapAbstractScalarEntity<T> {
    private final OlapScalarEntity[] values;
    @Nullable
    private final OlapException[] errors;

    public OlapCellMeasureVectorScalarEntity(OlapScalarEntity[] entities) {
        this(entities, null);
    }

    public OlapCellMeasureVectorScalarEntity(OlapScalarEntity[] entities, @Nullable OlapException[] errors) {
        this.values = entities;
        this.errors = errors;
    }

    @Override
    public OlapEntityVarType getVarType() {
        return OlapEntityVarType.CELL_MEASURE_VECTOR;
    }

    public OlapScalarEntity[] getEntities() {
        return this.values;
    }

    @Nullable
    public OlapException[] getErrors() {
        return this.errors;
    }

    @Override
    public CdXmlaSchemaType getXmlaType(@Nullable CdXmlaOptions options) {
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Override
    public String asXmlaString() {
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Override
    public String asString() {
        return "cell-measure-vector";
    }

    @Override
    public Object asValue() {
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Override
    public Class getUnderlyingJavaNativeValueType() {
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Override
    public boolean isConvertibleToJavaNativeValueType(Class target) {
        return false;
    }

    @Override
    protected boolean doIsConvertibleToJavaType(Class target) {
        return false;
    }

    @Override
    @Nullable
    public Object doAsJavaNativeValue(Class<?> expectedClass) {
        throw new CdShouldNotBeHereProgrammingException();
    }

    public OlapScalarEntity toEmptyZeroIfNeeded(S_MeasureDef[] measureDefs) {
        if (this.values.length != measureDefs.length) {
            return this;
        }
        OlapScalarEntity[] entities_ = null;
        for (int ii = 0; ii < measureDefs.length; ++ii) {
            S_MeasureDef measureDef = measureDefs[ii];
            OlapScalarEntity entity = this.values[ii];
            OlapScalarEntity entity_ = measureDef.toEmptyZeroIfNeeded(entity);
            if (entity_ == entity) continue;
            if (entities_ == null) {
                entities_ = new OlapScalarEntity[this.values.length];
                System.arraycopy(this.values, 0, entities_, 0, this.values.length);
            }
            entities_[ii] = entity_;
        }
        if (entities_ != null) {
            return new OlapCellMeasureVectorScalarEntity<T>(entities_);
        }
        return this;
    }

    @Override
    public OlapScalarEntity asInitialValueFor(OlapMember[] members, OlapMember measure, OlapAggregationType aggregationType) {
        throw new OlapEvaluationException(new OlapError(OlapErrorCode.AGGREGATION_NOT_SUPPORTED_FOR_TYPE, new Serializable[]{aggregationType, this.getFriendlyTypeName()}));
    }

    @Override
    public T aggregate(OlapMember[] members, OlapMember measure, OlapScalarEntity entity, OlapAggregationType aggregationType) {
        throw new OlapEvaluationException(new OlapError(OlapErrorCode.AGGREGATION_NOT_SUPPORTED_FOR_TYPE, new Serializable[]{aggregationType, this.getFriendlyTypeName()}));
    }

    @Override
    public int getOperatorIndex() {
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Override
    public String getFriendlyTypeName() {
        return "cell-measure-vector";
    }

    @Override
    @Nullable
    public String javaFormat(GFCellPropertyEvalContext context, Locale locale, String pattern) {
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Override
    @Nullable
    public String excelFormat(GFCellPropertyEvalContext context, Locale locale, String format) {
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Override
    public OlapScalarEntity multiplyByZero() {
        OlapScalarEntity[] newEntities = new OlapScalarEntity[this.values.length];
        for (int ii = 0; ii < this.values.length; ++ii) {
            newEntities[ii] = this.values[ii].multiplyByZero();
        }
        return new OlapCellMeasureVectorScalarEntity<T>(newEntities);
    }

    @Override
    public boolean isZero() {
        for (OlapScalarEntity entity : this.values) {
            if (entity.isZero()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toStringForDebugger() {
        return "cellMeasureVector(...)";
    }

    @Override
    public String toString() {
        return "cellMeasureVector(...)";
    }

    @Override
    public OlapScalarEntity asConstant() {
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OlapCellMeasureVectorScalarEntity that = (OlapCellMeasureVectorScalarEntity)o;
        return Arrays.equals(this.values, that.values);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.values);
    }
}

