/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.scalar;

import crazydev.common.lang.CdXmlaOptions;
import crazydev.common.lang.CdXmlaSchemaType;
import crazydev.iccube.olap.entity.OlapEntityVarType;
import crazydev.iccube.olap.entity.scalar.OlapAbstractScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntityTidyType;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFCellPropertyEvalContext;
import crazydev.iccube.olap.eval.operator.scalar.OlapScalarOperators;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public class OlapBooleanEntity
extends OlapAbstractScalarEntity<OlapBooleanEntity> {
    public static final String FRIENDLY_NAME = "boolean";
    public static final OlapBooleanEntity TRUE = new OlapBooleanEntity(true);
    public static final OlapBooleanEntity FALSE = new OlapBooleanEntity(false);
    public static int operatorIndex = OlapScalarOperators.createIndex(OlapBooleanEntity.class);
    private final boolean value;

    private OlapBooleanEntity(boolean value) {
        this.value = value;
    }

    public static OlapBooleanEntity value(boolean value) {
        return value ? TRUE : FALSE;
    }

    @Override
    public OlapEntityVarType getVarType() {
        return OlapEntityVarType.BOOLEAN;
    }

    public boolean value() {
        return this.value;
    }

    @Override
    public CdXmlaSchemaType getXmlaType(@Nullable CdXmlaOptions options) {
        return CdXmlaSchemaType.DBTYPE_BOOL;
    }

    @Override
    public String asXmlaString() {
        return this.asString();
    }

    @Override
    public String asString() {
        return String.valueOf(this.value);
    }

    @Override
    public Boolean asValue() {
        return this.value;
    }

    @Override
    public Class getUnderlyingJavaNativeValueType() {
        return Boolean.TYPE;
    }

    @Override
    public boolean doIsConvertibleToJavaType(Class target) {
        return Boolean.class.equals((Object)target) || Boolean.TYPE.equals(target) || Long.class.equals((Object)target) || Long.TYPE.equals(target) || Integer.class.equals((Object)target) || Integer.TYPE.equals(target) || target.isAssignableFrom(String.class);
    }

    @Override
    public Object doAsJavaNativeValue(Class expectedClazz) {
        if (expectedClazz == Boolean.TYPE || expectedClazz == Boolean.class) {
            return this.value;
        }
        if (expectedClazz == Long.TYPE || expectedClazz == Long.class) {
            return this.value ? 1L : 0L;
        }
        if (expectedClazz == Integer.TYPE || expectedClazz == Integer.class) {
            return this.value ? 1 : 0;
        }
        if (expectedClazz == Double.TYPE || expectedClazz == Double.class) {
            return this.value ? 1.0 : 0.0;
        }
        if (expectedClazz == Float.TYPE || expectedClazz == Float.class) {
            return Float.valueOf((float)(this.value ? 1.0 : 0.0));
        }
        if (expectedClazz.isAssignableFrom(String.class)) {
            return this.asString();
        }
        return null;
    }

    @Override
    public int getOperatorIndex() {
        return operatorIndex;
    }

    @Override
    public String javaFormat(GFCellPropertyEvalContext context, Locale locale, String pattern) {
        String formatted = String.format(locale, pattern, this.value);
        return formatted;
    }

    @Override
    public String excelFormat(GFCellPropertyEvalContext context, Locale locale, String format) {
        return this.value ? "True" : "False";
    }

    @Override
    public Object toTidyTableValue() {
        return this.value;
    }

    @Override
    public OlapScalarEntityTidyType toTidyTableValueType() {
        return OlapScalarEntityTidyType.LOGICAL;
    }

    @Override
    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public String getFriendlyTypeName() {
        return FRIENDLY_NAME;
    }

    @Override
    public OlapScalarEntity asConstant() {
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OlapBooleanEntity that = (OlapBooleanEntity)o;
        return this.value == that.value;
    }

    @Override
    public int hashCode() {
        return this.value ? 1 : 0;
    }
}

