/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.scalar;

import crazydev.common.exception.CdRuntimeException;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.exception.OlapError;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.OlapAbstractEntity;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapCountAggrEntity;
import crazydev.iccube.olap.entity.scalar.OlapCountUniqueAggrEntity;
import crazydev.iccube.olap.entity.scalar.OlapMinMaxAggrEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntityTidyType;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public abstract class OlapAbstractScalarEntity<T extends OlapScalarEntity<T>>
extends OlapAbstractEntity
implements OlapScalarEntity<T> {
    private static final long serialVersionUID = 308693981317973640L;

    @Override
    public OlapScalarEntity toValue(GFContext context, GFTupleEvaluator evaluator) {
        return this;
    }

    @Override
    public boolean isToValueApplicable(GFContext context, GFTupleEvaluator evaluator) {
        return true;
    }

    @Override
    public OlapScalarEntity asNonAggregating(boolean constant) {
        return this;
    }

    @Override
    public abstract OlapScalarEntity asConstant();

    @Override
    public OlapScalarEntity asInitialValueFor(OlapMember[] members, OlapMember measure, OlapAggregationType aggregationType) {
        switch (aggregationType) {
            case SUM: 
            case SUM_HIGH_PRECISION: 
            case AVG_LEAVES: {
                return this;
            }
            case MIN: 
            case MAX: {
                return new OlapMinMaxAggrEntity(this, false);
            }
            case COUNT: {
                return new OlapCountAggrEntity(this);
            }
            case DISTINCT_COUNT: {
                return new OlapCountUniqueAggrEntity(this);
            }
        }
        throw new OlapEvaluationException(new OlapError(OlapErrorCode.AGGREGATION_NOT_SUPPORTED_FOR_TYPE, new Serializable[]{aggregationType, this.getFriendlyTypeName()}));
    }

    @Override
    public T aggregate(OlapMember[] members, OlapMember measure, OlapScalarEntity entity, OlapAggregationType aggregationType) {
        throw new OlapEvaluationException(new OlapError(OlapErrorCode.AGGREGATION_NOT_SUPPORTED_FOR_TYPE, new Serializable[]{aggregationType, this.getFriendlyTypeName()}));
    }

    @Override
    public OlapScalarEntity asEntityForOperator() {
        return this;
    }

    @Override
    public boolean isStringForOperator() {
        return false;
    }

    @Override
    public boolean isConvertibleToJavaNativeValueType(Class target) {
        if (Object.class.equals((Object)target)) {
            return true;
        }
        return this.doIsConvertibleToJavaType(target);
    }

    protected abstract boolean doIsConvertibleToJavaType(Class var1);

    @Override
    public final Object asJavaNativeValue(Class<?> expectedClass) {
        if (expectedClass == Object.class) {
            Object val = this.asValue();
            return val;
        }
        if (expectedClass == this.getClass()) {
            return this;
        }
        return this.doAsJavaNativeValue(expectedClass);
    }

    @Nullable
    public abstract Object doAsJavaNativeValue(Class<?> var1);

    public static OlapScalarEntity aggregate(@Nullable OlapMember[] members, @Nullable OlapMember measure, @Nullable OlapScalarEntity aggregated, OlapScalarEntity value, OlapAggregationType aggregationType) {
        if (aggregated == null) {
            return value.asInitialValueFor(members, measure, aggregationType);
        }
        return aggregated.aggregate(members, measure, value, aggregationType);
    }

    @Override
    public abstract boolean equals(Object var1);

    @Override
    public abstract int hashCode();

    @Override
    public String toStringForDebugger() {
        return this.asString();
    }

    @Override
    public String toStringForDebuggerAsValue() {
        return this.toStringForDebugger();
    }

    public abstract String toString();

    @Override
    public OlapScalarEntity multiplyByZero() {
        throw new CdRuntimeException("Zero is not supported for type " + this.getFriendlyTypeName());
    }

    @Override
    public boolean isZero() {
        throw new CdRuntimeException("Zero is not supported for type " + this.getFriendlyTypeName());
    }

    protected static String _doFormat(int size, Accessor list, String prefix, String suffix, String delimiter, int limitSizeKb) {
        StringBuilder buffer = new StringBuilder();
        boolean cut = false;
        buffer.append(prefix);
        for (int i = 0; i < size; ++i) {
            buffer.append(i == 0 ? "" : delimiter);
            buffer.append(list.get(i));
            if (limitSizeKb == -1 || buffer.length() <= limitSizeKb * 1000) continue;
            cut = true;
            break;
        }
        if (cut) {
            if (limitSizeKb != -1) {
                buffer.setLength(limitSizeKb * 1000);
            }
            buffer.append("...");
        }
        buffer.append(suffix);
        return buffer.toString();
    }

    @Override
    @Nullable
    public Object toTidyTableValue() {
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Override
    public OlapScalarEntityTidyType toTidyTableValueType() {
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Override
    @Nullable
    public OlapScalarEntityTidyType toTidyTableValueSubType() {
        return null;
    }

    @Override
    @Nullable
    public Number toLatLongValue() {
        return null;
    }

    @FunctionalInterface
    protected static interface Accessor {
        public String get(int var1);
    }
}

