/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.result.tidy.serialize;

import crazydev.common.utils.CdSizeUtils;
import crazydev.iccube.configuration.component.OlapEngineResultSerializationConfiguration;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.entity.result.tidy.serialize.IOlapSerializedTidyResource;
import crazydev.iccube.olap.entity.result.tidy.serialize.OlapFileSerializedTidyResource;
import crazydev.iccube.olap.entity.result.tidy.serialize.OlapFileSerializedTidyResourceCB;
import crazydev.iccube.olap.entity.result.tidy.serialize.OlapMemorySerializedTidyResource;
import crazydev.iccube.olap.entity.result.tidy.serialize.OlapSerializedTidyResourceCompression;
import crazydev.iccube.olap.entity.result.tidy.serialize.OlapSerializedTidyResourceMode;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.IOException;

public class OlapSerializedTidyResourceFactory {
    public static IOlapSerializedTidyResource create(Prefix prefix, OlapEngineRequestContext context, OlapFileSerializedTidyResourceCB cb) throws IOException {
        IOlapSerializedTidyResource resource;
        OlapEngineResultSerializationConfiguration configuration = context.getResultSerializationConfiguration();
        OlapSerializedTidyResourceMode mode = configuration.getMode();
        OlapSerializedTidyResourceCompression compression = configuration.getCompression();
        OlapLoggers.MDX_EVALUATION.debug((Object)("[" + String.valueOf((Object)prefix) + "] serialize tidy table as JSON started [" + String.valueOf((Object)mode) + "][" + String.valueOf((Object)compression) + "]"));
        if (mode == OlapSerializedTidyResourceMode.FILE) {
            resource = OlapFileSerializedTidyResource.create(context.asRuntimeContext(), compression, cb);
        } else if (mode == OlapSerializedTidyResourceMode.MEMORY) {
            resource = OlapMemorySerializedTidyResource.create(compression, cb);
        } else {
            throw new RuntimeException("internal error : unexpected serialization mode [" + String.valueOf((Object)mode) + "]");
        }
        OlapLoggers.MDX_EVALUATION.debug((Object)("[" + String.valueOf((Object)prefix) + "] serialize tidy table as JSON done [" + CdSizeUtils.format((double)resource.length()) + "]"));
        return resource;
    }

    public static enum Prefix {
        mdx,
        sql;

    }
}

