/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.result.tidy.debug;

import crazydev.common.collection.CdStrPair;
import crazydev.iccube.olap.entity.result.tidy.TidyTableClassID;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResMdxTidyMaterializedTableCellError;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResTidyMaterializedTableColumn;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public abstract class OlapResTidyMaterializedTable<COL extends OlapResTidyMaterializedTableColumn> {
    private final String classID;
    protected final int rowCount;
    protected final int tidyMaxRowCount;
    protected final boolean tidyMaxRowCountReached;
    private final boolean withPaging;
    private final Map<String, Object> query;
    @Nullable
    private Map<Integer, OlapResTidyMaterializedTable<?>> steps;
    private long executionTimeMS;

    public OlapResTidyMaterializedTable(TidyTableClassID classID, Map<String, Object> query, int rowCount, int tidyMaxRowCount, boolean tidyMaxRowCountReached, boolean withPaging) {
        this.classID = classID.name();
        this.rowCount = rowCount;
        this.tidyMaxRowCount = tidyMaxRowCount;
        this.tidyMaxRowCountReached = tidyMaxRowCountReached;
        this.withPaging = withPaging;
        this.query = query;
    }

    public void setNaN() {
        if (this.steps != null) {
            for (OlapResTidyMaterializedTable<?> step : this.steps.values()) {
                step.setNaN();
            }
        }
    }

    public long getExecutionTimeMS() {
        return this.executionTimeMS;
    }

    public int getTidyMaxRowCount() {
        return this.tidyMaxRowCount;
    }

    public boolean isTidyMaxRowCountReached() {
        return this.tidyMaxRowCountReached;
    }

    public boolean isWithPaging() {
        return this.withPaging;
    }

    @Nullable
    public abstract OlapResMdxTidyMaterializedTableCellError getCellError();

    public abstract List<COL> getColumns();

    public void addStep(int step, OlapResTidyMaterializedTable<? extends OlapResTidyMaterializedTableColumn> table) {
        if (this.steps == null) {
            this.steps = new HashMap();
        }
        this.steps.put(step, table);
    }

    public void addCacheProperty(String key, Object value) {
        this.query.put(key, value);
    }

    public void addCacheProperties(List<CdStrPair> properties) {
        for (CdStrPair info : properties) {
            this.addCacheProperty((String)info.fst, info.snd);
        }
    }
}

