/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.result.tidy.debug;

import crazydev.common.mdx.CdMdxUtils;
import crazydev.iccube.olap.entity.member.OlapMemberUniqueNameType;
import crazydev.iccube.olap.entity.result.tidy.OlapResTidyTableMdxInfo;
import crazydev.iccube.olap.entity.result.tidy.TidyTableColumnNaN;
import crazydev.iccube.olap.entity.result.tidy.TidyTableDimensionPropertyColumnMeta;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResMdxTidyMaterializedTableAllMemberInfo;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResMdxTidyMaterializedTableMembersInfoLevel;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntityTidyType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class OlapResMdxTidyMaterializedTableMembersInfo {
    private final int axis;
    private final boolean hasNonEmpty;
    private final int hierarchyIdx;
    private final List<Integer> memberInfoIndices;
    @Nullable
    private final OlapResMdxTidyMaterializedTableAllMemberInfo allMember;
    private final List<String> names;
    @Nullable
    private final List<String> captions;
    private final List<?> uniqueNames;
    private final List<Integer> childrenCounts;
    private final List<String> levelCaptions;
    private final List<String> levelNames;
    private final List<String> levelUniqueNames;
    private final List<Integer> levelDepths;
    private final List<Integer> levelDepthsR;
    @Nullable
    private final List<Object> keys;
    private final boolean keysN;
    private final boolean keysUC;
    @Nullable
    private final List<String> parentUniqueNames;
    @Nullable
    private final List<Boolean> alls;
    @Nullable
    private final List<String> formatStrings;
    @Nullable
    private final List<String> colors;
    @Nullable
    private final List<String> ic3iso2;
    @Nullable
    private final List<Number> ic3lat;
    @Nullable
    private final List<Number> ic3long;
    @Nullable
    private final Map<String, TidyTableDimensionPropertyColumnMeta> dpMetas;
    @Nullable
    private final List<String> dpNames;
    @Nullable
    private final Map<String, OlapScalarEntityTidyType> dpTypes;
    @Nullable
    private final Map<String, ArrayList<Object>> dpValues;
    @Nullable
    private Map<String, TidyTableColumnNaN> dpValuesN;

    public OlapResMdxTidyMaterializedTableMembersInfo(int axis, boolean hasNonEmpty, int hierarchyIdx, List<Integer> memberInfoIndices, List<String> names, @Nullable List<String> captions, List<?> uniqueNames, List<Integer> childrenCounts, List<String> levelCaptions, List<String> levelNames, List<String> levelUniqueNames, List<Integer> levelDepths, List<Integer> levelDepthsR, @Nullable List<Object> keys, @Nullable List<String> parentUniqueNames, @Nullable List<Boolean> alls, @Nullable List<String> formatStrings, @Nullable List<String> colors, @Nullable List<String> ic3iso2, @Nullable List<Number> ic3lat, @Nullable List<Number> ic3long, @Nullable Map<String, TidyTableDimensionPropertyColumnMeta> dpMetas, @Nullable List<String> dpNames, @Nullable Map<String, OlapScalarEntityTidyType> dpTypes, @Nullable Map<String, ArrayList<Object>> dpValues) {
        this.axis = axis;
        this.hasNonEmpty = hasNonEmpty;
        this.hierarchyIdx = hierarchyIdx;
        this.memberInfoIndices = memberInfoIndices;
        this.allMember = null;
        this.names = names;
        this.captions = captions;
        this.uniqueNames = uniqueNames;
        this.childrenCounts = childrenCounts;
        this.levelCaptions = levelCaptions;
        this.levelNames = levelNames;
        this.levelUniqueNames = levelUniqueNames;
        this.levelDepths = levelDepths;
        this.levelDepthsR = levelDepthsR;
        this.keys = keys;
        this.keysN = false;
        this.keysUC = false;
        this.parentUniqueNames = parentUniqueNames;
        this.alls = alls;
        this.formatStrings = formatStrings;
        this.colors = colors;
        this.ic3iso2 = ic3iso2;
        this.ic3lat = ic3lat;
        this.ic3long = ic3long;
        this.dpMetas = dpMetas;
        this.dpNames = dpNames;
        this.dpTypes = dpTypes;
        this.dpValues = dpValues;
    }

    public OlapResMdxTidyMaterializedTableMembersInfo(int axis, boolean hasNonEmpty, int hierarchyIdx, List<Integer> memberInfoIndices, @Nullable OlapResMdxTidyMaterializedTableAllMemberInfo allMember, List<String> names, @Nullable List<String> captions, List<?> uniqueNames, List<Integer> childrenCounts, OlapResMdxTidyMaterializedTableMembersInfoLevel level, @Nullable List<Object> keys, boolean keysN, boolean keysUC, @Nullable List<String> parentUniqueNames, @Nullable List<Boolean> alls, @Nullable List<String> formatStrings, @Nullable List<String> colors, @Nullable List<String> ic3iso2, @Nullable List<Number> ic3lat, @Nullable List<Number> ic3long, @Nullable Map<String, TidyTableDimensionPropertyColumnMeta> dpMetas, @Nullable List<String> dpNames, @Nullable Map<String, OlapScalarEntityTidyType> dpTypes, @Nullable Map<String, ArrayList<Object>> dpValues) {
        this.axis = axis;
        this.hasNonEmpty = hasNonEmpty;
        this.hierarchyIdx = hierarchyIdx;
        this.memberInfoIndices = memberInfoIndices;
        this.allMember = allMember;
        this.names = names;
        this.captions = captions;
        this.uniqueNames = uniqueNames;
        this.childrenCounts = childrenCounts;
        this.levelCaptions = Collections.singletonList(level.levelCaption);
        this.levelNames = Collections.singletonList(level.levelName);
        this.levelUniqueNames = Collections.singletonList(level.levelUniqueName);
        this.levelDepths = Collections.singletonList(level.levelDepth);
        this.levelDepthsR = Collections.singletonList(level.levelDepthR);
        this.keys = keys;
        this.keysN = keysN;
        this.keysUC = keysUC;
        this.parentUniqueNames = parentUniqueNames;
        this.alls = alls;
        this.formatStrings = formatStrings;
        this.colors = colors;
        this.ic3iso2 = ic3iso2;
        this.ic3lat = ic3lat;
        this.ic3long = ic3long;
        this.dpMetas = dpMetas;
        this.dpNames = dpNames;
        this.dpTypes = dpTypes;
        this.dpValues = dpValues;
    }

    public void setNaN() {
        if (this.dpValues != null && this.dpValuesN == null) {
            this.dpValuesN = new HashMap<String, TidyTableColumnNaN>();
            for (Map.Entry<String, ArrayList<Object>> entry : this.dpValues.entrySet()) {
                TidyTableColumnNaN valuesN;
                String prop = entry.getKey();
                ArrayList<Object> values = entry.getValue();
                if (values == null || (valuesN = TidyTableColumnNaN.createNaN(values)) == null) continue;
                this.dpValuesN.put(prop, valuesN);
            }
            if (this.dpValuesN.isEmpty()) {
                this.dpValuesN = null;
            }
        }
    }

    public int getMemberIndex(int tupleIndex) {
        return this.memberInfoIndices.get(tupleIndex);
    }

    public String getName(int memberIndex) {
        if (this.allMember != null && this.allMember.index == memberIndex) {
            return this.allMember.name;
        }
        return this.names.get(memberIndex);
    }

    @Nullable
    public String getParentUniqueName(int memberIndex) {
        if (this.allMember != null && this.allMember.index == memberIndex) {
            return null;
        }
        return this.parentUniqueNames != null ? this.parentUniqueNames.get(this.parentUniqueNames.size() == 1 ? 0 : memberIndex) : null;
    }

    @Nullable
    public Object getKey(int memberIndex) {
        if (this.allMember != null && this.allMember.index == memberIndex) {
            return this.allMember.key;
        }
        return this.keys != null ? this.keys.get(memberIndex) : (this.keysN ? this.fixKeyCase(this.getName(memberIndex)) : null);
    }

    private String fixKeyCase(String name) {
        return this.keysUC ? name.toUpperCase() : name;
    }

    public String getUniqueName(int memberIndex) {
        Double und;
        if (this.allMember != null && this.allMember.index == memberIndex) {
            return this.allMember.uniqueName;
        }
        Object un = this.uniqueNames.get(this.uniqueNames.size() == 1 ? 0 : memberIndex);
        if (un instanceof String) {
            String uns = (String)un;
            return uns;
        }
        if (un instanceof Integer) {
            Integer uni = (Integer)un;
            OlapMemberUniqueNameType uniqueNameType = OlapMemberUniqueNameType.fromTidyTableValue(uni);
            return this.generateUniqueName(uniqueNameType, memberIndex);
        }
        if (un instanceof Double && (und = (Double)un) == Math.rint(und)) {
            OlapMemberUniqueNameType uniqueNameType = OlapMemberUniqueNameType.fromTidyTableValue(und.intValue());
            return this.generateUniqueName(uniqueNameType, memberIndex);
        }
        throw new RuntimeException("internal error : unexpected member unique type : " + String.valueOf(un));
    }

    private String generateUniqueName(OlapMemberUniqueNameType uniqueNameType, int memberIndex) {
        return switch (uniqueNameType) {
            case OlapMemberUniqueNameType.LEVEL_KEY -> this.generateUniqueNameLevelKey(memberIndex);
            case OlapMemberUniqueNameType.LEVEL_NAME -> this.generateUniqueNameLevelName(memberIndex);
            case OlapMemberUniqueNameType.PARENT_KEY -> this.generateUniqueNameParentKey(memberIndex);
            case OlapMemberUniqueNameType.PARENT_NAME -> this.generateUniqueNameParentName(memberIndex);
            default -> throw new RuntimeException("internal error : unexpected unique type [" + String.valueOf((Object)uniqueNameType) + "]");
        };
    }

    private String generateUniqueNameLevelKey(int memberIndex) {
        String levelUniqueName = this.getLevelUniqueName(memberIndex);
        Object key = this.getKey(memberIndex);
        return levelUniqueName + ".&[" + CdMdxUtils.escape((String)key.toString()) + "]";
    }

    private String generateUniqueNameLevelName(int memberIndex) {
        String levelUniqueName = this.getLevelUniqueName(memberIndex);
        String name = this.names.get(memberIndex);
        return levelUniqueName + ".[" + CdMdxUtils.escape((String)name) + "]";
    }

    private String generateUniqueNameParentKey(int memberIndex) {
        String parentUniqueName = this.getParentUniqueName(memberIndex);
        Object key = this.getKey(memberIndex);
        return parentUniqueName + ".&[" + CdMdxUtils.escape((String)key.toString()) + "]";
    }

    private String generateUniqueNameParentName(int memberIndex) {
        String parentUniqueName = this.getParentUniqueName(memberIndex);
        String name = this.names.get(memberIndex);
        return parentUniqueName + ".[" + CdMdxUtils.escape((String)name) + "]";
    }

    public String getLevelUniqueName(int memberIndex) {
        if (this.allMember != null && this.allMember.index == memberIndex) {
            return this.allMember.level.levelUniqueName;
        }
        return this.levelUniqueNames.get(this.levelUniqueNames.size() == 1 ? 0 : memberIndex);
    }

    public String getLevelCaption(int memberIndex) {
        if (this.allMember != null && this.allMember.index == memberIndex) {
            return this.allMember.level.levelCaption;
        }
        return this.levelCaptions.get(this.levelCaptions.size() == 1 ? 0 : memberIndex);
    }

    public int getLevelDepth(int memberIndex) {
        if (this.allMember != null && this.allMember.index == memberIndex) {
            return this.allMember.level.levelDepth;
        }
        return this.levelDepths.get(this.levelDepths.size() == 1 ? 0 : memberIndex);
    }

    public int getLevelDepthR(int memberIndex) {
        if (this.allMember != null && this.allMember.index == memberIndex) {
            return this.allMember.level.levelDepthR;
        }
        return this.levelDepthsR.get(this.levelDepthsR.size() == 1 ? 0 : memberIndex);
    }

    public String getCaption(int memberIndex) {
        if (this.allMember != null && this.allMember.index == memberIndex) {
            return this.allMember.caption;
        }
        return this.captions != null ? this.captions.get(memberIndex) : this.getName(memberIndex);
    }

    public int getChildrenCount(int memberIndex) {
        if (this.allMember != null && this.allMember.index == memberIndex) {
            return this.allMember.childrenCount;
        }
        return this.childrenCounts.get(this.childrenCounts.size() == 1 ? 0 : memberIndex);
    }

    public boolean isAll(int memberIndex) {
        if (this.allMember != null && this.allMember.index == memberIndex) {
            return true;
        }
        return this.alls != null && this.alls.get(this.alls.size() == 1 ? 0 : memberIndex) == Boolean.TRUE;
    }

    public String getFormatString(int memberIndex) {
        if (this.allMember != null && this.allMember.index == memberIndex) {
            return this.allMember.formatString;
        }
        return this.formatStrings != null ? this.formatStrings.get(this.formatStrings.size() == 1 ? 0 : memberIndex) : null;
    }

    @Nullable
    public String getIc3Iso2(int memberIndex) {
        if (this.ic3iso2 != null) {
            return this.ic3iso2.get(memberIndex);
        }
        return null;
    }

    @Nullable
    public Number getIc3Lat(int memberIndex) {
        if (this.ic3lat != null) {
            return this.ic3lat.get(memberIndex);
        }
        return null;
    }

    @Nullable
    public Number getIc3Long(int memberIndex) {
        if (this.ic3long != null) {
            return this.ic3long.get(memberIndex);
        }
        return null;
    }

    @Nullable
    public String getColor(int memberIndex) {
        if (this.colors != null) {
            return this.colors.get(memberIndex);
        }
        return null;
    }

    @Nullable
    public List<String> getDpNames() {
        return this.dpNames;
    }

    @Nullable
    public OlapScalarEntityTidyType getDpType(String prop) {
        if (this.dpTypes == null) {
            return null;
        }
        return this.dpTypes.get(prop);
    }

    @Nullable
    public List<Object> getDpValues(String prop) {
        if (this.dpValues == null) {
            return null;
        }
        return this.dpValues.get(prop);
    }

    public OlapResTidyTableMdxInfo getMdxInfo(String hierUN, int memberIndex) {
        String name = this.getName(memberIndex);
        String caption = this.getCaption(memberIndex);
        String un = this.getUniqueName(memberIndex);
        Object key = this.getKey(memberIndex);
        String pun = this.getParentUniqueName(memberIndex);
        boolean isAll = this.isAll(memberIndex);
        int cc = this.getChildrenCount(memberIndex);
        String levelCaption = this.getLevelCaption(memberIndex);
        int levelDepthR = this.getLevelDepthR(memberIndex);
        int levelDepth = this.getLevelDepth(memberIndex);
        return new OlapResTidyTableMdxInfo(name, caption, un, key, isAll, pun, cc, levelCaption, levelDepthR, levelDepth, hierUN);
    }
}

