/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.result.tidy.debug;

import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.result.tidy.OlapResMdxTidyUtils;
import crazydev.iccube.olap.entity.result.tidy.TidyTableColumnNaN;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResMdxTidyMaterializedTableCellError;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntityTidyType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapResMdxTidyMaterializedTableCellsPage {
    private final String name;
    private final String caption;
    private final OlapScalarEntityTidyType type;
    @Nullable
    private final OlapScalarEntityTidyType typeParam;
    private final ArrayList<Object> values;
    @Nullable
    private TidyTableColumnNaN valuesN;
    @Nullable
    private final List<OlapResMdxTidyMaterializedTableCellError> errors;
    @Nullable
    private final List<String> formattedValues;
    @Nullable
    private final List<String> backColors;
    @Nullable
    private final List<String> foreColors;

    public OlapResMdxTidyMaterializedTableCellsPage(String name, String caption, OlapScalarEntityTidyType type, @Nullable OlapScalarEntityTidyType typeParam, ArrayList<Object> values, @Nullable List<OlapResMdxTidyMaterializedTableCellError> errors, @Nullable List<String> formattedValues, @Nullable List<String> backColors, @Nullable List<String> foreColors) {
        this.name = name;
        this.caption = caption;
        this.type = type;
        this.typeParam = typeParam;
        this.values = values;
        this.errors = errors;
        this.formattedValues = formattedValues;
        this.backColors = backColors;
        this.foreColors = foreColors;
    }

    public void setNaN() {
        if (this.valuesN == null) {
            this.valuesN = TidyTableColumnNaN.createNaN(this.values);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getCaption() {
        return this.caption;
    }

    public OlapScalarEntityTidyType getType() {
        return this.type;
    }

    public OlapScalarEntityTidyType getTypeParam() {
        return this.typeParam;
    }

    public ArrayList<Object> getValues() {
        return this.values;
    }

    @Nullable
    public List<OlapResMdxTidyMaterializedTableCellError> getErrors() {
        return this.errors;
    }

    @Nullable
    public List<String> getFormattedValues() {
        return this.formattedValues;
    }

    @Nullable
    public List<String> getBackColors() {
        return this.backColors;
    }

    @Nullable
    public List<String> getForeColors() {
        return this.foreColors;
    }

    public String prettyPrintValueOrError(int rowIndex) {
        OlapResMdxTidyMaterializedTableCellError error;
        if (this.errors != null && (error = this.errors.get(rowIndex)) != null) {
            return error.getErrorCode();
        }
        Object value = this.values.get(rowIndex);
        if (value == null) {
            return "<empty>";
        }
        return value.toString();
    }

    public void assertValueEquals(String name, String caption, Object[][] expected, int column) {
        OlapResMdxTidyUtils.assertEquals("name", this.name, name);
        OlapResMdxTidyUtils.assertEquals("caption", this.caption, caption);
        OlapResMdxTidyUtils.assertEquals("values count", expected.length, this.values.size());
        for (int rr = 0; rr < expected.length; ++rr) {
            Object expectedValue = expected[rr][column];
            Object value = this.values.get(rr);
            OlapResMdxTidyUtils.assertEquals("value:" + rr, expectedValue, value);
        }
    }

    public void assertEquals(OlapResMdxTidyMaterializedTableCellsPage other) {
        OlapResMdxTidyUtils.assertEquals("name", this.name, other.name);
        OlapResMdxTidyUtils.assertEquals("caption", this.caption, other.caption);
        OlapResMdxTidyUtils.assertEquals("type", (Object)this.type, (Object)other.type);
        OlapResMdxTidyUtils.assertEquals("type-param", (Object)this.typeParam, (Object)other.typeParam);
        OlapResMdxTidyUtils.assertNull("errors", this.errors);
        OlapResMdxTidyUtils.assertNull("errors", other.errors);
        OlapResMdxTidyUtils.assertFalse("values not empty", this.values.isEmpty());
        OlapResMdxTidyUtils.assertEquals("values count", this.values.size(), other.values.size());
        OlapResMdxTidyUtils.assertEquals("values", this.values, other.values);
        if (this.formattedValues != null || other.formattedValues != null) {
            OlapResMdxTidyUtils.assertNotNull("formatted-values", this.formattedValues);
            OlapResMdxTidyUtils.assertNotNull("formatted-values", other.formattedValues);
            OlapResMdxTidyUtils.assertFalse("formatted-values not empty", this.formattedValues.isEmpty());
            OlapResMdxTidyUtils.assertEquals("formatted-values count", this.formattedValues.size(), other.formattedValues.size());
            OlapResMdxTidyUtils.assertEquals("formatted-values", this.formattedValues, other.formattedValues);
        }
        if (this.backColors != null || other.backColors != null) {
            OlapResMdxTidyUtils.assertNotNull("back-colors", this.backColors);
            OlapResMdxTidyUtils.assertNotNull("back-colors", other.backColors);
            OlapResMdxTidyUtils.assertFalse("back-colors not empty", this.backColors.isEmpty());
            OlapResMdxTidyUtils.assertEquals("back-colors count", this.backColors.size(), other.backColors.size());
            OlapResMdxTidyUtils.assertEquals("back-colors", this.backColors, other.backColors);
        }
        if (this.foreColors != null || other.foreColors != null) {
            OlapResMdxTidyUtils.assertNotNull("fore-colors", this.foreColors);
            OlapResMdxTidyUtils.assertNotNull("fore-colors", other.foreColors);
            OlapResMdxTidyUtils.assertFalse("fore-colors not empty", this.foreColors.isEmpty());
            OlapResMdxTidyUtils.assertEquals("fore-colors count", this.foreColors.size(), other.foreColors.size());
            OlapResMdxTidyUtils.assertEquals("fore-colors", this.foreColors, other.foreColors);
        }
    }

    public void assertOnError(OlapErrorCode expected) {
        OlapResMdxTidyMaterializedTableCellError error = this.errors.get(0);
        String errorCode = error.getErrorCode();
        OlapResMdxTidyUtils.assertNotNull("error", errorCode);
        OlapResMdxTidyUtils.assertEquals("error-code", expected.getValue(), errorCode);
    }
}

