/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.result.tidy.debug;

import crazydev.iccube.collection.OlapIteratorHelper;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.result.tidy.OlapResMdxTidyUtils;
import crazydev.iccube.olap.entity.result.tidy.TidyTableClassID;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResMdxTidyMaterializedTableAxis;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResMdxTidyMaterializedTableCellError;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResMdxTidyMaterializedTableCellsColumn;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResMdxTidyMaterializedTableColumn;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResMdxTidyMaterializedTableColumnAxisInfo;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResMdxTidyMaterializedTableMemberInfo;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResMdxTidyMaterializedTableMembers;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResMdxTidyMaterializedTableMembersColumn;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResMdxTidyMaterializedTableMembersInfo;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResMdxTidyMaterializedTableQuery;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResTidyMaterializedTable;
import crazydev.iccube.olap.entity.result.tidy.prettyprint.OlapResMdxTidyPrettyPrinter;
import crazydev.iccube.olap.entity.scalar.OlapBooleanEntity;
import crazydev.iccube.olap.entity.scalar.OlapDoubleVectorEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapStringEntity;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.OlapTupleHelper;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapResMdxTidyMaterializedTable
extends OlapResTidyMaterializedTable<OlapResMdxTidyMaterializedTableColumn> {
    private final List<OlapResMdxTidyMaterializedTableAxis> axes;
    private final OlapResMdxTidyMaterializedTableMembersInfo[][] infos;
    private final List<OlapResMdxTidyMaterializedTableColumn> columns;
    @Nullable
    private final List<OlapResMdxTidyMaterializedTableMemberInfo> initialMembers;

    OlapResMdxTidyMaterializedTable(OlapResMdxTidyMaterializedTableQuery query, List<OlapResMdxTidyMaterializedTableAxis> axes, OlapResMdxTidyMaterializedTableMembersInfo[][] infos, List<OlapResMdxTidyMaterializedTableColumn> columns, int rowCount, int tidyMaxRowCount, boolean tidyMaxRowCountReached, boolean withPaging, @Nullable List<OlapResMdxTidyMaterializedTableMemberInfo> initialMembers) {
        super(TidyTableClassID.MDX_TABLE, query, rowCount, tidyMaxRowCount, tidyMaxRowCountReached, withPaging);
        this.axes = axes;
        this.infos = infos;
        this.columns = columns;
        this.initialMembers = initialMembers;
    }

    @Override
    public void setNaN() {
        super.setNaN();
        for (OlapResMdxTidyMaterializedTableColumn column : this.columns) {
            column.setNaN();
        }
        OlapResMdxTidyMaterializedTableMembersInfo[][] olapResMdxTidyMaterializedTableMembersInfoArray = this.infos;
        int n = olapResMdxTidyMaterializedTableMembersInfoArray.length;
        for (int i = 0; i < n; ++i) {
            OlapResMdxTidyMaterializedTableMembersInfo[] info;
            for (OlapResMdxTidyMaterializedTableMembersInfo inf : info = olapResMdxTidyMaterializedTableMembersInfoArray[i]) {
                inf.setNaN();
            }
        }
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public List<OlapResMdxTidyMaterializedTableColumn> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public List<OlapResMdxTidyMaterializedTableCellsColumn> getCellsColumns() {
        ArrayList<OlapResMdxTidyMaterializedTableCellsColumn> cells = new ArrayList<OlapResMdxTidyMaterializedTableCellsColumn>();
        for (OlapResMdxTidyMaterializedTableColumn column : this.columns) {
            if (!(column instanceof OlapResMdxTidyMaterializedTableCellsColumn)) continue;
            cells.add((OlapResMdxTidyMaterializedTableCellsColumn)column);
        }
        return cells;
    }

    public List<OlapResMdxTidyMaterializedTableMembersColumn> getMembersColumns() {
        ArrayList<OlapResMdxTidyMaterializedTableMembersColumn> members = new ArrayList<OlapResMdxTidyMaterializedTableMembersColumn>();
        for (OlapResMdxTidyMaterializedTableColumn column : this.columns) {
            if (!(column instanceof OlapResMdxTidyMaterializedTableMembersColumn)) continue;
            members.add((OlapResMdxTidyMaterializedTableMembersColumn)column);
        }
        return members;
    }

    public List<OlapResMdxTidyMaterializedTableMembersColumn> getMembersColumns(int axis) {
        ArrayList<OlapResMdxTidyMaterializedTableMembersColumn> members = new ArrayList<OlapResMdxTidyMaterializedTableMembersColumn>();
        for (OlapResMdxTidyMaterializedTableColumn column : this.columns) {
            if (column.axis.getAxis() != axis || !(column instanceof OlapResMdxTidyMaterializedTableMembersColumn)) continue;
            members.add((OlapResMdxTidyMaterializedTableMembersColumn)column);
        }
        return members;
    }

    public OlapResMdxTidyMaterializedTableColumn getColumn(int index) {
        return this.columns.get(index);
    }

    public OlapResMdxTidyMaterializedTableColumn getColumn(String name) {
        for (OlapResMdxTidyMaterializedTableColumn column : this.columns) {
            if (!name.equalsIgnoreCase(column.getName())) continue;
            return column;
        }
        return null;
    }

    public int getAxisCount() {
        return this.axes.size();
    }

    public OlapResMdxTidyMaterializedTableAxis getAxis(int axis) {
        return this.axes.get(axis);
    }

    public OlapResMdxTidyMaterializedTableMembersInfo getMembers(int axis, int hierarchy) {
        return this.infos[axis][hierarchy];
    }

    public int getHierarchyCount(int axis) {
        return this.infos[axis].length;
    }

    @Nullable
    public List<OlapResMdxTidyMaterializedTableMemberInfo> getInitialMembers() {
        return this.initialMembers;
    }

    public void prettyPrint(PrintWriter out) {
        new OlapResMdxTidyPrettyPrinter(this, out).prettyPrint();
    }

    @Override
    @Nullable
    public OlapResMdxTidyMaterializedTableCellError getCellError() {
        List<OlapResMdxTidyMaterializedTableCellsColumn> cellsColumns = this.getCellsColumns();
        for (int rr = 0; rr < this.rowCount; ++rr) {
            for (OlapResMdxTidyMaterializedTableCellsColumn cellsColumn : cellsColumns) {
                OlapResMdxTidyMaterializedTableCellError error = cellsColumn.getError(rr);
                if (error == null) continue;
                return error;
            }
        }
        return null;
    }

    public OlapScalarEntity $getCellsScalar(int ordinal) {
        OlapResMdxTidyUtils.assertTrue("row count", this.rowCount > 0);
        List<OlapResMdxTidyMaterializedTableCellsColumn> cellsColumns = this.getCellsColumns();
        OlapResMdxTidyUtils.assertTrue("cells-column count", cellsColumns.size() > 0);
        OlapResMdxTidyMaterializedTableCellsColumn cellsColumn = cellsColumns.get(ordinal);
        Object value = cellsColumn.getValue(0);
        if (value == null) {
            return OlapEmptyEntity.INSTANCE;
        }
        if (value instanceof Long) {
            return new OlapNumericEntity((Long)value);
        }
        if (value instanceof Double) {
            return new OlapNumericEntity((Double)value);
        }
        if (value instanceof String) {
            return new OlapStringEntity((String)value);
        }
        if (value instanceof Boolean) {
            return OlapBooleanEntity.value((Boolean)value);
        }
        if (value instanceof double[]) {
            return new OlapDoubleVectorEntity((double[])value);
        }
        throw new RuntimeException("NOT YET");
    }

    private double $getCellSum() {
        OlapResMdxTidyUtils.assertTrue("row count", this.rowCount > 0);
        List<OlapResMdxTidyMaterializedTableCellsColumn> cellsColumns = this.getCellsColumns();
        OlapResMdxTidyUtils.assertTrue("cells-column count", cellsColumns.size() > 0);
        double sum = 0.0;
        for (OlapResMdxTidyMaterializedTableCellsColumn cellsColumn : cellsColumns) {
            for (int rr = 0; rr < this.rowCount; ++rr) {
                Object value = cellsColumn.getValue(rr);
                if (value instanceof String) {
                    sum += Double.parseDouble((String)value);
                    continue;
                }
                sum += value == null ? 0.0 : ((Number)value).doubleValue();
            }
        }
        return sum;
    }

    public void assertStackOverflow(int cellCount, int cycleLength) {
        OlapResMdxTidyUtils.assertEquals("rows count", cellCount, this.rowCount);
        List<OlapResMdxTidyMaterializedTableCellsColumn> cellsColumns = this.getCellsColumns();
        OlapResMdxTidyUtils.assertEquals("cells-column count", 1, cellsColumns.size());
        OlapResMdxTidyMaterializedTableCellsColumn cellsColumn = cellsColumns.get(0);
        for (int rr = 0; rr < cellCount; ++rr) {
            String errorCode = cellsColumn.getErrorCode(rr);
            OlapResMdxTidyUtils.assertEquals("cells error:" + rr, "OLAP_CALC_MEMBER_STACK_OVERFLOW", errorCode);
            String error = cellsColumn.getErrorDescription(rr);
            String pattern = "detected at (";
            int pos = error.indexOf("detected at (");
            String cycle = error.substring(pos + "detected at (".length(), error.length() - 1);
            String[] parts = cycle.split(" ");
            OlapResMdxTidyUtils.assertEquals("cells cycle:" + rr, cycleLength, parts.length);
        }
    }

    public void assertHasNoData() {
        OlapResMdxTidyUtils.assertTrue("no-data: rows", this.rowCount == 0);
        OlapResMdxTidyUtils.assertTrue("no-data: columns", this.columns.isEmpty());
    }

    public void assertEquals(OlapResMdxTidyMaterializedTable other) {
        this.assertCellsEquals(other);
        this.assertMembersEquals(other, "all");
        this.assertCellsMembersEquals(other, "all");
    }

    public void assertVisualEquals(OlapResMdxTidyMaterializedTable other) {
        this.assertCellsEquals(other);
        this.assertMembersEquals(other, "caption");
        this.assertCellsMembersEquals(other, "caption");
    }

    public void assertMembersEquals(OlapResMdxTidyMaterializedTable other, String kind) {
        List<OlapResMdxTidyMaterializedTableMembersColumn> thisColumns = this.getMembersColumns();
        List<OlapResMdxTidyMaterializedTableMembersColumn> otherColumns = other.getMembersColumns();
        OlapResMdxTidyUtils.assertEquals("members columns count", thisColumns.size(), otherColumns.size());
        for (int cc = 0; cc < thisColumns.size(); ++cc) {
            OlapResMdxTidyMaterializedTableMembersColumn thisColumn = thisColumns.get(cc);
            OlapResMdxTidyMaterializedTableColumnAxisInfo thisColumnAxis = thisColumn.getAxis();
            OlapResMdxTidyMaterializedTableAxis thisAxisInfo = this.getAxis(thisColumnAxis.getAxis());
            OlapResMdxTidyMaterializedTableMembersInfo thisMembersInfo = this.getMembers(thisColumnAxis.getAxis(), thisColumnAxis.getHierarchyIdx());
            OlapResMdxTidyMaterializedTableMembersColumn otherColumn = otherColumns.get(cc);
            OlapResMdxTidyMaterializedTableColumnAxisInfo otherColumnAxis = otherColumn.getAxis();
            OlapResMdxTidyMaterializedTableAxis otherAxisInfo = other.getAxis(otherColumnAxis.getAxis());
            OlapResMdxTidyMaterializedTableMembersInfo otherMembersInfo = other.getMembers(otherColumnAxis.getAxis(), otherColumnAxis.getHierarchyIdx());
            OlapResMdxTidyMaterializedTableMembers thisC = new OlapResMdxTidyMaterializedTableMembers(thisAxisInfo, thisMembersInfo, thisColumn);
            OlapResMdxTidyMaterializedTableMembers otherC = new OlapResMdxTidyMaterializedTableMembers(otherAxisInfo, otherMembersInfo, otherColumn);
            thisC.assertEquals(otherC, kind);
        }
    }

    public void assertCellsMembersEquals(OlapResMdxTidyMaterializedTable other, String kind) {
        List<OlapResMdxTidyMaterializedTableCellsColumn> thisColumns = this.getCellsColumns();
        List<OlapResMdxTidyMaterializedTableCellsColumn> otherColumns = other.getCellsColumns();
        OlapResMdxTidyUtils.assertEquals("cells columns count", thisColumns.size(), otherColumns.size());
        for (int cc = 0; cc < thisColumns.size(); ++cc) {
            OlapResMdxTidyMaterializedTableCellsColumn thisColumn = thisColumns.get(cc);
            OlapResMdxTidyMaterializedTableCellsColumn otherColumn = otherColumns.get(cc);
            thisColumn.assertCellsMembersEquals(otherColumn, kind);
        }
    }

    public void assertAxisCount(int expected) {
        OlapResMdxTidyUtils.assertEquals("axis count", expected, this.axes.size());
    }

    public void assertAxisTuplesEquals(OlapTupleSet expected, int axis) {
        List<OlapTuple> expectedTuples = OlapIteratorHelper.extractTuplesForTests(expected.getIterator(false));
        if (expectedTuples.isEmpty()) {
            this.assertHasNoData();
            return;
        }
        OlapResMdxTidyUtils.assertTrue("tuple count", expectedTuples.size() > 0);
        List<OlapResMdxTidyMaterializedTableCellsColumn> cellsColumns = this.getCellsColumns();
        if (axis == 0 && this.axes.size() > 1 || this.axes.size() == 1 && cellsColumns.size() > 0) {
            OlapResMdxTidyUtils.assertEquals("tuple count", cellsColumns.size(), expectedTuples.size());
            for (int cc = 0; cc < expectedTuples.size(); ++cc) {
                OlapTuple tuple = (OlapTuple)expectedTuples.get(cc);
                String expectedName = OlapTupleHelper.toTidyCellsColumnName(tuple);
                OlapResMdxTidyUtils.assertEquals("member name", expectedName, cellsColumns.get((int)cc).name);
            }
        } else {
            OlapResMdxTidyUtils.assertEquals("tuple count", this.rowCount, expectedTuples.size());
            OlapTuple aTuple = (OlapTuple)expectedTuples.get(0);
            List<OlapResMdxTidyMaterializedTableMembersColumn> membersColumns = this.getMembersColumns(axis);
            OlapResMdxTidyUtils.assertEquals("members columns count", aTuple.getMemberCount(), membersColumns.size());
            for (int hh = 0; hh < aTuple.getMemberCount(); ++hh) {
                OlapResMdxTidyMaterializedTableMembersColumn membersColumn = membersColumns.get(hh);
                OlapResMdxTidyMaterializedTableColumnAxisInfo membersColumnAxis = membersColumn.getAxis();
                OlapResMdxTidyMaterializedTableMembers members = new OlapResMdxTidyMaterializedTableMembers(this.getAxis(membersColumnAxis.getAxis()), this.getMembers(membersColumnAxis.getAxis(), membersColumnAxis.getHierarchyIdx()), membersColumn);
                members.assertEquals(expectedTuples, hh);
            }
        }
    }

    public void assertCellsCount(int expected) {
        List<OlapResMdxTidyMaterializedTableCellsColumn> cellsColumns = this.getCellsColumns();
        for (OlapResMdxTidyMaterializedTableCellsColumn cellsColumn : cellsColumns) {
            OlapResMdxTidyUtils.assertEquals("pages count", 0, cellsColumn.getPageCount());
        }
        int cellCount = this.rowCount * cellsColumns.size();
        OlapResMdxTidyUtils.assertEquals("cells count", expected, cellCount);
    }

    public void assertCellsEquals(OlapResMdxTidyMaterializedTable other) {
        List<OlapResMdxTidyMaterializedTableCellsColumn> thisColumns = this.getCellsColumns();
        List<OlapResMdxTidyMaterializedTableCellsColumn> otherColumns = other.getCellsColumns();
        OlapResMdxTidyUtils.assertEquals("cells columns count", thisColumns.size(), otherColumns.size());
        for (int cc = 0; cc < thisColumns.size(); ++cc) {
            OlapResMdxTidyMaterializedTableCellsColumn thisColumn = thisColumns.get(cc);
            OlapResMdxTidyMaterializedTableCellsColumn otherColumn = otherColumns.get(cc);
            thisColumn.assertCellsEquals(otherColumn);
        }
    }

    public void assertCellsEquals(String[] other) {
        OlapResMdxTidyUtils.assertTrue("row count", this.rowCount > 0);
        List<OlapResMdxTidyMaterializedTableCellsColumn> cellsColumns = this.getCellsColumns();
        OlapResMdxTidyUtils.assertTrue("cells-column count", cellsColumns.size() > 0);
        for (int cc = 0; cc < other.length; ++cc) {
            OlapResMdxTidyMaterializedTableCellsColumn cellsColumn = cellsColumns.get(cc);
            Object value = cellsColumn.getValue(0);
            String cellValue = value != null ? String.valueOf(value) : "";
            OlapResMdxTidyUtils.assertEquals("cells value:" + cc, other[cc], cellValue);
        }
    }

    public void assertCellsEquals(boolean[] other) {
        OlapResMdxTidyUtils.assertTrue("row count", this.rowCount > 0);
        List<OlapResMdxTidyMaterializedTableCellsColumn> cellsColumns = this.getCellsColumns();
        OlapResMdxTidyUtils.assertTrue("cells-column count", cellsColumns.size() > 0);
        for (int cc = 0; cc < other.length; ++cc) {
            OlapResMdxTidyMaterializedTableCellsColumn cellsColumn = cellsColumns.get(cc);
            Object value = cellsColumn.getValue(0);
            OlapResMdxTidyUtils.assertEquals("cells value:" + cc, other[cc], value);
        }
    }

    public void assertCellsEquals(double[] other, double delta) {
        OlapResMdxTidyUtils.assertTrue("row count", this.rowCount > 0);
        List<OlapResMdxTidyMaterializedTableCellsColumn> cellsColumns = this.getCellsColumns();
        OlapResMdxTidyUtils.assertTrue("cells-column count", cellsColumns.size() > 0);
        for (int cc = 0; cc < other.length; ++cc) {
            OlapResMdxTidyMaterializedTableCellsColumn cellsColumn = cellsColumns.get(cc);
            Object value = cellsColumn.getValue(0);
            double cellValue = value != null ? (value instanceof Long ? Double.valueOf(((Long)value).longValue()) : (Double)value) : 0.0;
            OlapResMdxTidyUtils.assertEquals("cells value:" + cc, other[cc], cellValue, delta);
        }
    }

    public void assertCellsEquals(Object[] other) {
        OlapResMdxTidyUtils.assertTrue("row count", this.rowCount > 0);
        List<OlapResMdxTidyMaterializedTableCellsColumn> cellsColumns = this.getCellsColumns();
        OlapResMdxTidyUtils.assertTrue("cells-column count", cellsColumns.size() > 0);
        for (int cc = 0; cc < other.length; ++cc) {
            OlapResMdxTidyMaterializedTableCellsColumn cellsColumn = cellsColumns.get(cc);
            Object value = cellsColumn.getValue(0);
            OlapResMdxTidyUtils.assertEquals("cells value:" + cc, other[cc], value);
        }
    }

    public void assertCellsEquals(String[][] other) {
        OlapResMdxTidyUtils.assertTrue("row count", other.length > 0);
        OlapResMdxTidyUtils.assertEquals("row count", other.length, this.rowCount);
        List<OlapResMdxTidyMaterializedTableCellsColumn> cellsColumns = this.getCellsColumns();
        OlapResMdxTidyUtils.assertEquals("cells-column count", other[0].length, cellsColumns.size());
        for (int cc = 0; cc < cellsColumns.size(); ++cc) {
            cellsColumns.get(cc).assertCellsEquals(other, cc);
        }
    }

    public void assertCellsEquals(boolean[][] other) {
        OlapResMdxTidyUtils.assertTrue("row count", other.length > 0);
        OlapResMdxTidyUtils.assertEquals("row count", other.length, this.rowCount);
        List<OlapResMdxTidyMaterializedTableCellsColumn> cellsColumns = this.getCellsColumns();
        OlapResMdxTidyUtils.assertEquals("cells-column count", other[0].length, cellsColumns.size());
        for (int cc = 0; cc < cellsColumns.size(); ++cc) {
            cellsColumns.get(cc).assertCellsEquals(other, cc);
        }
    }

    public void assertCellsEquals(double[][] other, double delta) {
        OlapResMdxTidyUtils.assertTrue("row count", other.length > 0);
        OlapResMdxTidyUtils.assertEquals("row count", other.length, this.rowCount);
        List<OlapResMdxTidyMaterializedTableCellsColumn> cellsColumns = this.getCellsColumns();
        OlapResMdxTidyUtils.assertEquals("cells-column count", other[0].length, cellsColumns.size());
        for (int cc = 0; cc < cellsColumns.size(); ++cc) {
            cellsColumns.get(cc).assertCellsEquals(other, cc, delta);
        }
    }

    public void assertCellsEquals(Object[][] other) {
        OlapResMdxTidyUtils.assertTrue("row count", other.length > 0);
        OlapResMdxTidyUtils.assertEquals("row count", other.length, this.rowCount);
        List<OlapResMdxTidyMaterializedTableCellsColumn> cellsColumns = this.getCellsColumns();
        OlapResMdxTidyUtils.assertEquals("cells-column count", other[0].length, cellsColumns.size());
        for (int cc = 0; cc < cellsColumns.size(); ++cc) {
            cellsColumns.get(cc).assertCellsEquals(other, cc);
        }
    }

    public void assertCellOnError(OlapErrorCode expected) {
        OlapResMdxTidyUtils.assertEquals("row count", 1, this.rowCount);
        List<OlapResMdxTidyMaterializedTableCellsColumn> cellsColumns = this.getCellsColumns();
        OlapResMdxTidyUtils.assertEquals("cells-column count", 1, cellsColumns.size());
        OlapResMdxTidyMaterializedTableCellsColumn cellsColumn = cellsColumns.get(0);
        String errorCode = cellsColumn.getErrorCode(0);
        OlapResMdxTidyUtils.assertNotNull("error", errorCode);
        OlapResMdxTidyUtils.assertEquals("error-code", expected.getValue(), errorCode);
        cellsColumn.assertCellOnError(expected);
    }

    public void assertCellPageOnError(OlapErrorCode expected) {
        OlapResMdxTidyUtils.assertEquals("row count", 1, this.rowCount);
        List<OlapResMdxTidyMaterializedTableCellsColumn> cellsColumns = this.getCellsColumns();
        OlapResMdxTidyUtils.assertEquals("cells-column count", 1, cellsColumns.size());
        OlapResMdxTidyMaterializedTableCellsColumn cellsColumn = cellsColumns.get(0);
        cellsColumn.assertCellPageOnError(expected);
    }

    public void assertCellCount(double expected) {
        if (expected == 0.0) {
            this.assertHasNoData();
            return;
        }
        OlapResMdxTidyUtils.assertTrue("row count", this.rowCount > 0);
        List<OlapResMdxTidyMaterializedTableCellsColumn> cellsColumns = this.getCellsColumns();
        OlapResMdxTidyUtils.assertTrue("cells-column count", cellsColumns.size() > 0);
        for (OlapResMdxTidyMaterializedTableCellsColumn cellsColumn : cellsColumns) {
            OlapResMdxTidyUtils.assertEquals("pages count", 0, cellsColumn.getPageCount());
        }
        double cellCount = this.rowCount * cellsColumns.size();
        OlapResMdxTidyUtils.assertEquals("cells count", expected, cellCount);
    }

    public void assertCellsSum(double expected, double delta) {
        OlapResMdxTidyUtils.assertTrue("row count : " + this.rowCount, this.rowCount > 0);
        List<OlapResMdxTidyMaterializedTableCellsColumn> cellsColumns = this.getCellsColumns();
        OlapResMdxTidyUtils.assertTrue("cells-column count", cellsColumns.size() > 0);
        double sum = this.$getCellSum();
        OlapResMdxTidyUtils.assertEquals("cells sum", expected, sum, delta);
    }

    public void assertCellsSum(OlapResMdxTidyMaterializedTable other, double delta) {
        OlapResMdxTidyUtils.assertTrue("row count", this.rowCount > 0);
        OlapResMdxTidyUtils.assertTrue("row count", other.rowCount > 0);
        double thisSum = this.$getCellSum();
        double otherSum = other.$getCellSum();
        OlapResMdxTidyUtils.assertEquals("cells sum", thisSum, otherSum, delta);
    }

    public void assertCellsValue(int ordinal, Object expected) {
        OlapResMdxTidyUtils.assertTrue("row count", this.rowCount > 0);
        List<OlapResMdxTidyMaterializedTableCellsColumn> cellsColumns = this.getCellsColumns();
        OlapResMdxTidyUtils.assertTrue("cells-column count", cellsColumns.size() > 0);
        if (ordinal != 0) {
            throw new RuntimeException("assertCellsValue: unexpected ordinal:" + ordinal);
        }
        OlapResMdxTidyMaterializedTableCellsColumn cellsColumn = cellsColumns.get(0);
        Object cellValue = cellsColumn.getValue(0);
        OlapResMdxTidyUtils.assertEquals("cells value", expected, cellValue);
    }

    public void assertCellsValue(int ordinal, double expected, double delta) {
        double cellValue;
        OlapResMdxTidyUtils.assertTrue("row count", this.rowCount > 0);
        List<OlapResMdxTidyMaterializedTableCellsColumn> cellsColumns = this.getCellsColumns();
        OlapResMdxTidyUtils.assertTrue("cells-column count", cellsColumns.size() > 0);
        if (ordinal == 0) {
            OlapResMdxTidyMaterializedTableCellsColumn cellsColumn = cellsColumns.get(0);
            Object value = cellsColumn.getValue(0);
            cellValue = value == null ? 0.0 : ((Number)value).doubleValue();
        } else if (ordinal == 1) {
            OlapResMdxTidyUtils.assertEquals("row count", 1, this.rowCount);
            OlapResMdxTidyMaterializedTableCellsColumn cellsColumn = cellsColumns.get(1);
            Object value = cellsColumn.getValue(0);
            cellValue = value == null ? 0.0 : ((Number)value).doubleValue();
        } else {
            throw new RuntimeException("assertCellsValue: unexpected ordinal:" + ordinal);
        }
        OlapResMdxTidyUtils.assertEquals("cells value", expected, cellValue, delta);
    }

    public void assertCellsValueNull() {
        List<OlapResMdxTidyMaterializedTableCellsColumn> cellsColumns = this.getCellsColumns();
        if (cellsColumns.isEmpty()) {
            throw new RuntimeException("unexpected missing cells columns");
        }
        OlapResMdxTidyMaterializedTableCellsColumn cellsColumn = cellsColumns.get(0);
        for (int cc = 0; cc < cellsColumns.size(); ++cc) {
            OlapResMdxTidyMaterializedTableCellsColumn column = cellsColumns.get(cc);
            for (int rr = 0; rr < this.getRowCount(); ++rr) {
                Object value = cellsColumn.getValue(rr);
                OlapResMdxTidyUtils.assertNull("cells value [" + cc + "][" + rr + "]", value);
            }
        }
    }

    public void assertCells() {
        OlapResMdxTidyUtils.assertTrue("row count", this.rowCount > 0);
        List<OlapResMdxTidyMaterializedTableCellsColumn> cellsColumns = this.getCellsColumns();
        OlapResMdxTidyUtils.assertTrue("cells-column count", cellsColumns.size() > 0);
    }

    public void assertCellsTrue() {
        OlapResMdxTidyUtils.assertTrue("row count", this.rowCount > 0);
        List<OlapResMdxTidyMaterializedTableCellsColumn> cellsColumns = this.getCellsColumns();
        OlapResMdxTidyUtils.assertTrue("cells-column count", cellsColumns.size() > 0);
        for (OlapResMdxTidyMaterializedTableCellsColumn cellsColumn : cellsColumns) {
            for (int rr = 0; rr < this.rowCount; ++rr) {
                Object value = cellsColumn.getValue(rr);
                OlapResMdxTidyUtils.assertNotNull("cells true:" + String.valueOf(value), value);
                if (!(value instanceof Boolean)) {
                    throw new RuntimeException("internal error: value type not asserted yet: " + String.valueOf(value.getClass()));
                }
                OlapResMdxTidyUtils.assertTrue("cells true:" + String.valueOf(value), (Boolean)value);
            }
        }
    }

    public void assertCellsDifferent() {
        OlapResMdxTidyUtils.assertTrue("row count", this.rowCount > 0);
        List<OlapResMdxTidyMaterializedTableCellsColumn> cellsColumns = this.getCellsColumns();
        OlapResMdxTidyUtils.assertTrue("cells-column count", cellsColumns.size() > 0);
        HashSet<Object> cells = new HashSet<Object>();
        for (OlapResMdxTidyMaterializedTableCellsColumn cellsColumn : cellsColumns) {
            for (int rr = 0; rr < this.rowCount; ++rr) {
                Object value = cellsColumn.getValue(rr);
                OlapResMdxTidyUtils.assertNotNull("cells different:" + String.valueOf(value), value);
                OlapResMdxTidyUtils.assertTrue("cells different:" + String.valueOf(value), cells.add(value));
            }
        }
    }

    public void assertCellsFormattedValueEquals(int ordinal, String expected) {
        OlapResMdxTidyUtils.assertTrue("row count", this.rowCount > 0);
        List<OlapResMdxTidyMaterializedTableCellsColumn> cellsColumns = this.getCellsColumns();
        OlapResMdxTidyUtils.assertTrue("cells-column count", cellsColumns.size() > 0);
        if (ordinal != 0) {
            throw new RuntimeException("assertCellsFormattedValue: unexpected ordinal:" + ordinal);
        }
        OlapResMdxTidyMaterializedTableCellsColumn cellsColumn = cellsColumns.get(0);
        String cellValue = cellsColumn.getFormattedValue(0);
        OlapResMdxTidyUtils.assertEquals("cells value", expected, cellValue);
    }

    public void assertCellsBackColorEquals(String[][] other) {
        OlapResMdxTidyUtils.assertTrue("row count", other.length > 0);
        OlapResMdxTidyUtils.assertEquals("row count", other.length, this.rowCount);
        List<OlapResMdxTidyMaterializedTableCellsColumn> cellsColumns = this.getCellsColumns();
        OlapResMdxTidyUtils.assertEquals("cells-column count", other[0].length, cellsColumns.size());
        for (int cc = 0; cc < cellsColumns.size(); ++cc) {
            cellsColumns.get(cc).assertCellsBackColorEquals(other, cc);
        }
    }

    public void assertCellsPageEquals(int page, String name, String caption, Object[][] other) {
        OlapResMdxTidyUtils.assertTrue("row count", other.length > 0);
        OlapResMdxTidyUtils.assertEquals("row count", other.length, this.rowCount);
        List<OlapResMdxTidyMaterializedTableCellsColumn> cellsColumns = this.getCellsColumns();
        OlapResMdxTidyUtils.assertEquals("cells-column count", other[0].length, cellsColumns.size());
        for (int cc = 0; cc < cellsColumns.size(); ++cc) {
            cellsColumns.get(cc).assertCellsPageEquals(page, name, caption, other, cc);
        }
    }
}

