/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.result.tidy.builder.nonempty;

import crazydev.iccube.collection.IOlapIterator;
import crazydev.iccube.olap.entity.result.tidy.builder.nonempty.OlapResMdxTidyNonEmptyTuple;
import crazydev.iccube.olap.entity.result.tidy.builder.nonempty.OlapResMdxTidyNonEmptyTupleIterator;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.result.OlapEvalResultCellValue;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;

public class OlapResMdxTidyNonEmptyAxisTuples {
    private final Object LOCK = new Object();
    private final int axis;
    private final boolean hasNonEmpty;
    private final ConcurrentHashMap<Integer, OlapTuple> tuples = new ConcurrentHashMap();
    private int tupleIndexMax;
    private boolean frozen;

    OlapResMdxTidyNonEmptyAxisTuples(int axis, boolean hasNonEmpty) {
        this.axis = axis;
        this.hasNonEmpty = hasNonEmpty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAxisLength() {
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.frozen) {
                throw new RuntimeException("internal error: inconsistent getAxisLength usage");
            }
            return this.tupleIndexMax + 1;
        }
    }

    public int getTupleCountNE() {
        return this.tuples.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IOlapIterator<OlapResMdxTidyNonEmptyTuple> getSortedTuples() {
        Object object = this.LOCK;
        synchronized (object) {
            this.frozen = true;
        }
        int[] sorted = new int[this.tuples.size()];
        Enumeration<Integer> indices = this.tuples.keys();
        int ii = 0;
        while (indices.hasMoreElements()) {
            sorted[ii++] = indices.nextElement();
        }
        Arrays.sort(sorted);
        return new OlapResMdxTidyNonEmptyTupleIterator(this.tuples, sorted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTuple(int rowIndex, OlapTuple tuple, int tupleIndex, OlapEvalResultCellValue cellValue) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.frozen) {
                throw new RuntimeException("internal error: inconsistent addTuple usage");
            }
            this.tupleIndexMax = Math.max(this.tupleIndexMax, tupleIndex);
        }
        boolean cellValueEmpty = cellValue.isEmpty();
        if (cellValueEmpty && this.hasNonEmpty) {
            return;
        }
        this.tuples.putIfAbsent(tupleIndex, tuple);
    }
}

