/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.result.tidy.builder;

import crazydev.iccube.exception.OlapException;
import crazydev.iccube.olap.entity.result.OlapResAxisName;
import crazydev.iccube.olap.entity.result.tidy.OlapResMdxTidyTable;
import crazydev.iccube.olap.entity.result.tidy.builder.OlapResMdxTidyBuilderCellsPage;
import crazydev.iccube.olap.entity.result.tidy.builder.OlapResMdxTidyBuilderColumn;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.result.OlapEvalResultCellValue;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.Nullable;

public class OlapResMdxTidyBuilderCellsColumn
extends OlapResMdxTidyBuilderColumn {
    private final OlapTuple tuple;
    private final int tupleIdx;
    private final int pagingAxis;
    @Nullable
    private final String iFormatString;
    @Nullable
    private final String color;
    @Nullable
    private final String[] colors;
    private final int cellPropertyValueIndex;
    private final int cellPropertyFormattedValueExIndex;
    private final int cellPropertyFormatStringIndex;
    private final int cellPropertyBackColorIndex;
    private final int cellPropertyForeColorIndex;
    private final List<OlapResMdxTidyBuilderCellsPage> pages;
    private final AtomicBoolean hasNonEmptyCells = new AtomicBoolean();

    public OlapResMdxTidyBuilderCellsColumn(OlapResAxisName axis0, OlapTuple tuple, int tupleIdx, int pagingAxis, List<OlapResMdxTidyBuilderCellsPage> pages, @Nullable String fs, @Nullable String color, @Nullable String[] colors, int cellPropertyValueIndex, int cellPropertyFormattedValueExIndex, int cellPropertyFormatStringIndex, int cellPropertyBackColorIndex, int cellPropertyForeColorIndex) {
        super(axis0);
        this.tuple = tuple;
        this.tupleIdx = tupleIdx;
        this.pagingAxis = pagingAxis;
        this.pages = pages;
        this.iFormatString = fs;
        this.color = color;
        this.colors = colors;
        this.cellPropertyValueIndex = cellPropertyValueIndex;
        this.cellPropertyFormattedValueExIndex = cellPropertyFormattedValueExIndex;
        this.cellPropertyFormatStringIndex = cellPropertyFormatStringIndex;
        this.cellPropertyBackColorIndex = cellPropertyBackColorIndex;
        this.cellPropertyForeColorIndex = cellPropertyForeColorIndex;
    }

    @Override
    public void assertConsistency(int rowCount) {
        super.assertConsistency(rowCount);
        for (OlapResMdxTidyBuilderCellsPage page : this.pages) {
            page.assertConsistency(rowCount);
        }
    }

    @Override
    String getAssertName() {
        return this.axis.getNumber() + "." + this.tupleIdx + "." + String.valueOf(this.tuple);
    }

    public OlapTuple getTuple() {
        return this.tuple;
    }

    public int getTupleIdx() {
        return this.tupleIdx;
    }

    public int getPagingCount() {
        return this.pages.size();
    }

    public int getPagingAxis() {
        return this.pagingAxis;
    }

    @Nullable
    public String getFormatString() {
        if (this.pages.get(0).isFormatStringOK()) {
            return this.pages.get(0).getFormatString();
        }
        return this.iFormatString;
    }

    @Nullable
    public String getColor() {
        return this.color;
    }

    @Nullable
    public String[] getColors() {
        return this.colors;
    }

    @Nullable
    public OlapException getError(int rowCount) {
        for (OlapResMdxTidyBuilderCellsPage page : this.pages) {
            for (int rr = 0; rr < rowCount; ++rr) {
                OlapException error = page.getError(rr);
                if (error == null) continue;
                return error;
            }
        }
        return null;
    }

    public int getPageCount() {
        return this.pages.size();
    }

    public OlapResMdxTidyBuilderCellsPage getPage(int index) {
        return this.pages.get(index);
    }

    public boolean hasNonEmptyCells() {
        return this.hasNonEmptyCells.get();
    }

    public void addCell(boolean withDebugger, int rowIndex, OlapTuple[] cellTuple, OlapEvalResultCellValue cellValue) {
        int pageIndex;
        if (this.pagingAxis != -1) {
            int si;
            int[] Si = cellValue.getCellSi().getSi();
            pageIndex = si = Si[this.pagingAxis];
        } else {
            pageIndex = 0;
        }
        OlapResMdxTidyBuilderCellsPage page = this.pages.get(pageIndex);
        page.addCell(rowIndex, cellValue);
        if (withDebugger) {
            cellValue.addDebuggerInfo(this, pageIndex, rowIndex);
        }
        if (!cellValue.isEmpty()) {
            this.hasNonEmptyCells.set(true);
        }
    }

    @Override
    void onEvaluateCellValuesDoneEx(int rowCount, @Nullable OlapResMdxTidyTable table) {
        for (OlapResMdxTidyBuilderCellsPage page : this.pages) {
            page.onEvaluateCellValuesDone(rowCount);
        }
    }

    public String toString() {
        return this.tuple.toString();
    }
}

