/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.result.tidy;

import crazydev.common.utils.CdTidyUtils;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.result.OlapResSelectStatementDataSet;
import crazydev.iccube.olap.entity.result.OlapResSelectStatementDataSetT;
import crazydev.iccube.olap.entity.result.OlapResStatementDataSet;
import crazydev.iccube.olap.entity.result.tidy.OlapResMdxTidyTable;
import crazydev.iccube.olap.entity.scalar.OlapDateEntity;
import crazydev.iccube.olap.entity.scalar.OlapDoubleVectorEntity;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class OlapResMdxTidyUtils {
    public static OlapResStatementDataSet emptyStatementResult(OlapMdxStatementExecutionContext context) {
        if (!context.isForTidyEvaluation()) {
            return new OlapResSelectStatementDataSet(context);
        }
        int tidyMaxRowCount = context.getTidyMaxRowCount();
        int tidyMaxColumnCount = context.getTidyMaxColumnCount();
        int tidyMaxCellCount = context.getTidyMaxCellCount();
        int tidyMaxCellCountNE = context.getTidyMaxCellCountNE();
        OlapResMdxTidyTable table = new OlapResMdxTidyTable(context, tidyMaxRowCount, tidyMaxColumnCount, tidyMaxCellCount, tidyMaxCellCountNE);
        return new OlapResSelectStatementDataSetT(table, "");
    }

    public static void fail(@Nullable String message) {
        if (message == null) {
            throw new AssertionError();
        }
        throw new AssertionError((Object)message);
    }

    public static void assertTrue(String message, boolean condition) {
        if (!condition) {
            OlapResMdxTidyUtils.fail(message);
        }
    }

    public static void assertFalse(String message, boolean condition) {
        OlapResMdxTidyUtils.assertTrue(message, !condition);
    }

    public static void assertNotNull(String message, Object object) {
        OlapResMdxTidyUtils.assertTrue(message, object != null);
    }

    public static void assertNull(String message, Object object) {
        OlapResMdxTidyUtils.assertTrue(message, object == null);
    }

    public static void assertEquals(String message, @Nullable Object expected, @Nullable Object actual) {
        if (!(expected == null && actual == null || expected != null && OlapResMdxTidyUtils.equals(expected, actual))) {
            OlapResMdxTidyUtils.failNotEquals(message, expected, actual);
        }
    }

    public static void assertEquals(String message, double expected, double actual, double delta) {
        if (Double.compare(expected, actual) != 0 && !(Math.abs(expected - actual) <= delta)) {
            OlapResMdxTidyUtils.failNotEquals(message, expected, actual);
        }
    }

    private static void failNotEquals(String message, @Nullable Object expected, @Nullable Object actual) {
        OlapResMdxTidyUtils.fail(OlapResMdxTidyUtils.format(message, expected, actual));
    }

    private static String format(String message, @Nullable Object expected, @Nullable Object actual) {
        Object formatted = "";
        if (message != null && message.length() > 0) {
            formatted = message + " ";
        }
        return (String)formatted + "expected:<" + String.valueOf(expected) + "> but was:<" + String.valueOf(actual) + ">";
    }

    private static boolean equals(Object expected, @Nullable Object actual) {
        if (expected instanceof Object[] && actual instanceof Object[]) {
            return OlapResMdxTidyUtils.equals((Object[])expected, (Object[])actual);
        }
        if (expected instanceof List && actual instanceof List) {
            return OlapResMdxTidyUtils.equals((List)expected, (List)actual);
        }
        if (expected instanceof Integer && actual instanceof Long) {
            return Long.valueOf(((Integer)expected).intValue()).equals(actual);
        }
        if (expected instanceof Double && actual instanceof Long) {
            return expected.equals((Long)actual);
        }
        if (expected instanceof OlapEmptyEntity) {
            return actual == null;
        }
        if (expected instanceof OlapDoubleVectorEntity) {
            return Arrays.equals(((OlapDoubleVectorEntity)expected).toTidyTableValue(), (double[])actual);
        }
        if (expected instanceof OlapDateEntity) {
            return ((OlapDateEntity)expected).toTidyTableValue().equals(actual);
        }
        if (expected instanceof Double) {
            // empty if block
        }
        return expected.equals(actual);
    }

    private static boolean equals(Object[] expected, Object[] actual) {
        return Arrays.equals(expected, actual);
    }

    private static boolean equals(List<?> expected, List<?> actual) {
        int actualS;
        int expectedS;
        if (!expected.isEmpty() && !actual.isEmpty()) {
            Object expectedI = OlapResMdxTidyUtils.getFirstNonNull(expected);
            Object actualI = OlapResMdxTidyUtils.getFirstNonNull(actual);
            if (expectedI instanceof double[] && actualI instanceof double[]) {
                return OlapResMdxTidyUtils.equalsVectors(expected, actual);
            }
            if (expectedI instanceof double[][] && actualI instanceof double[][]) {
                return OlapResMdxTidyUtils.equalsMatrices(expected, actual);
            }
            if (expectedI instanceof Object[] && actualI instanceof Object[]) {
                return OlapResMdxTidyUtils.equalsValues(expected, actual);
            }
        }
        if ((expectedS = expected.size()) != (actualS = actual.size())) {
            OlapLoggers.GENERAL.info((Object)("equals size failed [" + expectedS + "][" + actualS + "]"));
            return false;
        }
        for (int ii = 0; ii < expectedS; ++ii) {
            Object expectedI = expected.get(ii);
            double[] actualI = actual.get(ii);
            if (expectedI == null && actualI == null || expectedI != null && expectedI.equals(actualI)) continue;
            double delta = CdTidyUtils.ASSERT_DOUBLE_DELTA_ERROR;
            if (expectedI instanceof Double && actualI instanceof Double && delta > 0.0) {
                if (Math.abs((Double)expectedI - (Double)actualI) <= delta) continue;
                OlapLoggers.GENERAL.info((Object)("equals item failed [" + ii + "][" + String.valueOf(expectedI) + "][" + String.valueOf(actualI) + "] :: " + delta));
                return false;
            }
            OlapLoggers.GENERAL.info((Object)("equals item failed [" + ii + "][" + String.valueOf(expectedI) + "][" + String.valueOf(actualI) + "]"));
            return false;
        }
        return true;
    }

    @Nullable
    private static Object getFirstNonNull(List<?> items) {
        for (Object item : items) {
            if (item == null) continue;
            return item;
        }
        return null;
    }

    private static boolean equalsValues(List<Object[]> expected, List<Object[]> actual) {
        if (expected.size() != actual.size()) {
            return false;
        }
        for (int ii = 0; ii < expected.size(); ++ii) {
            if (OlapResMdxTidyUtils.equalsValues(expected.get(ii), actual.get(ii))) continue;
            return false;
        }
        return true;
    }

    private static boolean equalsValues(Object[] expected, Object[] actual) {
        return Arrays.equals(expected, actual);
    }

    private static boolean equalsVectors(List<double[]> expected, List<double[]> actual) {
        if (expected.size() != actual.size()) {
            return false;
        }
        for (int ii = 0; ii < expected.size(); ++ii) {
            if (OlapResMdxTidyUtils.equalsVector(expected.get(ii), actual.get(ii))) continue;
            return false;
        }
        return true;
    }

    private static boolean equalsVector(double[] expected, double[] actual) {
        return Arrays.equals(expected, actual);
    }

    private static boolean equalsMatrices(List<double[][]> expected, List<double[][]> actual) {
        if (expected.size() != actual.size()) {
            return false;
        }
        for (int ii = 0; ii < expected.size(); ++ii) {
            if (OlapResMdxTidyUtils.equalsMatrix(expected.get(ii), actual.get(ii))) continue;
            return false;
        }
        return true;
    }

    private static boolean equalsMatrix(double[][] expected, double[][] actual) {
        return Arrays.deepEquals((Object[])expected, (Object[])actual);
    }
}

