/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.result.tidy;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.Strictness;
import com.google.gson.stream.JsonWriter;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.exception.OlapException;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.cmember.OlapCalculatedMemberManager;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperty;
import crazydev.iccube.olap.entity.properties.cell.OlapIntrinsicCellProperties;
import crazydev.iccube.olap.entity.properties.member.OlapMemberPropertyEvalContext;
import crazydev.iccube.olap.entity.result.OlapResAxisName;
import crazydev.iccube.olap.entity.result.tidy.OlapResMdxTidyTableColumn;
import crazydev.iccube.olap.entity.result.tidy.OlapResTidyTable;
import crazydev.iccube.olap.entity.result.tidy.TidyTableClassID;
import crazydev.iccube.olap.entity.result.tidy.builder.OlapResMdxTidyBuilder;
import crazydev.iccube.olap.entity.result.tidy.builder.OlapResMdxTidyBuilderCellsColumn;
import crazydev.iccube.olap.entity.result.tidy.builder.OlapResMdxTidyBuilderCellsPage;
import crazydev.iccube.olap.entity.result.tidy.builder.OlapResMdxTidyBuilderColumn;
import crazydev.iccube.olap.entity.result.tidy.builder.OlapResMdxTidyBuilderMembersColumn;
import crazydev.iccube.olap.entity.result.tidy.builder.nonempty.OlapResMdxTidyBuilderNonEmpty;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResFlatTidyMaterializedTableColumn;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResMdxTidyMaterializedTableBuilder;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResMdxTidyMaterializedTableCellError;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResMdxTidyMaterializedTableCellsColumn;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResMdxTidyMaterializedTableMemberInfo;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResMdxTidyMaterializedTableMembersColumn;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResMdxTidyMaterializedTableMembersInfo;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResMdxTidyMaterializedTableNameCaption;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResTidyMaterializedTable;
import crazydev.iccube.olap.entity.result.tidy.serialize.IOlapSerializedTidyResource;
import crazydev.iccube.olap.entity.result.tidy.serialize.OlapSerializedTidyResourceFactory;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreInformation;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.eval.result.IOlapEvalResult;
import crazydev.iccube.olap.eval.result.OlapEvalResultCellValue;
import crazydev.iccube.olap.eval.select.OlapAxisInstr;
import crazydev.iccube.olap.eval.select.OlapSelectInstr;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import crazydev.iccube.olap.eval.select.tidypostprocessor.OlapDimensionPropertiesTidyPostProcessorArg;
import crazydev.iccube.olap.goodies.debugger.OlapMdxDebugNodeCollector;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.Nullable;

public class OlapResMdxTidyTable
extends OlapResTidyTable<OlapResMdxTidyTableColumn<?>>
implements IOlapEvalResult<OlapTuple> {
    private final OlapMdxStatementExecutionContext context;
    private final int tidyMaxRowCount;
    private final int tidyMaxColumnCount;
    private final int tidyMaxCellCount;
    private final int tidyMaxCellCountNE;
    @Nullable
    private final OlapSelectInstr selectInstr;
    private final OlapAxisInstr[] axisInstrs;
    private final boolean isNonEmptyActive;
    private final String cubeName;
    private final List<OlapCellProperty> cellProperties;
    private final boolean evalOrdinalOnly;
    private final boolean axis0asColumns;
    private final boolean withPaging;
    private final int cellPropertyValueIndex;
    private final int cellPropertyFormattedValueExIndex;
    private final int cellPropertyFormatStringIndex;
    private final int cellPropertyBackColorIndex;
    private final int cellPropertyForeColorIndex;
    private final Object createBuilderLOCK = new Object();
    @Nullable
    private volatile List<OlapTuple> axis0;
    @Nullable
    private volatile List<OlapTuple> axisPaging;
    @Nullable
    private volatile OlapResMdxTidyBuilder builder;
    private volatile boolean isNonEmptyDone;
    @Nullable
    private volatile OlapResMdxTidyBuilderNonEmpty builderNE;
    private final boolean withDebugger;

    public OlapResMdxTidyTable(OlapMdxStatementExecutionContext context, int tidyMaxRowCount, int tidyMaxColumnCount, int tidyMaxCellCount, int tidyMaxCellCountNE) {
        this.context = context;
        this.tidyMaxRowCount = tidyMaxRowCount;
        this.tidyMaxColumnCount = tidyMaxColumnCount;
        this.tidyMaxCellCount = tidyMaxCellCount;
        this.tidyMaxCellCountNE = tidyMaxCellCountNE;
        this.selectInstr = null;
        this.axisInstrs = new OlapAxisInstr[0];
        this.isNonEmptyActive = false;
        this.cubeName = "";
        this.cellProperties = Collections.emptyList();
        this.evalOrdinalOnly = false;
        this.axis0asColumns = OlapResMdxTidyTable.isAxis0asColumns(this.axisInstrs, this.cellProperties);
        this.withPaging = false;
        this.cellPropertyValueIndex = -1;
        this.cellPropertyFormattedValueExIndex = -1;
        this.cellPropertyFormatStringIndex = -1;
        this.cellPropertyBackColorIndex = -1;
        this.cellPropertyForeColorIndex = -1;
        this.axis0 = null;
        this.axisPaging = null;
        this.builder = null;
        this.builderNE = null;
        this.isNonEmptyDone = false;
        this.withDebugger = context != null ? context.getInstrExecListener() instanceof OlapMdxDebugNodeCollector : false;
    }

    public OlapResMdxTidyTable(OlapMdxStatementExecutionContext context, int tidyMaxRowCount, int tidyMaxColumnCount, int tidyMaxCellCount, int tidyMaxCellCountNE, OlapSelectInstr selectInstr, OlapAxisInstr[] axisInstrs, String cubeName, List<OlapCellProperty> cellProperties, boolean evalOrdinalOnly) {
        OlapCellProperty property;
        int pp;
        this.context = context;
        this.tidyMaxRowCount = tidyMaxRowCount;
        this.tidyMaxColumnCount = tidyMaxColumnCount;
        this.tidyMaxCellCount = tidyMaxCellCount;
        this.tidyMaxCellCountNE = tidyMaxCellCountNE;
        this.selectInstr = selectInstr;
        this.axisInstrs = axisInstrs;
        this.isNonEmptyActive = this.hasNonEmpty(axisInstrs);
        this.cubeName = cubeName;
        this.cellProperties = cellProperties;
        this.evalOrdinalOnly = evalOrdinalOnly;
        this.axis0asColumns = OlapResMdxTidyTable.isAxis0asColumns(axisInstrs, cellProperties);
        this.withPaging = OlapResMdxTidyTable.isWithPaging(axisInstrs);
        int cpValueIndex = -1;
        int cpFormattedValueExIndex = -1;
        int cpFormatStringIndex = -1;
        int cpBackColorIndex = -1;
        int cpForeColorIndex = -1;
        for (pp = 0; pp < cellProperties.size(); ++pp) {
            property = cellProperties.get(pp);
            if (property.isValue()) {
                cpValueIndex = pp;
                continue;
            }
            if (property.isFormattedValueEx()) {
                cpFormattedValueExIndex = pp;
                continue;
            }
            if (property.equals(OlapIntrinsicCellProperties.FORMAT_STRING)) {
                cpFormatStringIndex = pp;
                continue;
            }
            if (property.equals(OlapIntrinsicCellProperties.BACK_COLOR)) {
                cpBackColorIndex = pp;
                continue;
            }
            if (!property.equals(OlapIntrinsicCellProperties.FORE_COLOR)) continue;
            cpForeColorIndex = pp;
        }
        for (pp = 0; pp < cellProperties.size(); ++pp) {
            property = cellProperties.get(pp);
            if (!property.isFormattedValue() || cpFormattedValueExIndex != -1) continue;
            cpFormattedValueExIndex = pp;
            break;
        }
        this.cellPropertyValueIndex = cpValueIndex;
        this.cellPropertyFormattedValueExIndex = cpFormattedValueExIndex;
        this.cellPropertyFormatStringIndex = cpFormatStringIndex;
        this.cellPropertyBackColorIndex = cpBackColorIndex;
        this.cellPropertyForeColorIndex = cpForeColorIndex;
        this.axis0 = null;
        this.axisPaging = null;
        this.builder = null;
        this.builderNE = null;
        this.isNonEmptyDone = false;
        this.withDebugger = context.getInstrExecListener() instanceof OlapMdxDebugNodeCollector;
    }

    public boolean isWithDebugger() {
        return this.withDebugger;
    }

    @Override
    public OlapResTidyMaterializedTable<?> materialize(boolean json) {
        return OlapResMdxTidyMaterializedTableBuilder.create(json, this);
    }

    public void init(List<OlapTuple> axis0, @Nullable List<OlapTuple> axisPaging) {
        int columnCountMax = this.context.getTidyMaxColumnCount();
        if (this.axis0asColumns && axis0.size() > columnCountMax) {
            throw new OlapEvaluationException(this.context, OlapErrorCode.TIDY_AXIS_0_SIZE_ERROR, Integer.valueOf(axis0.size()), Integer.valueOf(columnCountMax));
        }
        this.axis0 = axis0;
        this.axisPaging = axisPaging;
        if (axisPaging != null) {
            if (axisPaging.size() > columnCountMax) {
                throw new OlapEvaluationException(this.context, OlapErrorCode.TIDY_AXIS_MEASURES_SIZE_ERROR, Integer.valueOf(axisPaging.size()), Integer.valueOf(columnCountMax));
            }
            if (axis0.size() + axisPaging.size() > columnCountMax) {
                throw new OlapEvaluationException(this.context, OlapErrorCode.TIDY_AXIS_0_MEASURES_SIZE_ERROR, Integer.valueOf(axis0.size() + axisPaging.size()), Integer.valueOf(columnCountMax));
            }
        }
        this.builder = null;
        this.builderNE = null;
        this.isNonEmptyDone = false;
    }

    public void initForNE(List<OlapTuple> axis0, @Nullable List<OlapTuple> axisPaging) {
        this.axis0 = axis0;
        this.axisPaging = axisPaging;
        this.builder = null;
        this.builderNE = null;
        this.isNonEmptyDone = true;
    }

    @Override
    public boolean isForTidyEvaluation() {
        return true;
    }

    @Override
    public OlapMdxStatementExecutionContext getContext() {
        return this.context;
    }

    @Override
    public String getSchemaName() {
        return this.context.getSchemaName();
    }

    @Override
    public String getCubeName() {
        return this.cubeName;
    }

    @Nullable
    public OlapMemberFilter getSchemaPermissionsDimensionFilter() {
        return this.context.getSchemaPermissionsDimensionFilter();
    }

    public OlapCalculatedMemberManager getCalcMemberManager() {
        return this.context.getCalcMemberManager();
    }

    public OlapNameContext getNameContext() {
        return this.context.getNameContext();
    }

    public OlapMemberPropertyEvalContext getMemberPropertyEvalContext() {
        return this.context.getMemberPropertyEvalContext();
    }

    public Locale getLocale() {
        return this.context.getBabylonService().getLocale();
    }

    public int getTidyMaxRowCount() {
        return this.tidyMaxRowCount;
    }

    public int getTidyMaxColumnCount() {
        return this.tidyMaxColumnCount;
    }

    public int getTidyMaxCellCount() {
        return this.tidyMaxCellCount;
    }

    public int getTidyMaxCellCountNE() {
        return this.tidyMaxCellCountNE;
    }

    public int getAxisCount() {
        return this.axisInstrs.length;
    }

    public int getAxisCountNE() {
        int count = 0;
        for (OlapAxisInstr axisInstr : this.axisInstrs) {
            if (!axisInstr.hasNonEmptyKeyword()) continue;
            ++count;
        }
        return count;
    }

    public OlapAxisInstr getAxisInstr(int axis) {
        return this.axisInstrs[axis];
    }

    public boolean isFilter() {
        return !this.axis0asColumns;
    }

    @Override
    public boolean isAxis0asColumns() {
        return this.axis0asColumns;
    }

    public List<OlapTuple> getAxis0() {
        List<OlapTuple> thisAxis0 = this.axis0;
        if (thisAxis0 == null) {
            throw new RuntimeException("internal error: unexpected tidy table not initialized");
        }
        return thisAxis0;
    }

    public OlapResAxisName getAxisName(int axis) {
        if (axis == 0 && this.axisInstrs.length == 0) {
            List<OlapTuple> thisAxis0 = this.axis0;
            if (thisAxis0 != null && thisAxis0.size() == 1) {
                return new OlapResAxisName(0L);
            }
            throw new RuntimeException("internal error: inconsistent getAxisName usage");
        }
        return this.axisInstrs[axis].getName();
    }

    public String getAxisRole(int axis) {
        return this.axisInstrs[axis].getName().getRole();
    }

    public boolean isNonEmptyActive() {
        return this.isNonEmptyActive;
    }

    public boolean isNonEmptyDone() {
        return this.isNonEmptyDone;
    }

    public boolean hasNonEmpty(int axis) {
        return this.axisInstrs[axis].hasNonEmptyKeyword();
    }

    @Override
    public boolean isWithPaging() {
        return this.withPaging;
    }

    public List<OlapTuple> getAxisPaging() {
        List<OlapTuple> thisAxisPaging = this.axisPaging;
        if (thisAxisPaging == null) {
            throw new RuntimeException("internal error: unexpected tidy table not initialized");
        }
        return this.axisPaging;
    }

    public int cellPropertyValueIndex() {
        return this.cellPropertyValueIndex;
    }

    public int cellPropertyFormattedValueExIndex() {
        return this.cellPropertyFormattedValueExIndex;
    }

    public int cellPropertyFormatStringIndex() {
        return this.cellPropertyFormatStringIndex;
    }

    public int cellPropertyBackColorIndex() {
        return this.cellPropertyBackColorIndex;
    }

    public int cellPropertyForeColorIndex() {
        return this.cellPropertyForeColorIndex;
    }

    @Nullable
    public OlapException getCellError() {
        OlapResMdxTidyBuilder thisBuilder = this.builder;
        if (thisBuilder != null) {
            return thisBuilder.getCellError();
        }
        return null;
    }

    @Override
    @Nullable
    public OlapResMdxTidyMaterializedTableCellError getErrorInCells() {
        OlapException error = this.getCellError();
        if (error != null) {
            return new OlapResMdxTidyMaterializedTableCellError(error);
        }
        return null;
    }

    public boolean hasNoData() {
        OlapResMdxTidyBuilder thisBuilder = this.builder;
        if (thisBuilder != null) {
            return thisBuilder.getRowCount() == 0;
        }
        return true;
    }

    public String logAxesTupleCount() {
        OlapResMdxTidyBuilder thisBuilder = this.builder;
        if (thisBuilder != null) {
            return thisBuilder.logAxesTupleCount();
        }
        return "-";
    }

    public String logCellCount() {
        OlapResMdxTidyBuilder thisBuilder = this.builder;
        if (thisBuilder != null) {
            return String.valueOf(thisBuilder.getCellCount());
        }
        return "-";
    }

    public String logRowCount() {
        OlapResMdxTidyBuilder thisBuilder = this.builder;
        if (thisBuilder != null) {
            return String.valueOf(thisBuilder.getRowCount());
        }
        return "-";
    }

    public int getRowCount() {
        if (this.hasNoData()) {
            return 0;
        }
        OlapResMdxTidyBuilder thisBuilder = this.builder;
        if (thisBuilder != null) {
            return thisBuilder.getRowCount();
        }
        throw new RuntimeException("internal error: inconsistent getRowCount usage");
    }

    public int getRowCountNE() {
        OlapResMdxTidyBuilderNonEmpty thisBuilderNE = this.builderNE;
        if (thisBuilderNE != null) {
            return thisBuilderNE.getRowCountNE();
        }
        return 0;
    }

    @Override
    public boolean isTidyMaxRowCountReached() {
        if (this.hasNoData()) {
            return false;
        }
        OlapResMdxTidyBuilder thisBuilder = this.builder;
        if (thisBuilder != null) {
            return thisBuilder.isTidyMaxRowCountReached();
        }
        throw new RuntimeException("internal error: inconsistent getRowCount usage");
    }

    public int getAxisHierarchyCount(int axis) {
        if (this.axis0asColumns && axis == 0) {
            List<OlapTuple> thisAxis0 = this.axis0;
            if (thisAxis0 == null) {
                throw new RuntimeException("internal error: inconsistent getAxisHierarchyCount usage");
            }
            OlapTuple aTuple = thisAxis0.get(0);
            return aTuple.getMemberCount();
        }
        if (this.withPaging && axis == this.axisInstrs.length - 1) {
            List<OlapTuple> thisAxisPaging = this.axisPaging;
            if (thisAxisPaging == null) {
                throw new RuntimeException("internal error: inconsistent getAxisHierarchyCount usage");
            }
            OlapTuple aTuple = thisAxisPaging.get(0);
            return aTuple.getMemberCount();
        }
        List<OlapResMdxTidyBuilderColumn> columns = this.getBuilderColumns(axis);
        return columns.size();
    }

    public int getAxisLength(int axis) {
        if (axis == 0 && this.isAxis0asColumns()) {
            return this.getCellsColumnCount();
        }
        if (axis == this.axisInstrs.length - 1 && this.withPaging) {
            return this.getCellsColumnPagingCount();
        }
        List<OlapResMdxTidyBuilderColumn> columns = this.getBuilderColumns(axis);
        for (OlapResMdxTidyBuilderColumn column : columns) {
            OlapResMdxTidyBuilderMembersColumn members;
            if (!(column instanceof OlapResMdxTidyBuilderMembersColumn) || (members = (OlapResMdxTidyBuilderMembersColumn)column).getHierarchyIdx() != 0) continue;
            return members.getAxisLength();
        }
        return 0;
    }

    public List<Integer> getAxisContent(int axis) {
        if (axis == 0 && this.isAxis0asColumns()) {
            return Arrays.stream(IntStream.range(0, this.getAxisLength(axis)).toArray()).boxed().collect(Collectors.toList());
        }
        if (axis == this.axisInstrs.length - 1 && this.withPaging) {
            return Arrays.stream(IntStream.range(0, this.getAxisLength(axis)).toArray()).boxed().collect(Collectors.toList());
        }
        List<OlapResMdxTidyBuilderColumn> columns = this.getBuilderColumns(axis);
        for (OlapResMdxTidyBuilderColumn column : columns) {
            OlapResMdxTidyBuilderMembersColumn members;
            if (!(column instanceof OlapResMdxTidyBuilderMembersColumn) || (members = (OlapResMdxTidyBuilderMembersColumn)column).getHierarchyIdx() != 0) continue;
            return members.getRowIndexToTupleIndex();
        }
        return Collections.emptyList();
    }

    @Override
    public List<OlapResMdxTidyTableColumn<?>> getColumns() {
        return OlapResMdxTidyMaterializedTableBuilder.createResColumns(this);
    }

    public List<OlapResMdxTidyBuilderColumn> getBuilderColumns() {
        OlapResMdxTidyBuilder thisBuilder = this.builder;
        if (thisBuilder != null) {
            return thisBuilder.getColumns();
        }
        throw new RuntimeException("internal error: inconsistent getBuilderColumns usage");
    }

    public List<OlapResMdxTidyBuilderColumn> getBuilderColumns(int axis) {
        OlapResMdxTidyBuilder thisBuilder = this.builder;
        if (thisBuilder != null) {
            return thisBuilder.getColumns(axis);
        }
        throw new RuntimeException("internal error: inconsistent getBuilderColumns usage");
    }

    public OlapResMdxTidyBuilderMembersColumn getBuilderMembersColumn(int axis, int hierarchyIdx) {
        OlapResMdxTidyBuilder thisBuilder = this.builder;
        if (thisBuilder != null) {
            return thisBuilder.getMemberColumn(axis, hierarchyIdx);
        }
        throw new RuntimeException("internal error: inconsistent getBuilderMembersColumn usage");
    }

    public int getCellsColumnCountFromInit() {
        List<OlapTuple> thisAxis0 = this.axis0;
        if (thisAxis0 == null) {
            return 1;
        }
        if (!this.axis0asColumns) {
            return 1;
        }
        return Math.max(1, thisAxis0.size());
    }

    public int getCellsColumnCount() {
        OlapResMdxTidyBuilder thisBuilder = this.builder;
        if (thisBuilder != null) {
            List<OlapResMdxTidyBuilderCellsColumn> columns = thisBuilder.getCellsColumns();
            return columns.size();
        }
        throw new RuntimeException("internal error: inconsistent getCellsColumnCount usage");
    }

    public int getCellsColumnPagingCount() {
        OlapResMdxTidyBuilder thisBuilder = this.builder;
        if (thisBuilder != null) {
            List<OlapResMdxTidyBuilderCellsColumn> columns = thisBuilder.getCellsColumns();
            if (!columns.isEmpty()) {
                OlapResMdxTidyBuilderCellsColumn column = columns.get(0);
                return column.getPagingCount();
            }
            return 0;
        }
        throw new RuntimeException("internal error: inconsistent getCellsColumnPagingCount usage");
    }

    public String getNameForPage0() {
        for (OlapResMdxTidyBuilderColumn column : this.getBuilderColumns()) {
            OlapResMdxTidyBuilderCellsColumn columnC;
            if (!(column instanceof OlapResMdxTidyBuilderCellsColumn) || (columnC = (OlapResMdxTidyBuilderCellsColumn)column).getPageCount() <= 0) continue;
            OlapResMdxTidyBuilderCellsPage page = columnC.getPage(0);
            OlapResMdxTidyMaterializedTableNameCaption name = OlapResMdxTidyMaterializedTableBuilder.createCellsColumnNameCaption(this, page.getTuple());
            return name.name;
        }
        return "";
    }

    public String getCaptionForPage0() {
        for (OlapResMdxTidyBuilderColumn column : this.getBuilderColumns()) {
            OlapResMdxTidyBuilderCellsColumn columnC;
            if (!(column instanceof OlapResMdxTidyBuilderCellsColumn) || (columnC = (OlapResMdxTidyBuilderCellsColumn)column).getPageCount() <= 0) continue;
            OlapResMdxTidyBuilderCellsPage page = columnC.getPage(0);
            OlapResMdxTidyMaterializedTableNameCaption name = OlapResMdxTidyMaterializedTableBuilder.createCellsColumnNameCaption(this, page.getTuple());
            return name.caption;
        }
        return "";
    }

    @Nullable
    public List<OlapMember> getInitialSelection() {
        OlapResMdxTidyBuilder thisBuilder = this.builder;
        if (thisBuilder != null) {
            return thisBuilder.getInitialSelection();
        }
        throw new RuntimeException("internal error: inconsistent getInitialSelection usage");
    }

    public void assertHierarchyUsage(OlapTuple[] cellTuple) {
        if (this.selectInstr != null) {
            this.selectInstr.assertHierarchyUsage(this.context, cellTuple);
        }
    }

    public void addCellValue(IOlapEvaluationExceptionContext context, int rowIndex, OlapTuple[] cellTuple, OlapEvalResultCellValue cellValue) {
        if (!this.isNonEmptyActive || this.isNonEmptyDone) {
            this.addCellValueWithoutNE(context, rowIndex, cellTuple, cellValue);
        } else {
            this.addCellValueWithNE(context, rowIndex, cellTuple, cellValue);
        }
    }

    private void addCellValueWithoutNE(IOlapEvaluationExceptionContext context, int rowIndex, OlapTuple[] cellTuple, OlapEvalResultCellValue cellValue) {
        OlapResMdxTidyBuilder thisBuilder = this.builder;
        if (thisBuilder == null) {
            thisBuilder = this.createBuilder(cellTuple, cellValue);
        }
        thisBuilder.addCellValue(context, rowIndex, cellTuple, cellValue);
    }

    private void addCellValueWithNE(IOlapEvaluationExceptionContext context, int rowIndex, OlapTuple[] cellTuple, OlapEvalResultCellValue cellValue) {
        OlapResMdxTidyBuilderNonEmpty thisBuilderNE = this.builderNE;
        if (thisBuilderNE == null) {
            thisBuilderNE = this.createBuilderNE(cellTuple, cellValue);
        }
        thisBuilderNE.addCellValue(context, rowIndex, cellTuple, cellValue);
    }

    @Override
    public void onEvaluateCellValuesDone(boolean tidyMaxRowCountReached, int rowIndex) {
        if (!this.isNonEmptyActive || this.isNonEmptyDone) {
            OlapResMdxTidyBuilder thisBuilder = this.builder;
            if (thisBuilder != null) {
                thisBuilder.onEvaluateCellValuesDone(tidyMaxRowCountReached, rowIndex);
            }
        } else {
            OlapResMdxTidyBuilderNonEmpty thisBuilderNE = this.builderNE;
            if (thisBuilderNE != null) {
                thisBuilderNE.onEvaluateCellValuesDone(tidyMaxRowCountReached, rowIndex);
            }
        }
    }

    public void evaluateInitialSelection(@Nullable String[] initialSelection) {
        OlapResMdxTidyBuilder thisBuilder = this.builder;
        if (thisBuilder != null) {
            thisBuilder.evaluatedInitialSelection(initialSelection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OlapResMdxTidyBuilder createBuilder(OlapTuple[] cellTuple, OlapEvalResultCellValue cellValue) {
        Object object = this.createBuilderLOCK;
        synchronized (object) {
            if (this.builder == null) {
                this.builder = new OlapResMdxTidyBuilder(this, cellTuple, cellValue);
            }
            return this.builder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OlapResMdxTidyBuilderNonEmpty createBuilderNE(OlapTuple[] cellTuple, OlapEvalResultCellValue cellValue) {
        Object object = this.createBuilderLOCK;
        synchronized (object) {
            if (this.builderNE == null) {
                this.builderNE = new OlapResMdxTidyBuilderNonEmpty(this);
            }
            return this.builderNE;
        }
    }

    private static boolean isAxis0asColumns(OlapAxisInstr[] axisInstrs, List<OlapCellProperty> cellProperties) {
        return axisInstrs.length != 1 || !OlapResMdxTidyTable.isWithNoRequestedValues(cellProperties);
    }

    private static boolean isWithNoRequestedValues(List<OlapCellProperty> cellProperties) {
        return cellProperties.isEmpty() || cellProperties.size() == 1 && cellProperties.get(0).isCellOrdinal();
    }

    private static boolean isWithPaging(OlapAxisInstr[] axisInstrs) {
        if (axisInstrs.length > 0) {
            return axisInstrs[axisInstrs.length - 1].getName().isTidyPaging();
        }
        return false;
    }

    private boolean hasNonEmpty(OlapAxisInstr[] axisInstrs) {
        for (int idx = 0; idx < axisInstrs.length; ++idx) {
            if (!axisInstrs[idx].hasNonEmptyKeyword()) continue;
            return true;
        }
        return false;
    }

    public IOlapSerializedTidyResource serializeAsJson(OlapEngineRequestContext context, @Nullable OlapResultStoreInformation info) throws IOException {
        return OlapSerializedTidyResourceFactory.create(OlapSerializedTidyResourceFactory.Prefix.mdx, context, out -> {
            JsonWriter w = new JsonWriter((Writer)new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8)));
            GsonBuilder gsonB = new GsonBuilder();
            w.setStrictness(Strictness.LENIENT);
            gsonB.serializeSpecialFloatingPointValues();
            Gson gson = gsonB.create();
            this.serializeTable(w, gson, context, true, false, info, null, 0L);
            w.close();
        });
    }

    @Override
    public void serializeTable(JsonWriter w, Gson g, OlapEngineRequestContext context, boolean json, boolean flat, @Nullable OlapResultStoreInformation info, @Nullable Map<Integer, OlapResTidyTable<?>> steps, long executionTimeMS) throws IOException {
        w.beginObject();
        this.serialize(w, "classID", !flat ? TidyTableClassID.MDX_TABLE.name() : TidyTableClassID.TIDY_TABLE.name());
        this.serialize(w, "executionTimeMS", executionTimeMS);
        int rowCount = this.getRowCount();
        this.serialize(w, "rowCount", rowCount);
        this.serialize(w, "tidyMaxRowCount", this.getTidyMaxRowCount());
        this.serialize(w, "tidyMaxRowCountReached", this.isTidyMaxRowCountReached());
        this.serialize(w, "withPaging", this.isWithPaging());
        HashMap<String, Object> extra = null;
        if (this.isWithPaging()) {
            extra = new HashMap<String, Object>();
            extra.put("withPaging", true);
            if (rowCount > 0) {
                extra.put("page0name", this.getNameForPage0());
                extra.put("page0caption", this.getCaptionForPage0());
            }
        }
        this.serializeQuery(w, g, info, extra);
        if (!flat) {
            this.serializeInitialMembers(w, g);
            this.serializeAxes(w, context);
            this.serializeInfos(w, g, context, json);
        }
        this.serializeColumns(w, g, context, json, flat);
        this.serializeSteps(w, g, context, json, flat, steps);
        w.endObject();
    }

    private void serializeInitialMembers(JsonWriter w, Gson g) throws IOException {
        if (this.hasNoData()) {
            return;
        }
        List<OlapMember> selection = this.getInitialSelection();
        if (selection == null || selection.isEmpty()) {
            return;
        }
        List<OlapResMdxTidyMaterializedTableMemberInfo> members = OlapResMdxTidyMaterializedTableBuilder.createInitialSelection(this);
        String membersJ = g.toJson(members);
        w.name("initialMembers");
        w.jsonValue(membersJ);
    }

    private void serializeAxes(JsonWriter w, OlapEngineRequestContext context) throws IOException {
        boolean hasData;
        w.name("axes");
        w.beginArray();
        boolean bl = hasData = !this.hasNoData();
        if (hasData) {
            int axisCount = this.getAxisCount();
            for (int axis = 0; axis < axisCount; ++axis) {
                context.assertNotCancelling("materialized-tidy:create-axes");
                this.serializeAxis(w, axis);
            }
        }
        w.endArray();
    }

    private void serializeAxis(JsonWriter w, int axis) throws IOException {
        w.beginObject();
        this.serialize(w, "asColumns", axis == 0 && this.isAxis0asColumns());
        this.serialize(w, "axis", axis);
        this.serialize(w, "role", this.getAxisRole(axis));
        this.serialize(w, "hierarchyCount", this.getAxisHierarchyCount(axis));
        this.serialize(w, "length", this.getAxisLength(axis));
        this.serialize(w, "hasNonEmpty", this.hasNonEmpty(axis));
        w.name("content");
        w.beginArray();
        List<Integer> content = this.getAxisContent(axis);
        for (Integer val : content) {
            w.value((long)val.intValue());
        }
        w.endArray();
        w.endObject();
    }

    private void serializeInfos(JsonWriter w, Gson g, OlapEngineRequestContext context, boolean json) throws IOException {
        boolean hasData;
        w.name("infos");
        w.beginArray();
        boolean bl = hasData = !this.hasNoData();
        if (hasData) {
            int axisCount = this.getAxisCount();
            for (int axis = 0; axis < axisCount; ++axis) {
                this.serializeInfosAxis(w, g, context, json, axis);
            }
        }
        w.endArray();
    }

    private void serializeInfosAxis(JsonWriter w, Gson g, OlapEngineRequestContext context, boolean json, int axis) throws IOException {
        if (axis == 0 && this.isAxis0asColumns()) {
            this.serializeInfosAxis0(w, g, context, json);
            return;
        }
        if (axis == this.getAxisCount() - 1 && this.isWithPaging()) {
            this.serializeInfosAxisPaging(w, g, context, json);
            return;
        }
        w.beginArray();
        int hierarchyCount = this.getAxisHierarchyCount(axis);
        for (int hierarchyIdx = 0; hierarchyIdx < hierarchyCount; ++hierarchyIdx) {
            context.assertNotCancelling("materialized-tidy:create-member-infos");
            OlapResMdxTidyBuilderMembersColumn column = this.getBuilderMembersColumn(axis, hierarchyIdx);
            this.serializeInfosAxisRegular(w, g, context, json, axis, hierarchyIdx, column);
        }
        w.endArray();
    }

    private void serializeInfosAxis0(JsonWriter w, Gson g, OlapEngineRequestContext context, boolean json) throws IOException {
        OlapResMdxTidyMaterializedTableMembersInfo[] infos = OlapResMdxTidyMaterializedTableBuilder.createInfosAxis0(context, json, this);
        if (json) {
            for (OlapResMdxTidyMaterializedTableMembersInfo info : infos) {
                info.setNaN();
            }
        }
        String infoJ = g.toJson((Object)infos);
        w.jsonValue(infoJ);
    }

    private void serializeInfosAxisPaging(JsonWriter w, Gson g, OlapEngineRequestContext context, boolean json) throws IOException {
        OlapResMdxTidyMaterializedTableMembersInfo[] infos = OlapResMdxTidyMaterializedTableBuilder.createInfosAxisPaging(context, json, this);
        if (json) {
            for (OlapResMdxTidyMaterializedTableMembersInfo info : infos) {
                info.setNaN();
            }
        }
        String infosJ = g.toJson((Object)infos);
        w.jsonValue(infosJ);
    }

    private void serializeInfosAxisRegular(JsonWriter w, Gson g, OlapEngineRequestContext context, boolean json, int axis, int hierarchyIdx, OlapResMdxTidyBuilderMembersColumn column) throws IOException {
        OlapResMdxTidyMaterializedTableMembersInfo info = OlapResMdxTidyMaterializedTableBuilder.createInfo(context, json, this, axis, hierarchyIdx, column);
        if (json) {
            info.setNaN();
        }
        String infosJ = g.toJson((Object)info);
        w.jsonValue(infosJ);
    }

    private void serializeColumns(JsonWriter w, Gson g, OlapEngineRequestContext context, boolean json, boolean flat) throws IOException {
        boolean hasData;
        w.name("columns");
        w.beginArray();
        boolean bl = hasData = !this.hasNoData();
        if (hasData) {
            for (OlapResMdxTidyBuilderColumn column : this.getBuilderColumns()) {
                context.assertNotCancelling("materialized-tidy:create-columns");
                if (column instanceof OlapResMdxTidyBuilderMembersColumn) {
                    OlapResMdxTidyBuilderMembersColumn columnM = (OlapResMdxTidyBuilderMembersColumn)column;
                    this.serializeMembersColumn(w, g, context, json, flat, columnM);
                    continue;
                }
                if (!(column instanceof OlapResMdxTidyBuilderCellsColumn)) continue;
                OlapResMdxTidyBuilderCellsColumn columnC = (OlapResMdxTidyBuilderCellsColumn)column;
                this.serializeCellsColumn(w, g, context, json, flat, columnC);
            }
        }
        w.endArray();
    }

    private void serializeMembersColumn(JsonWriter w, Gson g, OlapEngineRequestContext context, boolean json, boolean flat, OlapResMdxTidyBuilderMembersColumn column) throws IOException {
        if (!flat) {
            OlapResMdxTidyMaterializedTableMembersColumn members = OlapResMdxTidyMaterializedTableBuilder.createMembersColumn(this, column);
            String membersJ = g.toJson((Object)members);
            w.jsonValue(membersJ);
        } else {
            OlapResMdxTidyMaterializedTableMembersColumn members = OlapResMdxTidyMaterializedTableBuilder.createMembersColumn(this, column);
            int axis = members.getAxis().getAxis();
            int hierarchy = members.getAxis().getHierarchyIdx();
            List<Integer> axisContent = this.getAxisContent(axis);
            OlapResMdxTidyMaterializedTableMembersInfo info = OlapResMdxTidyMaterializedTableBuilder.createInfo(context, json, this, axis, hierarchy, column);
            OlapResFlatTidyMaterializedTableColumn<?> columnM = members.toFlat(axisContent, info);
            String cellsJ = g.toJson(columnM);
            w.jsonValue(cellsJ);
        }
    }

    private void serializeCellsColumn(JsonWriter w, Gson g, OlapEngineRequestContext context, boolean json, boolean flat, OlapResMdxTidyBuilderCellsColumn columnC) throws IOException {
        if (!flat) {
            OlapResMdxTidyMaterializedTableCellsColumn cells = OlapResMdxTidyMaterializedTableBuilder.createCellsColumn(context, this, columnC);
            if (json) {
                cells.setNaN();
            }
            String cellsJ = g.toJson((Object)cells);
            w.jsonValue(cellsJ);
        } else {
            OlapResMdxTidyMaterializedTableCellsColumn cells = OlapResMdxTidyMaterializedTableBuilder.createCellsColumn(context, this, columnC);
            OlapResFlatTidyMaterializedTableColumn<?> columnM = cells.toFlat();
            if (json) {
                columnM.setNaN();
            }
            String cellsJ = g.toJson(columnM);
            w.jsonValue(cellsJ);
        }
    }

    public OlapResTidyTable postProcessForDimensionProperties(List<OlapDimensionPropertiesTidyPostProcessorArg> propertiesR) {
        OlapResMdxTidyBuilder thisBuilder = this.builder;
        if (thisBuilder != null) {
            thisBuilder.postProcessForDimensionProperties(propertiesR);
        }
        return this;
    }
}

