/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.result.tidy;

import com.google.gson.Gson;
import com.google.gson.stream.JsonWriter;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.entity.result.tidy.OlapResFlatTidyTableColumn;
import crazydev.iccube.olap.entity.result.tidy.OlapResTidyTable;
import crazydev.iccube.olap.entity.result.tidy.TidyTableClassID;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResFlatTidyMaterializedTable;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResFlatTidyMaterializedTableColumn;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResMdxTidyMaterializedTableCellError;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResTidyMaterializedTable;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreInformation;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class OlapResFlatTidyTable
extends OlapResTidyTable<OlapResFlatTidyTableColumn<?>> {
    private static final String IC_3_COLUMN_SEPARATOR = "_@ic3@_";
    private final OlapResTidyTable input;
    private final OlapMdxStatementExecutionContext context;
    private final int rowCount;
    private final int tidyMaxRowCount;
    private final boolean tidyMaxRowCountReached;
    private final Map<String, Object> query = new HashMap<String, Object>();
    private final List<OlapResFlatTidyTableColumn<?>> columns;

    public OlapResFlatTidyTable(OlapResTidyTable input, List<OlapResFlatTidyTableColumn<?>> columns) {
        this.input = input;
        this.context = input.getContext();
        this.tidyMaxRowCount = this.context.getTidyMaxRowCount();
        this.tidyMaxRowCountReached = false;
        this.rowCount = OlapResFlatTidyTable.extractRowCount(columns);
        this.columns = columns;
        this.sanityCheck();
    }

    private static int extractRowCount(List<OlapResFlatTidyTableColumn<?>> columns) {
        if (!columns.isEmpty()) {
            return columns.get(0).getRowCount();
        }
        return 0;
    }

    public static String propertyColumnName(String columnName, String propertyName) {
        return columnName + IC_3_COLUMN_SEPARATOR + propertyName;
    }

    @Override
    public OlapResTidyMaterializedTable<?> materialize(boolean json) {
        ArrayList cols = new ArrayList();
        for (OlapResFlatTidyTableColumn<?> column : this.columns) {
            cols.add(new OlapResFlatTidyMaterializedTableColumn(column.getType(), column.getName(), column.getCaption(), column.getValues()));
        }
        OlapResFlatTidyMaterializedTable table = new OlapResFlatTidyMaterializedTable(this.query, this.rowCount, this.tidyMaxRowCount, this.tidyMaxRowCountReached, cols);
        if (json) {
            table.setNaN();
        }
        return table;
    }

    private void sanityCheck() {
        if (this.columns.size() > 1) {
            int expectedSize = this.columns.get(0).getRowCount();
            for (int i = 1; i < this.columns.size(); ++i) {
                OlapResFlatTidyTableColumn<?> col = this.columns.get(i);
                if (col.getRowCount() == expectedSize) continue;
                throw new RuntimeException("internal error : output table : unexpected row count of column [" + col.getName() + "] count: " + col.getRowCount() + " - expected: " + expectedSize);
            }
        }
    }

    @Override
    public OlapMdxStatementExecutionContext getContext() {
        return this.context;
    }

    @Override
    public String getSchemaName() {
        return this.input.getSchemaName();
    }

    @Override
    public String getCubeName() {
        return this.input.getCubeName();
    }

    @Override
    public boolean isAxis0asColumns() {
        return this.input.isAxis0asColumns();
    }

    @Override
    @Nullable
    public OlapResMdxTidyMaterializedTableCellError getErrorInCells() {
        return null;
    }

    @Override
    public boolean isTidyMaxRowCountReached() {
        return false;
    }

    @Override
    public boolean isWithPaging() {
        return false;
    }

    @Override
    public List<OlapResFlatTidyTableColumn<?>> getColumns() {
        return this.columns;
    }

    public void addQueryProperty(String key, String value) {
        this.query.put(key, value);
    }

    @Override
    public void serializeTable(JsonWriter w, Gson g, OlapEngineRequestContext context, boolean json, boolean flat, @Nullable OlapResultStoreInformation info, @Nullable Map<Integer, OlapResTidyTable<?>> steps, long executionTimeMS) throws IOException {
        w.beginObject();
        this.serialize(w, "classID", TidyTableClassID.TIDY_TABLE.name());
        this.serialize(w, "rowCount", this.rowCount);
        this.serialize(w, "tidyMaxRowCount", this.tidyMaxRowCount);
        this.serialize(w, "tidyMaxRowCountReached", this.tidyMaxRowCountReached);
        this.serialize(w, "withPaging", this.isWithPaging());
        this.serializeQuery(w, g, info, this.query);
        this.serializeColumns(w, g, context, json);
        this.serializeSteps(w, g, context, json, flat, steps);
        w.endObject();
    }

    private void serializeColumns(JsonWriter w, Gson g, OlapEngineRequestContext context, boolean json) throws IOException {
        w.name("columns");
        w.beginArray();
        if (this.rowCount > 0) {
            for (OlapResFlatTidyTableColumn<?> column : this.columns) {
                context.assertNotCancelling("materialized-tidy:create-columns");
                this.serializeColumn(w, g, context, json, column);
            }
        }
        w.endArray();
    }

    private void serializeColumn(JsonWriter w, Gson g, OlapEngineRequestContext context, boolean json, OlapResFlatTidyTableColumn<?> column) throws IOException {
        OlapResFlatTidyMaterializedTableColumn columnM = new OlapResFlatTidyMaterializedTableColumn(column.getType(), column.getName(), column.getCaption(), column.getValues());
        if (json) {
            columnM.setNaN();
        }
        String cellsJ = g.toJson(columnM);
        w.jsonValue(cellsJ);
    }
}

