/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.result.slicer;

import crazydev.common.collection.CdAction;
import crazydev.common.collection.CdPair;
import crazydev.common.collection.CdSortedList;
import crazydev.iccube.collection.OlapDistinctIterableTupleSet;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.result.slicer.OlapSlicerFilter;
import crazydev.iccube.olap.entity.result.slicer.OlapSlicerSimpleExistsFilter;
import crazydev.iccube.olap.entity.set.OlapTupleSetHelper;
import crazydev.iccube.olap.entity.tuple.IOlapTuple;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.OlapTupleFactory;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionalityCache;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.filter.dimension.IOlapSimpleExistsFilter;
import crazydev.iccube.olap.eval.filter.dimension.OlapSimpleBitmapExistsFilter;
import crazydev.iccube.olap.eval.filter.dimension.OlapSimpleEmptyExistsFilter;
import crazydev.iccube.olap.eval.select.context.OlapEvaluationContext;
import crazydev.iccube.olap.eval.subselect.dimension.OlapSubSelectSimpleExistFilter;
import crazydev.iccube.olap.index.bitmap.OlapBitSet;
import crazydev.iccube.olap.index.bitmap.OlapBitmap;
import crazydev.iccube.olap.index.bitmap.OlapBitmapAggregation;
import crazydev.iccube.olap.index.bitmap.OlapOneBitmap;
import crazydev.iccube.olap.index.bitmap.RoaringBitmapOrTor;
import crazydev.iccube.olap.index.bitmap.tor.IBitmapAndTor;
import crazydev.iccube.olap.index.bitmap.tor.IBitmapOrTor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public abstract class OlapSlicerExistsFilterFactory {
    public static IOlapSimpleExistsFilter createSlicer(OlapTupleDimensionalityCache cache, IOlapTuple tuple, OlapBitSet matchingDim, OlapSlicerFilter filter) {
        OlapEvaluationContext context = filter.slicer.getContext();
        boolean isMembersCrossjoin = filter.slicer.isMembersCrossjoin();
        List<OlapTuple> tupleList = filter.slicer.getTupleList();
        OlapDistinctIterableTupleSet<OlapTuple> compactedList = OlapSlicerExistsFilterFactory.buildCompactedList(context, cache, matchingDim, tupleList);
        if (compactedList.size() == 0) {
            return OlapSimpleEmptyExistsFilter.INSTANCE;
        }
        CdPair<List<OlapSimpleBitmapExistsFilter.Duo>, Map<Integer, CdSortedList<OlapMember>>> pair = OlapSlicerExistsFilterFactory.simplify(compactedList, tuple, matchingDim, isMembersCrossjoin);
        if (pair == null) {
            return new OlapSlicerSimpleExistsFilter(compactedList.asList());
        }
        return OlapSlicerExistsFilterFactory.asSimpleFilter(pair);
    }

    public static IOlapSimpleExistsFilter createSubSelect(IOlapEvaluationExceptionContext context, OlapTupleDimensionalityCache cache, IOlapTuple tuple, OlapBitSet matchingDim, List<OlapTuple> tupleList, boolean isMembersCrossjoin, boolean hasCalcMember) {
        IOlapSimpleExistsFilter filter;
        if (tupleList.isEmpty()) {
            return OlapSimpleEmptyExistsFilter.INSTANCE;
        }
        if (tupleList.get(0).getMemberCount() == 1 && (filter = OlapSlicerExistsFilterFactory.asFilter(tupleList, tuple.getMember(0), tupleList.get(0).getMember(0).getHierarchy())) != null) {
            return filter;
        }
        OlapDistinctIterableTupleSet<OlapTuple> compactedList = OlapSlicerExistsFilterFactory.buildCompactedList(context, cache, matchingDim, tupleList);
        if (compactedList.size() == 0) {
            return OlapSimpleEmptyExistsFilter.INSTANCE;
        }
        boolean bl = hasCalcMember = hasCalcMember && OlapSlicerExistsFilterFactory.hasCalcMember(compactedList);
        if (hasCalcMember) {
            return new OlapSubSelectSimpleExistFilter(compactedList.asList(), true);
        }
        CdPair<List<OlapSimpleBitmapExistsFilter.Duo>, Map<Integer, CdSortedList<OlapMember>>> pair = OlapSlicerExistsFilterFactory.simplify(compactedList, tuple, matchingDim, isMembersCrossjoin);
        if (pair == null) {
            return new OlapSubSelectSimpleExistFilter(compactedList.asList(), false);
        }
        return OlapSlicerExistsFilterFactory.asSimpleFilter(pair);
    }

    private static IOlapSimpleExistsFilter asFilter(List<OlapTuple> slicerList, OlapMember testMember, OlapHierarchy slicerHierarchy) {
        boolean onlyCalcMembers;
        if (testMember.getDimension() != slicerHierarchy.getDimension()) {
            return t -> true;
        }
        OlapHierarchy tupleMemberHierarchy = testMember.getHierarchy();
        boolean sameHierarchy = testMember.getHierarchy() == slicerList.get(0).getMember(0).getHierarchy();
        Set calcMembers = slicerList.stream().filter(OlapTuple::isCalculated).collect(Collectors.toSet());
        boolean bl = onlyCalcMembers = calcMembers.size() == slicerList.size();
        if (sameHierarchy && slicerList.size() < 16) {
            return t -> {
                OlapMember tMember = t.getMember(tupleMemberHierarchy);
                if (tMember.isCalculated()) {
                    return !onlyCalcMembers || calcMembers.contains(tMember);
                }
                for (int i = 0; i < slicerList.size(); ++i) {
                    OlapMember member = ((OlapTuple)slicerList.get(i)).getMember(slicerHierarchy);
                    if (member == null || !member.isSameBranch(tMember)) continue;
                    return true;
                }
                return false;
            };
        }
        RoaringBitmapOrTor orTor = new RoaringBitmapOrTor();
        for (OlapTuple tuple2 : slicerList) {
            OlapMember member = tuple2.getMember(slicerHierarchy);
            if (member == null || member.isCalculated()) continue;
            if (member.isAll()) {
                return t -> true;
            }
            if (sameHierarchy) {
                member.forEachFamilyMember((CdAction<OlapMember>)((CdAction)olapMember -> orTor.addPoint(olapMember.getUniqueHierarchyMemberIndex())));
                continue;
            }
            OlapBitmap bitmap = member.getBaseMemberBitmap4Exist();
            if (bitmap == null) continue;
            if (OlapBitmap.isOneBitmap(bitmap)) {
                return t -> true;
            }
            orTor.addForOr(bitmap);
        }
        return tuple -> {
            OlapMember tMember = tuple.getMember(tupleMemberHierarchy);
            if (tMember == null) {
                return true;
            }
            if (tMember.isCalculated()) {
                return !onlyCalcMembers || calcMembers.contains(tMember);
            }
            if (sameHierarchy) {
                return orTor.getBit(tMember.getUniqueHierarchyMemberIndex());
            }
            return orTor.intersects(tMember.getBaseMemberBitmap4Exist());
        };
    }

    protected static IOlapSimpleExistsFilter asSimpleFilter(CdPair<List<OlapSimpleBitmapExistsFilter.Duo>, Map<Integer, CdSortedList<OlapMember>>> pair) {
        if (pair.fst == null) {
            return OlapSimpleEmptyExistsFilter.INSTANCE;
        }
        return new OlapSimpleBitmapExistsFilter((List)pair.fst, (Map)pair.snd);
    }

    private static boolean hasCalcMember(OlapDistinctIterableTupleSet<OlapTuple> compactedList) {
        for (OlapTuple tuple : compactedList) {
            if (!tuple.isCalculated()) continue;
            return true;
        }
        return false;
    }

    public static OlapDistinctIterableTupleSet<OlapTuple> buildCompactedList(IOlapEvaluationExceptionContext context, OlapTupleDimensionalityCache cache, OlapBitSet matchingDim, List<OlapTuple> tupleList) {
        OlapTuple anyTuple = tupleList.get(0);
        int count = anyTuple.countMatching(matchingDim);
        int memberCount = anyTuple.getMemberCount();
        OlapDistinctIterableTupleSet<OlapTuple> newTuples = new OlapDistinctIterableTupleSet<OlapTuple>();
        for (OlapTuple slicerTuple : tupleList) {
            OlapTuple setTuple;
            if (memberCount == count) {
                setTuple = slicerTuple;
            } else {
                OlapMember[] newTuple = new OlapMember[count];
                int i = 0;
                for (int pos = 0; pos < memberCount; ++pos) {
                    OlapMember tupleMember = slicerTuple.getMember(pos);
                    if (!matchingDim.get(tupleMember.getDimension().getDimensionalityIndex())) continue;
                    newTuple[i++] = tupleMember;
                }
                setTuple = OlapTupleFactory.instance(context, cache, newTuple);
            }
            newTuples.add(setTuple);
        }
        return newTuples;
    }

    @Nullable
    protected static CdPair<List<OlapSimpleBitmapExistsFilter.Duo>, Map<Integer, CdSortedList<OlapMember>>> simplify(OlapDistinctIterableTupleSet<OlapTuple> tupleList, IOlapTuple tuple, OlapBitSet matchingDim, boolean isMembersCrossjoin) {
        boolean isCrossjoin;
        boolean bl = isCrossjoin = isMembersCrossjoin || tupleList.size() <= 1 || OlapTupleSetHelper.isCrossjoin(tupleList);
        if (!isCrossjoin) {
            return null;
        }
        ArrayList<OlapSimpleBitmapExistsFilter.Duo> existList = new ArrayList<OlapSimpleBitmapExistsFilter.Duo>();
        HashMap<Integer, CdSortedList> sameHierarchy = new HashMap<Integer, CdSortedList>();
        int dimIndex = matchingDim.nextSetBit(0);
        while (dimIndex >= 0) {
            IBitmapOrTor builder = OlapBitmapAggregation.createOlapBitmapOrtor();
            for (OlapTuple slicerTuple : tupleList) {
                IBitmapAndTor builder2 = OlapBitmapAggregation.createOlapBitmapAndtor();
                int slicerTupleSize = slicerTuple.getMemberCount();
                for (int pos = 0; pos < slicerTupleSize; ++pos) {
                    OlapBitmap bitmap;
                    OlapMember tupleMember = slicerTuple.getMember(pos);
                    boolean matchingHierarchy = tupleMember.getTupleDimensionality().intersects(tuple.getTupleDimensionality());
                    if (matchingHierarchy) {
                        CdSortedList list = (CdSortedList)sameHierarchy.get(tupleMember.getHierarchy().getTupleDimensionalityIndex());
                        if (list == null) {
                            list = new CdSortedList(OlapMember.INDEX_COMPARATOR);
                            sameHierarchy.put(tupleMember.getHierarchy().getTupleDimensionalityIndex(), list);
                        }
                        list.addIfMissing((Object)tupleMember);
                        continue;
                    }
                    if (tupleMember.getDimension().getDimensionalityIndex() != dimIndex || (bitmap = tupleMember.getBaseMemberBitmap4Exist()) == null) continue;
                    builder2.addForAnd(bitmap);
                }
                OlapBitmap builder2bits = builder2.asBitmap();
                builder.addForOr(builder2bits);
            }
            OlapBitmap actualBitmap = builder.asBitmap();
            if (actualBitmap != null && actualBitmap.isNoEmpty() && !OlapOneBitmap.isOneBitmap(actualBitmap)) {
                existList.add(new OlapSimpleBitmapExistsFilter.Duo(dimIndex, actualBitmap));
            }
            dimIndex = matchingDim.nextSetBit(dimIndex + 1);
        }
        if (existList.isEmpty() && sameHierarchy.isEmpty()) {
            return new CdPair(null, null);
        }
        return new CdPair(existList, sameHierarchy);
    }
}

