/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.result.slicer;

import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.result.slicer.OlapResSetSlicer;
import crazydev.iccube.olap.entity.result.slicer.OlapResTupleSlicer;
import crazydev.iccube.olap.entity.result.slicer.OlapSlicerFilter;
import crazydev.iccube.olap.entity.set.OlapListTupleSet;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.set.OlapTupleSetHelper;
import crazydev.iccube.olap.entity.tuple.IOlapMembers;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionalityCache;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.instr.OlapInstrExecutionContext;
import crazydev.iccube.olap.eval.select.OlapSlicerInstr;
import crazydev.iccube.olap.eval.select.context.OlapEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public abstract class OlapResSlicer {
    public static final String XMLA_NAME = "SlicerAxis";
    protected final OlapTuple firstTuple;
    private final OlapEvaluationContext context;
    private final OlapSlicerInstr slicerInstr;
    private final List<OlapTuple> tupleList;
    private final OlapTupleDimensionality slicerDimensionality;
    private final boolean isMembersCrossjoin;
    private final OlapSlicerFilter slicerDimensionFilter;

    protected OlapResSlicer(OlapEvaluationContext context, OlapSlicerInstr slicerInstr, List<OlapTuple> tupleList, boolean membersCrossjoin) {
        this.context = context;
        this.slicerInstr = slicerInstr;
        this.tupleList = tupleList;
        this.firstTuple = tupleList.get(0);
        this.slicerDimensionality = this.firstTuple.getTupleDimensionality();
        this.isMembersCrossjoin = membersCrossjoin || OlapTupleSetHelper.isCrossjoin(tupleList);
        OlapMdxStatementExecutionContext sContext = context.getStatementExecutionContext();
        OlapTupleDimensionalityCache cache = sContext.getTupleDimensionalityCache();
        this.slicerDimensionFilter = new OlapSlicerFilter(cache, this);
    }

    @Nullable
    public static OlapResSlicer create(OlapEvaluationContext context, OlapSlicerInstr slicerInstr, OlapTupleSet<OlapTuple> tupleSet) {
        List<Object> tupleList;
        if (tupleSet instanceof OlapListTupleSet) {
            OlapListTupleSet listTupleSet = (OlapListTupleSet)tupleSet;
            tupleList = listTupleSet.getTuples();
        } else {
            OlapTuple tuple;
            tupleList = new ArrayList();
            OlapIterator tuples = tupleSet.getIterator(false);
            tuples.reset();
            while ((tuple = (OlapTuple)tuples.next()) != null) {
                tupleList.add(tuple);
            }
        }
        if (tupleList.isEmpty()) {
            return null;
        }
        OlapResSlicer slicer = tupleList.size() == 1 ? new OlapResTupleSlicer(context, slicerInstr, tupleList, tupleSet.isMembersCrossjoin()) : new OlapResSetSlicer(context, slicerInstr, tupleList, tupleSet.isMembersCrossjoin());
        return slicer;
    }

    public OlapSlicerFilter getSlicerDimensionFilter() {
        return this.slicerDimensionFilter;
    }

    public OlapSlicerInstr getSlicerInstr() {
        return this.slicerInstr;
    }

    public String getXmlaName() {
        return XMLA_NAME;
    }

    public boolean isSet() {
        return this.tupleList.size() > 1;
    }

    @Nullable
    public OlapMember getMember(OlapInstrExecutionContext context, OlapHierarchy hierarchy) {
        return this.firstTuple.getMember(hierarchy);
    }

    @Nullable
    public OlapMeasureMember getMeasure(IOlapEvaluationExceptionContext context) {
        for (int ii = 0; ii < this.firstTuple.getMemberCount(); ++ii) {
            OlapMember member = this.firstTuple.getMember(ii);
            if (!(member instanceof OlapMeasureMember)) continue;
            return (OlapMeasureMember)member;
        }
        return null;
    }

    public abstract void assertConsistency(OlapInstrExecutionContext var1);

    public int getTupleCount() {
        return this.tupleList.size();
    }

    public OlapTupleDimensionality getTupleDimensionality() {
        return this.slicerDimensionality;
    }

    public boolean isMembersCrossjoin() {
        return this.isMembersCrossjoin;
    }

    public OlapTuple getAnyTuple() {
        return this.firstTuple;
    }

    public List<OlapTuple> getTupleList() {
        return this.tupleList;
    }

    public OlapEvaluationContext getContext() {
        return this.context;
    }

    public OlapTupleSet<OlapTuple> getForSlicerFunction() {
        return OlapSetFactory.instance(this.tupleList);
    }

    public void touchCategories() {
        int tupleCount = this.tupleList.size();
        for (int ii = 0; ii < tupleCount; ++ii) {
            OlapTuple tuple = this.tupleList.get(ii);
            IOlapMembers.touchCategories(tuple);
        }
    }

    public abstract void forEachMember(Consumer<OlapMember> var1, Predicate<OlapMember> var2);
}

