/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.result;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.lang.CdXmlaSchemaType;
import crazydev.common.xml.CdXmlUtils;
import crazydev.iccube.olap.component.naming.ONames;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.OlapNameIdentifiableEntity;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.properties.member.OlapMemberPropertyEvalContext;
import crazydev.iccube.olap.entity.properties.member.OlapUserDefinedMemberProperty;
import crazydev.iccube.olap.entity.result.OlapResScopedDimensionProperty;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapResUserDefinedScopedDimensionProperty
extends OlapResScopedDimensionProperty {
    private final List<OlapUserDefinedMemberProperty> properties;
    private final OlapNameIdentifiableEntity scope;

    public OlapResUserDefinedScopedDimensionProperty(OlapUserDefinedMemberProperty property, OlapNameIdentifiableEntity scope) {
        this(Arrays.asList(property), scope);
    }

    public OlapResUserDefinedScopedDimensionProperty(List<OlapUserDefinedMemberProperty> properties, OlapNameIdentifiableEntity scope) {
        this.properties = properties;
        this.scope = scope;
        if (scope instanceof OlapLevel && properties.size() != 1) {
            throw new CdProgrammingException("Unexpected number '" + properties.size() + "' of properties for scope '" + String.valueOf(scope) + "'");
        }
    }

    @Override
    public String getName() {
        return this.properties.get(0).getName();
    }

    @Override
    public String getXmlaName(OlapNameContext nameContext) {
        return CdXmlUtils.escapeForTagName((String)this.getXmlaScopedUniqueName(nameContext));
    }

    @Override
    public CdXmlaSchemaType getXmlaType() {
        return this.properties.get(0).getXmlaType();
    }

    @Override
    public String getXmlaScopedUniqueName(OlapNameContext nameContext) {
        return this.scope.getUniqueName(nameContext) + ".[" + this.getName() + "]";
    }

    @Override
    public OlapNameIdentifiableEntity getScope() {
        return this.scope;
    }

    @Override
    public boolean isKey() {
        return false;
    }

    @Override
    public boolean isCaption() {
        return false;
    }

    @Override
    public boolean isUserDefined() {
        return true;
    }

    @Override
    public List<OlapUserDefinedMemberProperty> getUserDefinedProperties() {
        return this.properties;
    }

    @Override
    @Nullable
    public OlapScalarEntity eval(OlapMemberPropertyEvalContext context, OlapMember member) {
        if (this.scope.isScoping(member)) {
            int psize = this.properties.size();
            for (int idx = 0; idx < psize; ++idx) {
                OlapUserDefinedMemberProperty property = this.properties.get(idx);
                if (!property.getLevel().equals(member.getLevel())) continue;
                return property.eval(context, member);
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return (String)(this.scope == null ? "" : ONames.uname4Log(this.scope) + ".") + this.getName();
    }
}

