/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.result;

import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.result.slicer.OlapResSlicer;
import crazydev.iccube.olap.entity.result.slicer.OlapSlicerFilter;
import crazydev.iccube.olap.entity.scalar.OlapOtherNonScalarAbstractEntity;
import crazydev.iccube.olap.entity.scalar.OlapTruncatedString;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.subcube.OlapSubCubeEntity;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.select.OlapBaseSubSelectInstr;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapResSubSelect
extends OlapOtherNonScalarAbstractEntity {
    public static final String FRIENDLY_NAME = "MDX sub-select";
    private final List<OlapTupleSet<OlapTuple>> axes;
    @Nullable
    private final OlapResSlicer slicer;
    @Nullable
    private final OlapResSubSelect subSubSelect;
    @Nullable
    private final List<OlapSubCubeEntity> subCubes;
    private OlapBaseSubSelectInstr instr;

    public OlapResSubSelect(OlapBaseSubSelectInstr instr, List<OlapTupleSet<OlapTuple>> axes, @Nullable List<OlapSubCubeEntity> subCubes, @Nullable OlapResSlicer slicer) {
        this(instr, axes, subCubes, slicer, null);
    }

    public OlapResSubSelect(OlapBaseSubSelectInstr instr, List<OlapTupleSet<OlapTuple>> axes, @Nullable List<OlapSubCubeEntity> subCubes, @Nullable OlapResSlicer slicer, @Nullable OlapResSubSelect subSubSelect) {
        this.instr = instr;
        this.axes = axes;
        this.subCubes = subCubes;
        this.slicer = slicer;
        this.subSubSelect = subSubSelect;
    }

    @Nullable
    private static List<List<OlapTuple>> filter(@Nullable OlapSlicerFilter slicerAsFilter, @Nullable List<List<OlapTuple>> axes) {
        if (slicerAsFilter == null || axes == null) {
            return axes;
        }
        ArrayList<List<OlapTuple>> filteredAxes = new ArrayList<List<OlapTuple>>();
        for (List<OlapTuple> axis : axes) {
            ArrayList<OlapTuple> filterAxis = new ArrayList<OlapTuple>();
            for (OlapTuple tuple : axis) {
                if (!slicerAsFilter.isAccepting(tuple)) continue;
                filterAxis.add(tuple);
            }
            if (filterAxis.isEmpty()) {
                return null;
            }
            filteredAxes.add(filterAxis);
        }
        return filteredAxes;
    }

    private static List<List<OlapTuple>> convert(List<OlapTupleSet<OlapTuple>> axes) {
        ArrayList<List<OlapTuple>> converted = new ArrayList<List<OlapTuple>>();
        for (int ii = 0; ii < axes.size(); ++ii) {
            OlapTupleSet<OlapTuple> axis = axes.get(ii);
            OlapIterator axisTuples = axis.getIterator(false);
            List materialized = axisTuples.asCrossjoinMaterializedTuples();
            converted.addAll(materialized);
        }
        return converted;
    }

    public boolean isVoidAxis() {
        return this.axes.isEmpty() && (this.subSubSelect == null || this.subSubSelect.isVoidAxis());
    }

    @Nullable
    public List<OlapSubCubeEntity> getSubCubes() {
        ArrayList<OlapSubCubeEntity> sCubes = null;
        if (this.subCubes != null) {
            sCubes = new ArrayList<OlapSubCubeEntity>(this.subCubes);
        }
        if (this.subSubSelect != null && this.subSubSelect.subCubes != null) {
            if (sCubes == null) {
                sCubes = new ArrayList();
            }
            sCubes.addAll(this.subSubSelect.subCubes);
        }
        return sCubes;
    }

    public boolean isNonVisual() {
        return this.instr.isNonVisual();
    }

    @Nullable
    public List<List<OlapTuple>> createValidatedAxes() {
        OlapSlicerFilter slicerAsFilter = this.slicer != null ? this.slicer.getSlicerDimensionFilter() : null;
        ArrayList<List<OlapTuple>> validatedAxes = new ArrayList<List<OlapTuple>>();
        List<List<OlapTuple>> axisTuples = OlapResSubSelect.convert(this.axes);
        List<List<OlapTuple>> axes = OlapResSubSelect.filter(slicerAsFilter, axisTuples);
        if (axes == null) {
            return null;
        }
        for (List<OlapTuple> axis : axes) {
            if (axis != null && !axis.isEmpty()) continue;
            return null;
        }
        validatedAxes.addAll(axes);
        if (this.subSubSelect != null) {
            axisTuples = this.subSubSelect.createValidatedAxes();
            axes = OlapResSubSelect.filter(slicerAsFilter, axisTuples);
            if (axes == null) {
                return null;
            }
            for (List<OlapTuple> axis : axes) {
                if (axis != null && !axis.isEmpty()) continue;
                return null;
            }
            validatedAxes.addAll(axes);
        }
        return validatedAxes;
    }

    @Override
    public String getFriendlyTypeName() {
        return FRIENDLY_NAME;
    }

    @Override
    public String toMdxString(OlapNameContext nameContext, boolean truncate, int maxSize) throws OlapTruncatedString {
        return "";
    }

    @Override
    public String toStringForDebugger() {
        return this.getFriendlyTypeName();
    }

    @Override
    public String toStringForDebuggerAsValue() {
        return this.toStringForDebugger();
    }
}

