/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.result;

import crazydev.common.babylon.CdBabylonService;
import crazydev.iccube.exception.OlapException;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.result.OlapResStatementDataSet;
import crazydev.iccube.olap.entity.result.script.OlapResScriptInfo;
import crazydev.iccube.olap.entity.result.tidy.OlapResMdxTidyTable;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResMdxTidyMaterializedTable;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResMdxTidyMaterializedTableBuilder;
import crazydev.iccube.olap.entity.result.tidy.serialize.IOlapSerializedTidyResource;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreInformation;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import crazydev.iccube.olap.eval.select.statistics.OlapMdxStatementEvalStatistics;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class OlapResSelectStatementDataSetT
extends OlapResStatementDataSet<OlapMdxStatementEvalStatistics> {
    private final OlapResMdxTidyTable table;

    public OlapResSelectStatementDataSetT(OlapResMdxTidyTable table, String mdx) {
        super(table.getSchemaName(), mdx);
        this.table = table;
    }

    @Override
    @Nullable
    public String getCubeName() {
        return this.table.getCubeName();
    }

    @Override
    public boolean isMdxAudit() {
        return true;
    }

    @Override
    @Nullable
    public String getCubeNameForMdxAudit() {
        return this.table.getCubeName();
    }

    @Override
    public OlapResScriptInfo asScriptResultInfo(CdBabylonService babylon) {
        return new OlapResScriptInfo("select", "...");
    }

    @Override
    @Nullable
    public OlapMdxStatementEvalStatistics getEvalStatistics() {
        return this.table.getContext().getEvalStatistics();
    }

    public OlapMdxStatementExecutionContext getContext() {
        return this.table.getContext();
    }

    @Override
    public OlapNameContext getNameContext() {
        return this.table.getNameContext();
    }

    @Override
    @Nullable
    public OlapMember lookupCalculatedMember(OlapNameContext nameContext, OlapEntityIdentifier id) {
        return this.table.getContext().getCalcMemberManager().lookupCalculatedMember(nameContext, id);
    }

    @Override
    public boolean hasCellsOnError() {
        return this.getCellError() != null;
    }

    @Override
    @Nullable
    public OlapException getCellError() {
        return this.table.getCellError();
    }

    @Override
    public void log(Logger logger, long requestId) {
        logger.info((Object)("MDX " + requestId + "    cells: " + this.table.logCellCount()));
        logger.info((Object)("MDX " + requestId + "     axes: " + this.table.logAxesTupleCount()));
        logger.info((Object)("MDX " + requestId + "     rows: " + this.table.logRowCount()));
        logger.info((Object)("MDX " + requestId + " max-rows: " + this.table.getTidyMaxRowCount() + " [reached:" + this.table.isTidyMaxRowCountReached() + "]"));
    }

    public int getTidyMaxRowCount() {
        return this.table.getTidyMaxRowCount();
    }

    public boolean isTidyMaxRowCountReached() {
        return this.table.isTidyMaxRowCountReached();
    }

    public OlapResMdxTidyTable getTable() {
        return this.table;
    }

    @Override
    public String toString() {
        return "SELECT-RESULT";
    }

    public IOlapSerializedTidyResource serializeAsJson(OlapEngineRequestContext context, @Nullable OlapResultStoreInformation info) throws IOException {
        return this.table.serializeAsJson(context, info);
    }

    public OlapResMdxTidyMaterializedTable materialize(boolean json) {
        return OlapResMdxTidyMaterializedTableBuilder.create(json, this.table);
    }

    public OlapResMdxTidyMaterializedTable materializeForTests() {
        return this.materialize(true);
    }
}

