/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.result;

import crazydev.common.babylon.CdBabylonService;
import crazydev.iccube.babylon.OlapBabylonService;
import crazydev.iccube.exception.OlapException;
import crazydev.iccube.mdx.gvi.GviMdxQueryMetaInformation;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectQueryInfo;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.cmember.OlapCalculatedMemberManager;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.properties.member.OlapMemberPropertyValues;
import crazydev.iccube.olap.entity.result.OlapResAxis;
import crazydev.iccube.olap.entity.result.OlapResCellData;
import crazydev.iccube.olap.entity.result.OlapResStatementDataSet;
import crazydev.iccube.olap.entity.result.model.IMember;
import crazydev.iccube.olap.entity.result.model.IResStatementDataSet;
import crazydev.iccube.olap.entity.result.script.OlapResScriptInfo;
import crazydev.iccube.olap.entity.result.slicer.OlapResSlicer;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreInformation;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import crazydev.iccube.olap.eval.select.statistics.OlapMdxStatementEvalStatistics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class OlapResSelectStatementDataSet
extends OlapResStatementDataSet<OlapMdxStatementEvalStatistics>
implements IResStatementDataSet {
    private final OlapMdxStatementExecutionContext context;
    private final MdxSelectQueryInfo queryInfo;
    private final String cubeName_;
    private final String cubeName;
    private final Date cubeLastUpdate;
    private final OlapResAxis[] axes;
    @Nullable
    private final OlapResSlicer slicer;
    private final List<OlapMember> defaultMembers;
    @Nullable
    private final List<OlapMember> initialMembers;
    private final OlapResCellData cells;
    private final OlapNameContext nameContext;
    private boolean drilldownDisabled;
    private boolean isInR;

    public OlapResSelectStatementDataSet(OlapMdxStatementExecutionContext context) {
        this(context, "", new MdxSelectQueryInfo(0), null, null, new OlapResAxis[0], null, null, null, null);
    }

    public OlapResSelectStatementDataSet(OlapMdxStatementExecutionContext context, String mdx, MdxSelectQueryInfo queryInfo, @Nullable String cubeName, @Nullable Date cubeLastUpdate, OlapResAxis[] axes, @Nullable OlapResSlicer slicer, @Nullable List<OlapMember> defaultMembers, @Nullable List<OlapMember> initialMembers, @Nullable OlapResCellData cells) {
        super(context.getSchemaName(), mdx);
        this.context = context;
        this.nameContext = context.getNameContext();
        this.queryInfo = queryInfo;
        this.cubeName_ = cubeName;
        this.cubeName = cubeName == null ? "cube-not-available" : cubeName;
        this.cubeLastUpdate = cubeLastUpdate == null ? context.getSchema().getLastDataUpdatedTime() : cubeLastUpdate;
        this.axes = axes;
        this.slicer = slicer;
        this.defaultMembers = defaultMembers == null ? Collections.emptyList() : defaultMembers;
        this.initialMembers = initialMembers;
        this.cells = cells == null ? OlapResCellData.EMPTY : cells;
    }

    @Override
    public boolean isReportingMF() {
        return this.context.isReportingMF();
    }

    @Override
    public boolean isMdxAudit() {
        return true;
    }

    @Override
    public String getCubeNameForMdxAudit() {
        return this.cubeName_;
    }

    @Override
    public String getKind() {
        return "select";
    }

    @Override
    public boolean isInR() {
        return this.isInR;
    }

    public boolean isInR(boolean value) {
        this.isInR = value;
        return this.isInR;
    }

    public OlapMdxStatementExecutionContext getContext() {
        return this.context;
    }

    @Override
    @Nullable
    public OlapMemberFilter getSchemaPermissionsDimensionFilter() {
        return this.context.getSchemaPermissionsDimensionFilter();
    }

    @Override
    public OlapCalculatedMemberManager getCalcMemberManager() {
        return this.context.getCalcMemberManager();
    }

    @Override
    public OlapMdxStatementEvalStatistics getEvalStatistics() {
        return this.context.getEvalStatistics();
    }

    @Override
    public MdxSelectQueryInfo getQueryInfo() {
        return this.queryInfo;
    }

    @Override
    public String getCubeName() {
        return this.cubeName;
    }

    public Date getCubeLastUpdate() {
        return this.cubeLastUpdate;
    }

    public int getAxisCount() {
        return this.axes.length;
    }

    public OlapResAxis[] getAxes() {
        return this.axes;
    }

    @Nullable
    public OlapResAxis getRowAxis() {
        return this.axes.length <= 1 ? null : this.axes[1];
    }

    public OlapResAxis getColumnAxis() {
        return this.axes[0];
    }

    @Nullable
    public OlapResSlicer getSlicer() {
        return this.slicer;
    }

    public List<OlapMember> getDefaultMembers() {
        return this.defaultMembers;
    }

    @Nullable
    public List<OlapMember> getInitialMembers() {
        return this.initialMembers;
    }

    @Override
    public OlapResCellData getCells() {
        return this.cells;
    }

    @Override
    public boolean isWithSlicer() {
        return true;
    }

    public Map<OlapMember, OlapMemberPropertyValues> getAllMemberPropertyValues() {
        HashMap<OlapMember, OlapMemberPropertyValues> memberPropertyValues = new HashMap<OlapMember, OlapMemberPropertyValues>();
        for (OlapResAxis axis : this.axes) {
            memberPropertyValues.putAll(axis.getPropertyValues());
        }
        return memberPropertyValues;
    }

    @Override
    public GviMdxQueryMetaInformation createGviQueryMetaInformation(@Nullable OlapResultStoreInformation info) {
        ArrayList<String> axis0hierarchies = new ArrayList<String>();
        ArrayList<String> axis1hierarchies = new ArrayList<String>();
        ArrayList<String> axis2hierarchies = new ArrayList<String>();
        boolean nonEmptyAxis0 = false;
        boolean nonEmptyAxis1 = false;
        boolean nonEmptyAxis2 = false;
        int axisNb = 0;
        for (OlapResAxis axis : this.getAxes()) {
            if (axisNb == 0) {
                IResStatementDataSet.extractHierarchies(this.nameContext, axis0hierarchies, axis.getAnyTuple());
                nonEmptyAxis0 = axis.hasNonEmptyKeyword();
            } else if (axisNb == 1) {
                IResStatementDataSet.extractHierarchies(this.nameContext, axis1hierarchies, axis.getAnyTuple());
                nonEmptyAxis1 = axis.hasNonEmptyKeyword();
            } else if (axisNb == 2) {
                IResStatementDataSet.extractHierarchies(this.nameContext, axis2hierarchies, axis.getAnyTuple());
                nonEmptyAxis2 = axis.hasNonEmptyKeyword();
            }
            ++axisNb;
        }
        ArrayList<String> slicerHierarchies = new ArrayList<String>();
        OlapResSlicer slicer = this.getSlicer();
        if (slicer != null) {
            IResStatementDataSet.extractHierarchies(this.nameContext, slicerHierarchies, slicer.getAnyTuple());
        }
        String schemaName = this.getSchemaName();
        String cubeName = this.getCubeName();
        long timestamp = this.context.getSchemaDataTimestamp();
        List<OlapTupleSet<? extends OlapTuple>> filterByInfo = this.context.getFilterByInfo();
        boolean markedForDrilldownStop = this.context.isMarkedForDrilldownStop();
        String hierarchyUniqueNameStyle = this.context.getHierarchyUniqueNameStyle().name();
        return new GviMdxQueryMetaInformation(info, schemaName, cubeName, timestamp, hierarchyUniqueNameStyle, nonEmptyAxis0, nonEmptyAxis1, nonEmptyAxis2, axis0hierarchies, axis1hierarchies, axis2hierarchies, slicerHierarchies, filterByInfo, markedForDrilldownStop, this.getExecutionTimeMS());
    }

    @Override
    public boolean hasCellsOnError() {
        return this.cells.hasErrors();
    }

    @Override
    @Nullable
    public OlapException getCellError() {
        return this.cells.getError();
    }

    @Override
    public OlapResScriptInfo asScriptResultInfo(CdBabylonService babylon) {
        return new OlapResScriptInfo("select", "...");
    }

    @Override
    public OlapNameContext getNameContext() {
        return this.nameContext;
    }

    @Override
    @Nullable
    public OlapMember lookupCalculatedMember(OlapNameContext nameContext, OlapEntityIdentifier id) {
        return this.getCalcMemberManager().lookupCalculatedMember(nameContext, id);
    }

    public OlapBabylonService getBabylonService() {
        return this.context.getBabylonService();
    }

    @Override
    public Locale getLocale() {
        return this.getBabylonService().getLocale();
    }

    public void disableDrilldown() {
        this.drilldownDisabled = true;
    }

    @Override
    public boolean isDrilldownDisabled() {
        return this.drilldownDisabled;
    }

    public long getAxisElapsedMS() {
        return this.context.getAxisElapsedMS();
    }

    public long getTotalElapsedMS() {
        return this.context.getTotalElapsedMS();
    }

    @Override
    @Nullable
    public String getColor(IMember member) {
        return this.context.getColor(member);
    }

    @Override
    public void log(Logger logger, long requestId) {
        logger.info((Object)("MDX " + requestId + "   cells: " + this.cells.getCellCount()));
        logger.info((Object)("MDX " + requestId + "    axes: " + this.createAxesInfo()));
    }

    @Override
    public String logInfo() {
        return " cells:" + this.cells.getCellCount() + " axes:" + this.createAxesInfo();
    }

    private String createAxesInfo() {
        StringBuilder sb = new StringBuilder("");
        for (int ii = 0; ii < this.axes.length; ++ii) {
            OlapResAxis axis = this.axes[ii];
            if (ii > 0) {
                sb.append("x");
            }
            sb.append(axis.getTupleCount());
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return "SELECT-RESULT";
    }
}

