/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.result;

import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumn;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapResScalarEntityTable {
    private final List<IOlapBuilderDataColumnDef> columns = new ArrayList<IOlapBuilderDataColumnDef>();
    private final OlapScalarEntity[][] rows;

    public OlapResScalarEntityTable(String[] colNames, OlapScalarEntity[][] rows) {
        for (int ii = 0; ii < colNames.length; ++ii) {
            OlapBuilderDataColumn column = new OlapBuilderDataColumn();
            column.setName(colNames[ii]);
            column.setIndex(ii);
            this.columns.add(column);
        }
        this.rows = rows;
    }

    public int getRowCount() {
        return this.rows.length;
    }

    public List<IOlapBuilderDataColumnDef> getColumns() {
        return this.columns;
    }

    public IOlapBuilderTableRow getRow(int rr) {
        return new Row(this.rows[rr]);
    }

    private static class Row
    implements IOlapBuilderTableRow {
        private final OlapScalarEntity[] row;

        public Row(OlapScalarEntity[] row) {
            this.row = row;
        }

        @Override
        @Nullable
        public Comparable getJavaNativeDataValue(IOlapBuilderDataColumnDef columnDef) {
            throw new RuntimeException("internal error: unexpected usage of result scalar table row");
        }

        @Override
        public OlapScalarEntity getJavaNativeDataValueAsScalarEntity(IOlapBuilderDataColumnDef columnDef) {
            OlapScalarEntity scalar = this.row[columnDef.getIndex()];
            return scalar;
        }
    }
}

