/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.result;

import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.properties.member.OlapMemberPropertyValues;
import crazydev.iccube.olap.entity.result.OlapResAxisName;
import crazydev.iccube.olap.entity.result.OlapResScopedDimensionProperty;
import crazydev.iccube.olap.entity.result.model.IResAxis;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntityTidyType;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class OlapResAxis
implements IResAxis {
    private final OlapResAxisName name;
    private final boolean hasNonEmptyKeyword;
    private final List<OlapTuple> tuples;
    private final List<OlapResScopedDimensionProperty> requestedProperties;
    private final Map<OlapMember, OlapMemberPropertyValues> propertyValues;

    public OlapResAxis(OlapResAxisName name, boolean hasNonEmptyKeyword, List<OlapTuple> tuples, List<OlapResScopedDimensionProperty> requestedProperties, Map<OlapMember, OlapMemberPropertyValues> propertyValues) {
        this.name = name;
        this.hasNonEmptyKeyword = hasNonEmptyKeyword;
        this.tuples = tuples;
        this.requestedProperties = requestedProperties;
        this.propertyValues = propertyValues;
    }

    @Override
    public OlapResAxisName getName() {
        return this.name;
    }

    public boolean isTidyPaging() {
        return this.name.isTidyPaging();
    }

    public boolean hasNonEmptyKeyword() {
        return this.hasNonEmptyKeyword;
    }

    public List<OlapTuple> getTuples() {
        return this.tuples;
    }

    @Override
    public int getTupleCount() {
        return this.tuples.size();
    }

    @Override
    @Nullable
    public OlapTuple getAnyTuple() {
        if (this.tuples.isEmpty()) {
            return null;
        }
        return this.tuples.get(0);
    }

    public int getHierarchyCount() {
        OlapTuple aTuple = this.getAnyTuple();
        return aTuple != null ? aTuple.getMemberCount() : 0;
    }

    @Override
    public List<OlapResScopedDimensionProperty> getRequestedProperties() {
        return this.requestedProperties;
    }

    @Override
    public Map<OlapMember, OlapMemberPropertyValues> getPropertyValues() {
        return this.propertyValues;
    }

    public void memberProperties(Map<String, List<Object>> dpValues, Map<String, OlapScalarEntityTidyType> dpTypes, OlapMember member, List<OlapResScopedDimensionProperty> properties) {
        OlapMemberPropertyValues evalValues = this.propertyValues.get(member);
        for (OlapResScopedDimensionProperty property : properties) {
            OlapScalarEntityTidyType valueType;
            Object value;
            List<Object> values = dpValues.get(property.getName());
            if (evalValues != null) {
                OlapScalarEntity evalValue = evalValues.getPropertyValue(property);
                if (evalValue != null) {
                    value = evalValue.toTidyTableValue();
                    valueType = evalValue.toTidyTableValueType();
                } else {
                    value = null;
                    valueType = OlapScalarEntityTidyType.NULL;
                }
            } else {
                value = null;
                valueType = OlapScalarEntityTidyType.NULL;
            }
            values.add(value);
            OlapScalarEntityTidyType dpType = dpTypes.get(property.getName());
            if (dpType == null || dpType == OlapScalarEntityTidyType.NULL) {
                dpTypes.put(property.getName(), valueType);
                continue;
            }
            if (dpType == valueType || valueType == null) continue;
            dpTypes.put(property.getName(), OlapScalarEntityTidyType.MIXED);
        }
    }

    public String toString() {
        return this.name.toString();
    }
}

