/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.properties.member;

import crazydev.common.lang.CdXmlaSchemaType;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehavior;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.properties.member.OlapIntrinsicMemberProperty;
import crazydev.iccube.olap.entity.properties.member.OlapMemberPropertyEvalContext;
import crazydev.iccube.olap.entity.scalar.OlapBooleanEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapStringEntity;

public abstract class OlapUserDefinedMemberProperties {
    public static final OlapIntrinsicMemberProperty DESCRIPTION = new OlapIntrinsicMemberProperty("$IC3_DESCRIPTION$", CdXmlaSchemaType.DBTYPE_WSTR){

        @Override
        public OlapScalarEntity eval(OlapMemberPropertyEvalContext context, OlapMember member) {
            String description = member.getDescription(context.getLocale());
            if (CdStringUtils.isNotNullAndNotBlank((String)description)) {
                return new OlapStringEntity(description);
            }
            return OlapEmptyEntity.INSTANCE;
        }
    };
    public static final OlapIntrinsicMemberProperty IS_CATEGORY = new OlapIntrinsicMemberProperty("$IC3_IS_CATEGORY$", CdXmlaSchemaType.DBTYPE_BOOL){

        @Override
        public OlapScalarEntity eval(OlapMemberPropertyEvalContext context, OlapMember member) {
            return OlapBooleanEntity.value(member.isCategoryMember());
        }
    };
    public static final OlapIntrinsicMemberProperty IS_CALCULATED = new OlapIntrinsicMemberProperty("$IC3_IS_CALCULATED$", CdXmlaSchemaType.DBTYPE_BOOL){

        @Override
        public OlapScalarEntity eval(OlapMemberPropertyEvalContext context, OlapMember member) {
            return OlapBooleanEntity.value(member.isCalculated());
        }
    };
    public static final OlapIntrinsicMemberProperty NON_EMPTY_BEHAVIOR = new OlapIntrinsicMemberProperty("$IC3_NON_EMPTY_BEHAVIOR$", CdXmlaSchemaType.DBTYPE_WSTR){

        @Override
        public OlapScalarEntity eval(OlapMemberPropertyEvalContext context, OlapMember member) {
            S_NonEmptyBehavior definedNonEmptyBehavior = member.getDefinedNonEmptyBehavior();
            if (definedNonEmptyBehavior != null) {
                return new OlapStringEntity(definedNonEmptyBehavior.asMdxResult().value());
            }
            return OlapEmptyEntity.INSTANCE;
        }
    };
    public static final OlapIntrinsicMemberProperty IS_UNKNOWN_MEMBER = new OlapIntrinsicMemberProperty("$IC3_UNKNOWN_MEMBER$", CdXmlaSchemaType.DBTYPE_BOOL){

        @Override
        public OlapScalarEntity eval(OlapMemberPropertyEvalContext context, OlapMember member) {
            return OlapBooleanEntity.value(member.isCreatedUnknownMember());
        }
    };
    public static final OlapIntrinsicMemberProperty IS_UNKNOWN_MEMBER_FOR_FACTS = new OlapIntrinsicMemberProperty("$IC3_UNKNOWN_MEMBER_FOR_FACTS$", CdXmlaSchemaType.DBTYPE_BOOL){

        @Override
        public OlapScalarEntity eval(OlapMemberPropertyEvalContext context, OlapMember member) {
            return OlapBooleanEntity.value(OlapMember.equal(member.getDimension().getUnknownMemberForFacts(), member));
        }
    };
    public static final OlapIntrinsicMemberProperty STRUCT_HOLLOW_OF = new OlapIntrinsicMemberProperty("$IC3_STRUCT_HOLLOW_OF$", CdXmlaSchemaType.DBTYPE_BOOL){

        @Override
        public OlapScalarEntity eval(OlapMemberPropertyEvalContext context, OlapMember member) {
            if (member.isStructuralFactHollow()) {
                OlapNameContext namingContext = context.getNameContext();
                return new OlapStringEntity(member.getFactIndexingMember().getUniqueName(namingContext));
            }
            return OlapEmptyEntity.INSTANCE;
        }
    };
    public static final OlapIntrinsicMemberProperty HOLLOW_OF = new OlapIntrinsicMemberProperty("$IC3_HOLLOW_OF$", CdXmlaSchemaType.DBTYPE_BOOL){

        @Override
        public OlapScalarEntity eval(OlapMemberPropertyEvalContext context, OlapMember member) {
            if (member.isFactHollow()) {
                OlapNameContext namingContext = context.getNameContext();
                return new OlapStringEntity(member.getFactIndexingMember().getUniqueName(namingContext));
            }
            return OlapEmptyEntity.INSTANCE;
        }
    };

    private OlapUserDefinedMemberProperties() {
    }
}

