/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.properties.member;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperties;
import crazydev.iccube.olap.entity.properties.member.OlapIntrinsicMemberProperties;
import crazydev.iccube.olap.entity.properties.member.OlapMemberPropertyEvalContext;
import crazydev.iccube.olap.entity.result.OlapResScopedDimensionProperty;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public class OlapMemberPropertyValues {
    private final OlapMember member;
    private final OlapCellProperties.OlapLocalizedCaption caption;
    private final List<OlapResScopedDimensionProperty> properties;
    private final List<OlapScalarEntity> values;

    private OlapMemberPropertyValues(OlapMember member, String caption, List<OlapResScopedDimensionProperty> properties, List<OlapScalarEntity> values) {
        this.member = member;
        this.caption = new OlapCellProperties.OlapLocalizedCaption(caption);
        this.properties = properties;
        this.values = values;
        if (this.properties.size() != this.values.size()) {
            throw new CdProgrammingException();
        }
    }

    public static OlapMemberPropertyValues evaluate(OlapMemberPropertyEvalContext context, @Nullable List<OlapResScopedDimensionProperty> requestedProperties, OlapMember member) {
        List<OlapResScopedDimensionProperty> properties = null;
        List<OlapScalarEntity> values = null;
        if (requestedProperties != null) {
            for (OlapResScopedDimensionProperty requestedProperty : requestedProperties) {
                OlapScalarEntity value = requestedProperty.eval(context, member);
                if (value == null) continue;
                if (properties == null) {
                    properties = new ArrayList<OlapResScopedDimensionProperty>();
                    values = new ArrayList<OlapScalarEntity>();
                }
                properties.add(requestedProperty);
                values.add(value);
            }
        }
        properties = properties == null ? Collections.emptyList() : properties;
        values = values == null ? Collections.emptyList() : values;
        OlapScalarEntity caption = OlapIntrinsicMemberProperties.MEMBER_CAPTION.eval(context, member);
        return new OlapMemberPropertyValues(member, caption.asString(), properties, values);
    }

    public List<OlapResScopedDimensionProperty> getProperties() {
        return this.properties;
    }

    public List<OlapScalarEntity> getValues() {
        return this.values;
    }

    @Nullable
    public OlapScalarEntity getPropertyValue(OlapResScopedDimensionProperty property) {
        for (int pos = 0; pos < this.properties.size(); ++pos) {
            OlapResScopedDimensionProperty xproperty = this.properties.get(pos);
            if (!xproperty.equals(property)) continue;
            return this.values.get(pos);
        }
        return null;
    }

    public String getCaption(Locale locale) {
        return this.caption.get(locale);
    }
}

