/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.properties.member;

import crazydev.common.lang.CdXmlaSchemaType;
import crazydev.common.locale.CdLanguageIdentifier;
import crazydev.iccube.enums.OlapLevelType;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapMemberKey;
import crazydev.iccube.olap.entity.properties.member.OlapIntrinsicMemberProperty;
import crazydev.iccube.olap.entity.properties.member.OlapKEYxMemberProperty;
import crazydev.iccube.olap.entity.properties.member.OlapLCIDxMemberProperty;
import crazydev.iccube.olap.entity.properties.member.OlapMemberProperty;
import crazydev.iccube.olap.entity.properties.member.OlapMemberPropertyEvalContext;
import crazydev.iccube.olap.entity.properties.member.OlapMemberType;
import crazydev.iccube.olap.entity.scalar.OlapBooleanEntity;
import crazydev.iccube.olap.entity.scalar.OlapListScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapStringEntity;
import crazydev.iccube.olap.util.CdCaseInsensitiveHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public abstract class OlapIntrinsicMemberProperties {
    public static final OlapIntrinsicMemberProperty ID = new OlapIntrinsicMemberProperty("ID", CdXmlaSchemaType.DBTYPE_WSTR, true, false){

        @Override
        public String getXmlaName(OlapNameContext nameContext) {
            return "ID";
        }

        @Override
        public int evalUniqueMaxValueCount() {
            return 1;
        }

        @Override
        public OlapScalarEntity eval(OlapMemberPropertyEvalContext context, OlapMember member) {
            return OlapEmptyEntity.INSTANCE;
        }
    };
    public static final OlapIntrinsicMemberProperty NAME = new OlapIntrinsicMemberProperty("NAME", CdXmlaSchemaType.DBTYPE_WSTR, true, true){

        @Override
        public String getXmlaName(OlapNameContext nameContext) {
            return "Name";
        }

        @Override
        public boolean isTyped() {
            return true;
        }

        @Override
        public OlapScalarEntity eval(OlapMemberPropertyEvalContext context, OlapMember member) {
            OlapNameContext nameContext = context.getNameContext();
            return new OlapStringEntity(member.getName(nameContext));
        }
    };
    public static final OlapIntrinsicMemberProperty CHILDREN_CARDINALITY = new OlapIntrinsicMemberProperty("CHILDREN_CARDINALITY", CdXmlaSchemaType.DBTYPE_UI4, true){

        @Override
        public OlapScalarEntity eval(OlapMemberPropertyEvalContext context, OlapMember member) {
            return new OlapNumericEntity(member.getXmlaChildrenCardinality(context.getSchemaPermissionsFilter()));
        }
    };
    public static final OlapIntrinsicMemberProperty CUBE_NAME = new OlapIntrinsicMemberProperty("CUBE_NAME", CdXmlaSchemaType.DBTYPE_WSTR){

        @Override
        public boolean isTyped() {
            return true;
        }

        @Override
        public int evalUniqueMaxValueCount() {
            return 1;
        }

        @Override
        public OlapScalarEntity eval(OlapMemberPropertyEvalContext context, OlapMember member) {
            return new OlapStringEntity(context.getCubeName());
        }
    };
    public static final OlapIntrinsicMemberProperty CUSTOM_ROLLUP = new OlapIntrinsicMemberProperty("CUSTOM_ROLLUP", CdXmlaSchemaType.DBTYPE_WSTR, true){

        @Override
        public int evalUniqueMaxValueCount() {
            return 1;
        }

        @Override
        public OlapScalarEntity eval(OlapMemberPropertyEvalContext context, OlapMember member) {
            return OlapEmptyEntity.INSTANCE;
        }
    };
    public static final OlapIntrinsicMemberProperty CUSTOM_ROLLUP_PROPERTIES = new OlapIntrinsicMemberProperty("CUSTOM_ROLLUP_PROPERTIES", CdXmlaSchemaType.DBTYPE_WSTR, true){

        @Override
        public int evalUniqueMaxValueCount() {
            return 1;
        }

        @Override
        public OlapScalarEntity eval(OlapMemberPropertyEvalContext context, OlapMember member) {
            return OlapEmptyEntity.INSTANCE;
        }
    };
    public static final OlapIntrinsicMemberProperty DESCRIPTION = new OlapIntrinsicMemberProperty("DESCRIPTION", CdXmlaSchemaType.DBTYPE_WSTR){

        @Override
        public boolean isTyped() {
            return true;
        }

        @Override
        public OlapScalarEntity eval(OlapMemberPropertyEvalContext context, OlapMember member) {
            return NAME.eval(context, member);
        }
    };
    public static final OlapIntrinsicMemberProperty DIMENSION_UNIQUE_NAME = new OlapIntrinsicMemberProperty("DIMENSION_UNIQUE_NAME", CdXmlaSchemaType.DBTYPE_WSTR, true){

        @Override
        public boolean isTyped() {
            return true;
        }

        @Override
        public int evalUniqueMaxValueCount() {
            return 1;
        }

        @Override
        public OlapScalarEntity eval(OlapMemberPropertyEvalContext context, OlapMember member) {
            OlapNameContext nameContext = context.getNameContext();
            return new OlapStringEntity(member.getDimension().getUniqueName(nameContext));
        }
    };
    public static final OlapIntrinsicMemberProperty HIERARCHY_UNIQUE_NAME = new OlapIntrinsicMemberProperty("HIERARCHY_UNIQUE_NAME", CdXmlaSchemaType.DBTYPE_WSTR, true){

        @Override
        public boolean isTyped() {
            return true;
        }

        @Override
        public int evalUniqueMaxValueCount() {
            return 1;
        }

        @Override
        public OlapScalarEntity eval(OlapMemberPropertyEvalContext context, OlapMember member) {
            OlapNameContext nameContext = context.getNameContext();
            return new OlapStringEntity(member.getHierarchy().getUniqueName(nameContext));
        }
    };
    public static final OlapIntrinsicMemberProperty IS_DATAMEMBER = new OlapIntrinsicMemberProperty("IS_DATAMEMBER", CdXmlaSchemaType.DBTYPE_BOOL, true){

        @Override
        public int evalUniqueMaxValueCount() {
            return 1;
        }

        @Override
        public OlapScalarEntity eval(OlapMemberPropertyEvalContext context, OlapMember member) {
            return OlapBooleanEntity.FALSE;
        }
    };
    public static final OlapIntrinsicMemberProperty LEVEL_NUMBER = new OlapIntrinsicMemberProperty("LEVEL_NUMBER", CdXmlaSchemaType.DBTYPE_UI4, true){

        @Override
        public int evalUniqueMaxValueCount() {
            return 1;
        }

        @Override
        public OlapScalarEntity eval(OlapMemberPropertyEvalContext context, OlapMember member) {
            return new OlapNumericEntity(member.getLevel().getDepth());
        }
    };
    public static final OlapIntrinsicMemberProperty LEVEL_TYPE = new OlapIntrinsicMemberProperty("LEVEL_TYPE", CdXmlaSchemaType.DBTYPE_WSTR, true){

        @Override
        public int evalUniqueMaxValueCount() {
            return 1;
        }

        @Override
        public OlapScalarEntity eval(OlapMemberPropertyEvalContext context, OlapMember member) {
            OlapLevelType levelType = member.getLevel().getLevelType();
            return levelType == null ? OlapEmptyEntity.INSTANCE : new OlapStringEntity(levelType.getName());
        }
    };
    public static final OlapIntrinsicMemberProperty LEVEL_UNIQUE_NAME = new OlapIntrinsicMemberProperty("LEVEL_UNIQUE_NAME", CdXmlaSchemaType.DBTYPE_WSTR, true){

        @Override
        public boolean isTyped() {
            return true;
        }

        @Override
        public int evalUniqueMaxValueCount() {
            return 1;
        }

        @Override
        public OlapScalarEntity eval(OlapMemberPropertyEvalContext context, OlapMember member) {
            OlapNameContext nameContext = context.getNameContext();
            return new OlapStringEntity(member.getLevel().getUniqueName(nameContext));
        }
    };
    public static final OlapIntrinsicMemberProperty MEASURE_GROUP_NAME = new OlapIntrinsicMemberProperty("MEASURE_GROUP_NAME", CdXmlaSchemaType.DBTYPE_WSTR, true){

        @Override
        public boolean isTyped() {
            return true;
        }

        @Override
        public OlapScalarEntity eval(OlapMemberPropertyEvalContext context, OlapMember member) {
            if (member instanceof OlapMeasureMember) {
                OlapMeasureMember measure = (OlapMeasureMember)member;
                return new OlapStringEntity(measure.getMeasureGroupName());
            }
            return new OlapStringEntity("not-a-measure");
        }
    };
    public static final OlapIntrinsicMemberProperty MEMBER_CAPTION = new OlapIntrinsicMemberProperty("MEMBER_CAPTION", CdXmlaSchemaType.DBTYPE_WSTR, true){

        @Override
        public boolean isCaption() {
            return true;
        }

        @Override
        public boolean isTyped() {
            return true;
        }

        @Override
        public OlapScalarEntity eval(OlapMemberPropertyEvalContext context, OlapMember member) {
            Locale locale = context.getLocale();
            OlapNameContext nameContext = context.getNameContext();
            String memberCaption = member.getCaption(locale, nameContext);
            String caption = context.getVisualTotalCaption(member, memberCaption);
            return new OlapStringEntity(caption);
        }
    };
    public static final OlapIntrinsicMemberProperty CAPTION = new OlapIntrinsicMemberProperty("CAPTION", CdXmlaSchemaType.DBTYPE_WSTR){

        @Override
        public boolean isTyped() {
            return true;
        }

        @Override
        public boolean isCaption() {
            return true;
        }

        @Override
        public OlapScalarEntity eval(OlapMemberPropertyEvalContext context, OlapMember member) {
            return MEMBER_CAPTION.eval(context, member);
        }
    };
    public static final OlapIntrinsicMemberProperty MEMBER_KEY = new OlapIntrinsicMemberProperty("MEMBER_KEY", CdXmlaSchemaType.DBTYPE_WSTR, true){

        @Override
        public OlapScalarEntity eval(OlapMemberPropertyEvalContext context, OlapMember member) {
            OlapMemberKey key = member.getKey();
            return key.asScalarEntity();
        }
    };
    public static final OlapIntrinsicMemberProperty KEY = new OlapIntrinsicMemberProperty("KEY", CdXmlaSchemaType.DBTYPE_WSTR, true, true){

        @Override
        public String getXmlaName(OlapNameContext nameContext) {
            return "Key";
        }

        @Override
        public OlapScalarEntity eval(OlapMemberPropertyEvalContext context, OlapMember member) {
            return MEMBER_KEY.eval(context, member);
        }
    };
    public static final OlapIntrinsicMemberProperty MEMBER_NAME = new OlapIntrinsicMemberProperty("MEMBER_NAME", CdXmlaSchemaType.DBTYPE_WSTR, true){

        @Override
        public boolean isTyped() {
            return true;
        }

        @Override
        public OlapScalarEntity eval(OlapMemberPropertyEvalContext context, OlapMember member) {
            return NAME.eval(context, member);
        }
    };
    public static final OlapIntrinsicMemberProperty MEMBER_VALUE = new OlapIntrinsicMemberProperty("MEMBER_VALUE", CdXmlaSchemaType.DBTYPE_VARIANT, true){

        @Override
        public boolean isTyped() {
            return true;
        }

        @Override
        public OlapScalarEntity eval(OlapMemberPropertyEvalContext context, OlapMember member) {
            return MEMBER_NAME.eval(context, member);
        }
    };
    public static final OlapIntrinsicMemberProperty MEMBER_TYPE = new OlapIntrinsicMemberProperty("MEMBER_TYPE", CdXmlaSchemaType.DBTYPE_I4, true){

        @Override
        public int evalUniqueMaxValueCount() {
            return 4;
        }

        @Override
        public OlapScalarEntity eval(OlapMemberPropertyEvalContext context, OlapMember member) {
            if (member.isCalculated()) {
                return new OlapNumericEntity(OlapMemberType.MDMEMBER_TYPE_FORMULA.ordinal());
            }
            if (member.isMeasure()) {
                return new OlapNumericEntity(OlapMemberType.MDMEMBER_TYPE_MEASURE.ordinal());
            }
            if (member.isAllMember()) {
                return new OlapNumericEntity(OlapMemberType.MDMEMBER_TYPE_ALL.ordinal());
            }
            return new OlapNumericEntity(OlapMemberType.MDMEMBER_TYPE_REGULAR.ordinal());
        }
    };
    public static final OlapIntrinsicMemberProperty MEMBER_UNIQUE_NAME = new OlapIntrinsicMemberProperty("MEMBER_UNIQUE_NAME", CdXmlaSchemaType.DBTYPE_WSTR, true){

        @Override
        public boolean isTyped() {
            return true;
        }

        @Override
        public OlapScalarEntity eval(OlapMemberPropertyEvalContext context, OlapMember member) {
            OlapNameContext nameContext = context.getNameContext();
            return new OlapStringEntity(member.getUniqueName(nameContext));
        }
    };
    public static final OlapIntrinsicMemberProperty MEMBER_ORDINAL = new OlapIntrinsicMemberProperty("MEMBER_ORDINAL", CdXmlaSchemaType.DBTYPE_UI4, true){

        @Override
        public int evalUniqueMaxValueCount() {
            return 1;
        }

        @Override
        public OlapScalarEntity eval(OlapMemberPropertyEvalContext context, OlapMember member) {
            return OlapNumericEntity.ZERO_AS_LONG;
        }
    };
    public static final OlapIntrinsicMemberProperty PARENT_COUNT = new OlapIntrinsicMemberProperty("PARENT_COUNT", CdXmlaSchemaType.DBTYPE_UI4, true){

        @Override
        public int evalUniqueMaxValueCount() {
            return 2;
        }

        @Override
        public OlapScalarEntity eval(OlapMemberPropertyEvalContext context, OlapMember member) {
            return member.getParent() == null ? OlapNumericEntity.ZERO_AS_LONG : OlapNumericEntity.ONE_AS_LONG;
        }
    };
    public static final OlapIntrinsicMemberProperty PARENT_LEVEL = new OlapIntrinsicMemberProperty("PARENT_LEVEL", CdXmlaSchemaType.DBTYPE_UI4, true){

        @Override
        public OlapScalarEntity eval(OlapMemberPropertyEvalContext context, OlapMember member) {
            OlapMember parent = member.getParent();
            return parent == null ? OlapEmptyEntity.INSTANCE : new OlapNumericEntity(parent.getLevel().getDepth());
        }
    };
    public static final OlapIntrinsicMemberProperty PARENT_UNIQUE_NAME = new OlapIntrinsicMemberProperty("PARENT_UNIQUE_NAME", CdXmlaSchemaType.DBTYPE_WSTR, true){

        @Override
        public OlapScalarEntity eval(OlapMemberPropertyEvalContext context, OlapMember member) {
            OlapNameContext nameContext = context.getNameContext();
            OlapMember parent = member.getParent();
            return parent == null ? OlapEmptyEntity.INSTANCE : new OlapStringEntity(parent.getUniqueName(nameContext));
        }
    };
    public static final OlapIntrinsicMemberProperty PATH_TO_ROOT = new OlapIntrinsicMemberProperty("PATH_TO_ROOT", CdXmlaSchemaType.DBTYPE_VARIANT, true){

        @Override
        public OlapScalarEntity eval(OlapMemberPropertyEvalContext context, OlapMember member) {
            ArrayList names = new ArrayList();
            OlapNameContext nameContext = context.getNameContext();
            for (OlapMember parent = member.getParent(); parent != null; parent = parent.getParent()) {
                names.add(new OlapStringEntity(parent.getUniqueName(nameContext)));
            }
            if (!names.isEmpty()) {
                return new OlapListScalarEntity(names);
            }
            return OlapEmptyEntity.INSTANCE;
        }
    };
    public static final OlapIntrinsicMemberProperty SKIPPED_LEVELS = new OlapIntrinsicMemberProperty("SKIPPED_LEVELS", CdXmlaSchemaType.DBTYPE_I4){

        @Override
        public int evalUniqueMaxValueCount() {
            return 1;
        }

        @Override
        public OlapScalarEntity eval(OlapMemberPropertyEvalContext context, OlapMember member) {
            return OlapNumericEntity.ZERO_AS_LONG;
        }
    };
    public static final OlapIntrinsicMemberProperty UNARY_OPERATOR = new OlapIntrinsicMemberProperty("UNARY_OPERATOR", CdXmlaSchemaType.DBTYPE_WSTR, true){

        @Override
        public int evalUniqueMaxValueCount() {
            return 1;
        }

        @Override
        public OlapScalarEntity eval(OlapMemberPropertyEvalContext context, OlapMember member) {
            return OlapEmptyEntity.INSTANCE;
        }
    };
    public static final OlapIntrinsicMemberProperty UNIQUE_NAME = new OlapIntrinsicMemberProperty("UNIQUE_NAME", CdXmlaSchemaType.DBTYPE_WSTR, true){

        @Override
        public boolean isTyped() {
            return true;
        }

        @Override
        public OlapScalarEntity eval(OlapMemberPropertyEvalContext context, OlapMember member) {
            return MEMBER_UNIQUE_NAME.eval(context, member);
        }
    };
    private static final CdCaseInsensitiveHashMap<OlapIntrinsicMemberProperty> intrinsicProperties = new CdCaseInsensitiveHashMap();
    private static final CdCaseInsensitiveHashMap<OlapMemberProperty> parseableProperties = new CdCaseInsensitiveHashMap();

    @Nullable
    public static OlapIntrinsicMemberProperty getIntrinsicProperty(String name) {
        OlapIntrinsicMemberProperty prop = (OlapIntrinsicMemberProperty)intrinsicProperties.get(name);
        if (prop != null) {
            return prop;
        }
        String xname = name.toUpperCase();
        if (xname.startsWith("KEY") && xname.length() > 3) {
            try {
                String keyN;
                String number = xname.substring(3);
                int val = Integer.parseInt(number);
                if (val >= 0 && (keyN = "KEY" + val).equals(xname)) {
                    prop = new OlapKEYxMemberProperty(val);
                    OlapIntrinsicMemberProperties.registerIntrinsicProperty(prop);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return prop;
    }

    public static boolean isParseable(String name) {
        return parseableProperties.containsKey(name);
    }

    public static Iterable<String> getAllNames() {
        return new ArrayList<String>((Collection<String>)parseableProperties.keySet());
    }

    private static void registerIntrinsicProperty(OlapIntrinsicMemberProperty property) {
        intrinsicProperties.put(property.getName(), property);
        if (property.isParseable()) {
            parseableProperties.put(property.getName(), property);
        }
    }

    public static void register() {
        intrinsicProperties.trim();
        parseableProperties.trim();
    }

    static {
        OlapIntrinsicMemberProperties.registerIntrinsicProperty(ID);
        OlapIntrinsicMemberProperties.registerIntrinsicProperty(KEY);
        OlapIntrinsicMemberProperties.registerIntrinsicProperty(NAME);
        OlapIntrinsicMemberProperties.registerIntrinsicProperty(CAPTION);
        OlapIntrinsicMemberProperties.registerIntrinsicProperty(CHILDREN_CARDINALITY);
        OlapIntrinsicMemberProperties.registerIntrinsicProperty(CUBE_NAME);
        OlapIntrinsicMemberProperties.registerIntrinsicProperty(CUSTOM_ROLLUP);
        OlapIntrinsicMemberProperties.registerIntrinsicProperty(CUSTOM_ROLLUP_PROPERTIES);
        OlapIntrinsicMemberProperties.registerIntrinsicProperty(DESCRIPTION);
        OlapIntrinsicMemberProperties.registerIntrinsicProperty(DIMENSION_UNIQUE_NAME);
        OlapIntrinsicMemberProperties.registerIntrinsicProperty(HIERARCHY_UNIQUE_NAME);
        OlapIntrinsicMemberProperties.registerIntrinsicProperty(IS_DATAMEMBER);
        for (CdLanguageIdentifier localeId : CdLanguageIdentifier.values()) {
            OlapIntrinsicMemberProperties.registerIntrinsicProperty(new OlapLCIDxMemberProperty(localeId));
        }
        OlapIntrinsicMemberProperties.registerIntrinsicProperty(LEVEL_TYPE);
        OlapIntrinsicMemberProperties.registerIntrinsicProperty(LEVEL_NUMBER);
        OlapIntrinsicMemberProperties.registerIntrinsicProperty(LEVEL_UNIQUE_NAME);
        OlapIntrinsicMemberProperties.registerIntrinsicProperty(MEASURE_GROUP_NAME);
        OlapIntrinsicMemberProperties.registerIntrinsicProperty(MEMBER_CAPTION);
        OlapIntrinsicMemberProperties.registerIntrinsicProperty(MEMBER_KEY);
        OlapIntrinsicMemberProperties.registerIntrinsicProperty(MEMBER_NAME);
        OlapIntrinsicMemberProperties.registerIntrinsicProperty(MEMBER_TYPE);
        OlapIntrinsicMemberProperties.registerIntrinsicProperty(MEMBER_UNIQUE_NAME);
        OlapIntrinsicMemberProperties.registerIntrinsicProperty(MEMBER_VALUE);
        OlapIntrinsicMemberProperties.registerIntrinsicProperty(MEMBER_ORDINAL);
        OlapIntrinsicMemberProperties.registerIntrinsicProperty(PARENT_COUNT);
        OlapIntrinsicMemberProperties.registerIntrinsicProperty(PARENT_LEVEL);
        OlapIntrinsicMemberProperties.registerIntrinsicProperty(PARENT_UNIQUE_NAME);
        OlapIntrinsicMemberProperties.registerIntrinsicProperty(PATH_TO_ROOT);
        OlapIntrinsicMemberProperties.registerIntrinsicProperty(SKIPPED_LEVELS);
        OlapIntrinsicMemberProperties.registerIntrinsicProperty(UNARY_OPERATOR);
        OlapIntrinsicMemberProperties.registerIntrinsicProperty(UNIQUE_NAME);
    }
}

