/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.properties.cell;

import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperty;
import crazydev.iccube.olap.entity.properties.cell.OlapCellPropertyValue;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFCellPropertyEvalContext;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNodeBuildContext;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.literal.OlapLiteralInstr;
import crazydev.iccube.olap.eval.literal.OlapStringLiteralInstr;
import org.jetbrains.annotations.Nullable;

public abstract class OlapMdxCellPropertyValue
extends OlapCellPropertyValue {
    private final OlapInstr value;

    public OlapMdxCellPropertyValue(OlapCellProperty property, String expression, OlapInstr value) {
        super(property, expression);
        this.value = value;
    }

    @Override
    public boolean isMdx() {
        return true;
    }

    @Override
    @Nullable
    public String asStringValue() {
        if (this.value instanceof OlapStringLiteralInstr) {
            return ((OlapStringLiteralInstr)this.value).getValue().asString();
        }
        return null;
    }

    @Override
    @Nullable
    public OlapScalarEntity eval(GFCellPropertyEvalContext context, @Nullable OlapScalarEntity cellValue) {
        if (cellValue == null && !(this.value instanceof OlapLiteralInstr)) {
            return null;
        }
        GFNode expr = this.getValueNode(context);
        OlapEntity entity = context.evalProperty(this, expr);
        if (entity.isMdxNull()) {
            return null;
        }
        return this.assertEntityType(context, entity);
    }

    private GFNode getValueNode(GFCellPropertyEvalContext context) {
        OlapPreparedInstr prepared = this.value.prepare(context.getPrepareContext());
        GFNode tree = prepared.buildGFTree(new GFNodeBuildContext(context.hasInstrExecListener()), true);
        return tree;
    }

    protected abstract OlapScalarEntity assertEntityType(IOlapEvaluationExceptionContext var1, OlapEntity var2);
}

