/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.properties.cell;

import crazydev.common.lang.CdXmlaSchemaType;
import crazydev.common.mdx.CdMdxColorUtils;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperty;
import crazydev.iccube.olap.entity.properties.cell.OlapCellPropertyValue;
import crazydev.iccube.olap.entity.properties.cell.OlapFormatStringHelper;
import crazydev.iccube.olap.entity.properties.cell.OlapFormatStringMdxCellPropertyValue;
import crazydev.iccube.olap.entity.properties.cell.OlapLanguageMdxCellPropertyValue;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapStringEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFCellPropertyEvalContext;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class OlapIntrinsicCellProperties {
    public static final OlapCellProperty ACTION_TYPE = new OlapCellProperty("ActionType", "ACTION_TYPE", CdXmlaSchemaType.DBTYPE_UI4);
    public static final OlapCellProperty BACK_COLOR = new OlapCellProperty("BackColor", "BACK_COLOR", CdXmlaSchemaType.DBTYPE_UI4);
    public static final OlapCellProperty CELL_ORDINAL = new OlapCellProperty("CellOrdinal", "CELL_ORDINAL", CdXmlaSchemaType.DBTYPE_UI4, true){

        @Override
        public boolean isCellOrdinal() {
            return true;
        }

        @Override
        public OlapScalarEntity eval(GFCellPropertyEvalContext context, @Nullable OlapScalarEntity cellValue) {
            return new OlapNumericEntity(this.getXmlaType(), context.getCellOrdinal());
        }
    };
    public static final OlapCellProperty ICC_CLASS_NAME = new OlapCellProperty("className", "className", CdXmlaSchemaType.DBTYPE_WSTR);
    public static final OlapCellProperty FONT_FLAGS = new OlapCellProperty("FontFlags", "FONT_FLAGS", CdXmlaSchemaType.DBTYPE_I4);
    public static final OlapCellProperty FONT_NAME = new OlapCellProperty("FontName", "FONT_NAME", CdXmlaSchemaType.DBTYPE_WSTR);
    public static final OlapCellProperty FONT_SIZE = new OlapCellProperty("FontSize", "FONT_SIZE", CdXmlaSchemaType.DBTYPE_UI2);
    public static final OlapCellProperty FORE_COLOR = new OlapCellProperty("ForeColor", "FORE_COLOR", CdXmlaSchemaType.DBTYPE_UI4);
    public static final OlapCellProperty ICC_STYLE = new OlapCellProperty("style", "style", CdXmlaSchemaType.DBTYPE_WSTR){

        @Override
        @Nullable
        public OlapScalarEntity eval(GFCellPropertyEvalContext context, @Nullable OlapScalarEntity cellValue) {
            String asText;
            OlapNumericEntity color;
            OlapScalarEntity style = super.eval(context, cellValue);
            if (style != null) {
                return style;
            }
            OlapScalarEntity backColor = OlapIntrinsicCellProperties.getValue(context, cellValue, BACK_COLOR);
            OlapScalarEntity fontFlag = OlapIntrinsicCellProperties.getValue(context, cellValue, FONT_FLAGS);
            OlapScalarEntity fontName = OlapIntrinsicCellProperties.getValue(context, cellValue, FONT_NAME);
            OlapScalarEntity fontSize = OlapIntrinsicCellProperties.getValue(context, cellValue, FONT_SIZE);
            OlapScalarEntity fontColor = OlapIntrinsicCellProperties.getValue(context, cellValue, FORE_COLOR);
            Object cssStyle = "";
            if (backColor instanceof OlapNumericEntity) {
                color = (OlapNumericEntity)backColor;
                asText = CdMdxColorUtils.hexValue((int)color.intValue());
                cssStyle = (String)cssStyle + "background-color:" + asText + ";";
            }
            if (fontFlag != null) {
                try {
                    int flag = Integer.parseInt(fontFlag.toString());
                    if ((flag & 1) != 0) {
                        cssStyle = (String)cssStyle + "font-weight:bold;";
                    }
                    if ((flag & 2) != 0) {
                        cssStyle = (String)cssStyle + "font-style:italic;";
                    }
                    if ((flag & 4) != 0) {
                        cssStyle = (String)cssStyle + "text-decoration:underline;";
                    }
                    if ((flag & 8) != 0) {
                        cssStyle = (String)cssStyle + "text-decoration:line-through;";
                    }
                }
                catch (NumberFormatException flag) {
                    // empty catch block
                }
            }
            if (fontName != null) {
                cssStyle = (String)cssStyle + "font-family:'" + String.valueOf(fontName) + "';";
            }
            if (fontSize != null) {
                cssStyle = (String)cssStyle + "font-size:'" + String.valueOf(fontSize) + "px';";
            }
            if (fontColor instanceof OlapNumericEntity) {
                color = (OlapNumericEntity)fontColor;
                asText = CdMdxColorUtils.hexValue((int)color.intValue());
                cssStyle = (String)cssStyle + "color:" + asText + ";";
            }
            if (((String)cssStyle).isEmpty()) {
                return null;
            }
            return new OlapStringEntity((String)cssStyle);
        }
    };
    public static final OlapCellProperty FORMAT_STRING = new OlapCellProperty("FormatString", "FORMAT_STRING", CdXmlaSchemaType.DBTYPE_WSTR){

        @Override
        public boolean isFormatString() {
            return true;
        }

        @Override
        public OlapCellPropertyValue createValue(String expression, OlapInstr value) {
            return new OlapFormatStringMdxCellPropertyValue(this, expression, value);
        }
    };
    public static final OlapCellProperty LANGUAGE = new OlapCellProperty("Language", "LANGUAGE", CdXmlaSchemaType.DBTYPE_UI4){

        @Override
        public OlapCellPropertyValue createValue(String expression, OlapInstr value) {
            return new OlapLanguageMdxCellPropertyValue(this, expression, value);
        }
    };
    public static final OlapCellProperty FORMATTED_VALUE = new OlapCellProperty("FmtValue", "FORMATTED_VALUE", CdXmlaSchemaType.DBTYPE_WSTR, true){

        @Override
        public boolean isFormattedValue() {
            return true;
        }

        @Override
        @Nullable
        public OlapScalarEntity eval(GFCellPropertyEvalContext context, @Nullable OlapScalarEntity cellValue) {
            String fv;
            String string = fv = cellValue == null ? null : cellValue.getFormattedValue();
            if (fv != null) {
                return new OlapStringEntity(fv);
            }
            OlapCellPropertyValue formatStringValue = context.getCellPropertyValue(FORMAT_STRING);
            return OlapFormatStringHelper.format(context, formatStringValue, cellValue);
        }
    };
    public static final OlapCellProperty FORMATTED_VALUE_EX = new OlapCellProperty("FmtValueEx", "FORMATTED_VALUE_EX", CdXmlaSchemaType.DBTYPE_WSTR, true){

        @Override
        public boolean isFormattedValueEx() {
            return true;
        }

        @Override
        @Nullable
        public OlapScalarEntity eval(GFCellPropertyEvalContext context, @Nullable OlapScalarEntity cellValue) {
            String fv;
            String string = fv = cellValue == null ? null : cellValue.getFormattedValue();
            if (fv != null) {
                return new OlapStringEntity(fv);
            }
            OlapCellPropertyValue formatStringValue = context.getCellPropertyValue(FORMAT_STRING);
            if (formatStringValue != null) {
                return OlapFormatStringHelper.format(context, formatStringValue, cellValue);
            }
            return null;
        }
    };
    public static final OlapCellProperty UPDATEABLE = new OlapCellProperty("Updateable", "UPDATEABLE", CdXmlaSchemaType.DBTYPE_UI4);
    public static final OlapCellProperty VALUE = new OlapCellProperty("Value", "VALUE", CdXmlaSchemaType.DBTYPE_VARIANT, true){

        @Override
        public boolean isValue() {
            return true;
        }

        @Override
        @Nullable
        public OlapScalarEntity eval(GFCellPropertyEvalContext context, @Nullable OlapScalarEntity cellValue) {
            return cellValue;
        }
    };
    public static final List<OlapCellProperty> DEFAULT = Collections.unmodifiableList(new ArrayList<OlapCellProperty>(Arrays.asList(VALUE, FORMATTED_VALUE, CELL_ORDINAL)));
    public static final List<OlapCellProperty> DEFAULT_EX = Collections.unmodifiableList(new ArrayList<OlapCellProperty>(Arrays.asList(CELL_ORDINAL, VALUE, FORMATTED_VALUE_EX, FORMAT_STRING, BACK_COLOR, FORE_COLOR)));

    @Nullable
    private static OlapScalarEntity getValue(GFCellPropertyEvalContext context, OlapScalarEntity cellValue, OlapCellProperty property) {
        OlapCellPropertyValue prop = context.getCellPropertyValue(property);
        if (prop == null) {
            return null;
        }
        return prop.eval(context, cellValue);
    }
}

