/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.properties.cell;

import org.jetbrains.annotations.Nullable;

public enum OlapFormatStringName {
    Fixed("Fixed", "0.00"),
    Percent("Percent", "0.00%"),
    Standard("Standard", "#,##0.00"),
    Currency("Currency", "$#,##0.00"),
    Scientific("Scientific", "0.00E+00"),
    Yes_No("Yes/No", null),
    On_Off("On/Off", null),
    True_False("True/False", null),
    ElapsedMillis("ElapsedMillis", null);

    private final String formatName;
    @Nullable
    private final String excelDataFormat;

    private OlapFormatStringName(String formatName, String excelDataFormat) {
        this.formatName = formatName;
        this.excelDataFormat = excelDataFormat;
    }

    @Nullable
    public String getExcelDataFormat() {
        return this.excelDataFormat;
    }

    @Nullable
    public static OlapFormatStringName fromStandardName(@Nullable String name) {
        if (name == null) {
            return null;
        }
        for (OlapFormatStringName fsName : OlapFormatStringName.values()) {
            if (!fsName.formatName.equalsIgnoreCase(name)) continue;
            return fsName;
        }
        return null;
    }
}

