/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.properties.cell;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.olap.entity.properties.cell.OlapCellPropertyValue;
import crazydev.iccube.olap.entity.properties.cell.OlapFormatStringName;
import crazydev.iccube.olap.entity.properties.cell.OlapFormatStringSyntax;
import crazydev.iccube.olap.entity.scalar.OlapAbstractStringEntity;
import crazydev.iccube.olap.entity.scalar.OlapFormatterStringEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapStringEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFCellPropertyEvalContext;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

public abstract class OlapFormatStringHelper {
    private static final Map<String, PredefinedFormatter> predefinedStyles = new HashMap<String, PredefinedFormatter>();
    private static PeriodFormatter Formatter_ElapsedMillis_H_M_S_MS = new PeriodFormatterBuilder().printZeroAlways().minimumPrintedDigits(2).appendHours().appendSuffix("h ").minimumPrintedDigits(2).appendMinutes().appendSuffix("m ").minimumPrintedDigits(2).appendSeconds().appendSuffix("s ").minimumPrintedDigits(3).appendMillis().appendSuffix("ms").toFormatter();
    private static PeriodFormatter Formatter_ElapsedMillis_M_S_MS = new PeriodFormatterBuilder().printZeroAlways().minimumPrintedDigits(2).appendMinutes().appendSuffix("m ").minimumPrintedDigits(2).appendSeconds().appendSuffix("s ").minimumPrintedDigits(3).appendMillis().appendSuffix("ms").toFormatter();
    private static PeriodFormatter Formatter_ElapsedMillis_S_MS = new PeriodFormatterBuilder().printZeroAlways().minimumPrintedDigits(2).appendSeconds().appendSuffix("s ").minimumPrintedDigits(3).appendMillis().appendSuffix("ms").toFormatter();
    private static PeriodFormatter Formatter_ElapsedMillis_MS = new PeriodFormatterBuilder().printZeroAlways().minimumPrintedDigits(3).appendMillis().appendSuffix("ms").toFormatter();

    @Nullable
    public static OlapScalarEntity format(GFCellPropertyEvalContext context, @Nullable OlapCellPropertyValue formatStringValue, @Nullable OlapScalarEntity cellValue) {
        if (formatStringValue == null) {
            return OlapFormatStringHelper.asString(cellValue);
        }
        OlapScalarEntity formatString = formatStringValue.eval(context, cellValue);
        if (formatString == null) {
            return OlapFormatStringHelper.asString(cellValue);
        }
        if (formatString instanceof OlapAbstractStringEntity) {
            return OlapFormatStringHelper.format(context, (OlapAbstractStringEntity)formatString, cellValue);
        }
        return OlapFormatStringHelper.asString(cellValue);
    }

    @Nullable
    private static OlapScalarEntity format(GFCellPropertyEvalContext context, OlapAbstractStringEntity formatString, @Nullable OlapScalarEntity cellValue) {
        if (formatString instanceof OlapFormatterStringEntity) {
            return OlapFormatStringHelper.format(context, (OlapFormatterStringEntity)formatString, cellValue);
        }
        Locale locale = context.getFormattedValueLocale(cellValue);
        String format = formatString.value();
        if ("$Embedded$".equalsIgnoreCase(format)) {
            return null;
        }
        PredefinedFormatter predefinedFormatter = predefinedStyles.get(format.toUpperCase());
        if (predefinedFormatter != null) {
            return predefinedFormatter.format(locale, format, cellValue);
        }
        if (cellValue != null) {
            if (cellValue.hasSpecialFormatter()) {
                return new OlapStringEntity(cellValue.specialFormat(locale, format));
            }
            OlapFormatStringSyntax actualFormatStringSyntax = formatString.isExcelFormatString() ? OlapFormatStringSyntax.EXCEL : (formatString.isJavaFormatString() ? OlapFormatStringSyntax.JAVA : context.getDefaultFormatStringSyntax());
            switch (actualFormatStringSyntax) {
                case EXCEL: {
                    return OlapFormatStringHelper.formatExcel(context, locale, cellValue, format);
                }
                case JAVA: {
                    return OlapFormatStringHelper.formatJava(context, locale, cellValue, format);
                }
            }
            throw new CdProgrammingException("internal error : unexpected FORMAT_STRING syntax [" + String.valueOf((Object)actualFormatStringSyntax) + "]");
        }
        return null;
    }

    @Nullable
    private static OlapScalarEntity formatBoolean(@Nullable OlapScalarEntity cellValue, String format) {
        if (cellValue != null && cellValue.isMdxNull()) {
            return null;
        }
        Double asInt = (Double)(cellValue == null ? null : cellValue.asJavaNativeValue(Double.class));
        String[] split = format.split("/");
        if (asInt == null || asInt == 0.0) {
            String falseCaption = split.length > 1 ? split[1] : "False";
            return new OlapStringEntity(falseCaption);
        }
        String trueCaption = split.length > 0 ? split[0] : "True";
        return new OlapStringEntity(trueCaption);
    }

    @Nullable
    private static OlapScalarEntity formatExcel(GFCellPropertyEvalContext context, Locale locale, OlapScalarEntity cellValue, String actualFormatString) {
        String formatted = cellValue.excelFormat(context, locale, actualFormatString);
        return formatted == null ? null : new OlapStringEntity(formatted);
    }

    @Nullable
    private static OlapScalarEntity formatJava(GFCellPropertyEvalContext context, Locale locale, OlapScalarEntity cellValue, String actualFormatString) {
        String formatted = cellValue.javaFormat(context, locale, actualFormatString);
        return formatted == null ? null : new OlapStringEntity(formatted);
    }

    @Nullable
    private static OlapScalarEntity format(GFCellPropertyEvalContext context, OlapFormatterStringEntity formatString, @Nullable OlapScalarEntity cellValue) {
        return formatString.format(context, cellValue);
    }

    @Nullable
    private static OlapScalarEntity formatNumeric(Locale locale, @Nullable OlapScalarEntity cellValue, String pattern) {
        if (cellValue instanceof OlapNumericEntity) {
            OlapNumericEntity numeric = (OlapNumericEntity)cellValue;
            double value = numeric.value();
            DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
            symbols.setNaN("NaN");
            symbols.setInfinity("Infinity");
            DecimalFormat format = new DecimalFormat(pattern, symbols);
            return new OlapStringEntity(format.format(value));
        }
        return OlapFormatStringHelper.asString(cellValue);
    }

    @Nullable
    private static OlapScalarEntity formatCurrency(Locale locale, @Nullable OlapScalarEntity cellValue) {
        if (cellValue instanceof OlapNumericEntity) {
            OlapNumericEntity numeric = (OlapNumericEntity)cellValue;
            double value = numeric.value();
            NumberFormat currencyFormatter = NumberFormat.getCurrencyInstance(locale);
            return new OlapStringEntity(currencyFormatter.format(value));
        }
        return OlapFormatStringHelper.asString(cellValue);
    }

    @Nullable
    private static OlapScalarEntity formatElapsedTime(Locale locale, @Nullable OlapScalarEntity cellValue) {
        if (cellValue instanceof OlapNumericEntity) {
            OlapNumericEntity numeric = (OlapNumericEntity)cellValue;
            long elapsed = numeric.longValue();
            if (elapsed >= 3600000L) {
                PeriodFormatter format = Formatter_ElapsedMillis_H_M_S_MS.withLocale(locale);
                return new OlapStringEntity(format.print((ReadablePeriod)new Period(elapsed)));
            }
            if (elapsed >= 60000L) {
                PeriodFormatter format = Formatter_ElapsedMillis_M_S_MS.withLocale(locale);
                return new OlapStringEntity(format.print((ReadablePeriod)new Period(elapsed)));
            }
            if (elapsed >= 1000L) {
                PeriodFormatter format = Formatter_ElapsedMillis_S_MS.withLocale(locale);
                return new OlapStringEntity(format.print((ReadablePeriod)new Period(elapsed)));
            }
            PeriodFormatter format = Formatter_ElapsedMillis_MS.withLocale(locale);
            return new OlapStringEntity(format.print((ReadablePeriod)new Period(elapsed)));
        }
        return OlapFormatStringHelper.asString(cellValue);
    }

    @Nullable
    private static OlapScalarEntity asString(OlapScalarEntity cellValue) {
        if (cellValue == null || cellValue.isMdxNull()) {
            return null;
        }
        return new OlapStringEntity(cellValue.asString());
    }

    static {
        predefinedStyles.put(OlapFormatStringName.Fixed.name().toUpperCase(), new PredefinedFormatter(){

            @Override
            public OlapScalarEntity format(Locale locale, String format, @Nullable OlapScalarEntity cellValue) {
                return OlapFormatStringHelper.formatNumeric(locale, cellValue, "0.00");
            }
        });
        predefinedStyles.put(OlapFormatStringName.Percent.name().toUpperCase(), new PredefinedFormatter(){

            @Override
            public OlapScalarEntity format(Locale locale, String format, @Nullable OlapScalarEntity cellValue) {
                return OlapFormatStringHelper.formatNumeric(locale, cellValue, "0.00%");
            }
        });
        predefinedStyles.put(OlapFormatStringName.Standard.name().toUpperCase(), new PredefinedFormatter(){

            @Override
            public OlapScalarEntity format(Locale locale, String format, @Nullable OlapScalarEntity cellValue) {
                return OlapFormatStringHelper.formatNumeric(locale, cellValue, "###,##0.00");
            }
        });
        predefinedStyles.put(OlapFormatStringName.Currency.name().toUpperCase(), new PredefinedFormatter(){

            @Override
            public OlapScalarEntity format(Locale locale, String format, @Nullable OlapScalarEntity cellValue) {
                return OlapFormatStringHelper.formatCurrency(locale, cellValue);
            }
        });
        predefinedStyles.put(OlapFormatStringName.Scientific.name().toUpperCase(), new PredefinedFormatter(){

            @Override
            public OlapScalarEntity format(Locale locale, String format, @Nullable OlapScalarEntity cellValue) {
                return OlapFormatStringHelper.formatNumeric(locale, cellValue, "0.00E0");
            }
        });
        predefinedStyles.put(OlapFormatStringName.ElapsedMillis.name().toUpperCase(), new PredefinedFormatter(){

            @Override
            public OlapScalarEntity format(Locale locale, String format, @Nullable OlapScalarEntity cellValue) {
                return OlapFormatStringHelper.formatElapsedTime(locale, cellValue);
            }
        });
        predefinedStyles.put(OlapFormatStringName.Yes_No.name().replace("_", "/").toUpperCase(), new PredefinedFormatter(){

            @Override
            public OlapScalarEntity format(Locale locale, String format, @Nullable OlapScalarEntity cellValue) {
                return OlapFormatStringHelper.formatBoolean(cellValue, format);
            }
        });
        predefinedStyles.put(OlapFormatStringName.True_False.name().replace("_", "/").toUpperCase(), new PredefinedFormatter(){

            @Override
            public OlapScalarEntity format(Locale locale, String format, @Nullable OlapScalarEntity cellValue) {
                return OlapFormatStringHelper.formatBoolean(cellValue, format);
            }
        });
        predefinedStyles.put(OlapFormatStringName.On_Off.name().replace("_", "/").toUpperCase(), new PredefinedFormatter(){

            @Override
            public OlapScalarEntity format(Locale locale, String format, @Nullable OlapScalarEntity cellValue) {
                return OlapFormatStringHelper.formatBoolean(cellValue, format);
            }
        });
    }

    private static interface PredefinedFormatter {
        @Nullable
        public OlapScalarEntity format(Locale var1, String var2, @Nullable OlapScalarEntity var3);
    }
}

