/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.properties.cell;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.lang.CdXmlaSchemaType;
import crazydev.iccube.olap.entity.properties.cell.OlapCellPropertyValue;
import crazydev.iccube.olap.entity.properties.cell.OlapIntegerMdxCellPropertyValue;
import crazydev.iccube.olap.entity.properties.cell.OlapStringMdxCellPropertyValue;
import crazydev.iccube.olap.entity.properties.cell.OlapUnsignedIntegerMdxCellPropertyValue;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFCellPropertyEvalContext;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import org.jetbrains.annotations.Nullable;

public class OlapCellProperty {
    private final String name;
    private final String xmlaName;
    private final CdXmlaSchemaType xmlaType;
    private final boolean readOnly;

    public OlapCellProperty(String xmlaName, String name, CdXmlaSchemaType xmlaType) {
        this(xmlaName, name, xmlaType, false);
    }

    public OlapCellProperty(String xmlaName, String name, CdXmlaSchemaType xmlaType, boolean readOnly) {
        this.xmlaName = xmlaName;
        this.xmlaType = xmlaType;
        this.name = name;
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isCellOrdinal() {
        return false;
    }

    public boolean isFormattedValue() {
        return false;
    }

    public boolean isFormattedValueEx() {
        return false;
    }

    public boolean isValue() {
        return false;
    }

    public boolean isFormatString() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getXmlaName() {
        return this.xmlaName;
    }

    public CdXmlaSchemaType getXmlaType() {
        return this.xmlaType;
    }

    @Nullable
    public OlapScalarEntity eval(GFCellPropertyEvalContext context, @Nullable OlapScalarEntity cellValue) {
        OlapCellPropertyValue value = context.getCellPropertyValue(this);
        return value == null ? null : value.eval(context, cellValue);
    }

    public OlapCellPropertyValue createValue(String expression, OlapInstr value) {
        if (this.readOnly) {
            throw new CdProgrammingException("The cell property [" + this.getName() + "] is read-only.");
        }
        switch (this.xmlaType) {
            case DBTYPE_WSTR: {
                return new OlapStringMdxCellPropertyValue(this, expression, value);
            }
            case DBTYPE_I8: 
            case DBTYPE_I4: 
            case DBTYPE_I2: {
                return new OlapIntegerMdxCellPropertyValue(this, expression, value);
            }
            case DBTYPE_UI8: 
            case DBTYPE_UI4: 
            case DBTYPE_UI2: {
                return new OlapUnsignedIntegerMdxCellPropertyValue(this, expression, value);
            }
        }
        throw new CdProgrammingException("Inconsistent property [" + this.name + "] [xmlaType:" + String.valueOf(this.xmlaType) + "]");
    }

    public final boolean equals(Object o) {
        return this == o;
    }

    public final int hashCode() {
        return System.identityHashCode(this);
    }

    public String toString() {
        return this.name;
    }
}

