/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.properties.cell;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.olap.entity.cmember.OlapScopeIsolation;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperty;
import crazydev.iccube.olap.entity.properties.cell.OlapCellPropertyValue;
import crazydev.iccube.olap.entity.properties.cell.OlapIntrinsicCellProperties;
import crazydev.iccube.olap.entity.properties.cell.OlapStringMdxCellPropertyValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class OlapCellProperties {
    @Nullable
    private final OlapLocalizedCaption caption;
    @Nullable
    private final String description;
    @Nullable
    private final String displayFolder;
    @Nullable
    private final String associatedMeasureGroup;
    @Nullable
    private final List<OlapEntityIdentifier> nonEmptyBehavior;
    private final int visible;
    private final int solveOrder;
    @Nullable
    private final Boolean isCached;
    @Nullable
    private final OlapScopeIsolation scopeIsolation;
    @Nullable
    private final OlapAggregationType aggregationType;
    private final List<OlapCellPropertyValue> cellPropertyValues;
    private final Map<OlapCellProperty, OlapCellPropertyValue> cellProperties;
    @Nullable
    private Boolean emptyIsZero;

    public OlapCellProperties() {
        this(null, null, null, null, null, 1, 0, null, null, null, null, new ArrayList<OlapCellPropertyValue>());
    }

    public OlapCellProperties(@Nullable String caption, @Nullable String description, @Nullable String displayFolder, @Nullable String associatedMeasureGroup, @Nullable List<OlapEntityIdentifier> nonEmptyBehavior, int visible, int solveOrder, @Nullable Boolean isCached, @Nullable OlapScopeIsolation scopeIsolation, @Nullable OlapAggregationType aggregationType, @Nullable Boolean emptyIsZero, List<OlapCellPropertyValue> cellPropertyValues) {
        this.caption = new OlapLocalizedCaption(caption);
        this.description = description;
        this.displayFolder = displayFolder;
        this.associatedMeasureGroup = associatedMeasureGroup;
        this.nonEmptyBehavior = nonEmptyBehavior;
        this.visible = visible;
        this.solveOrder = solveOrder;
        this.isCached = isCached;
        this.scopeIsolation = scopeIsolation;
        this.aggregationType = aggregationType;
        this.emptyIsZero = emptyIsZero;
        this.cellPropertyValues = cellPropertyValues;
        this.cellProperties = new HashMap<OlapCellProperty, OlapCellPropertyValue>();
        for (int idx = 0; idx < cellPropertyValues.size(); ++idx) {
            OlapCellPropertyValue cellPropertyValue = cellPropertyValues.get(idx);
            this.cellProperties.put(cellPropertyValue.getProperty(), cellPropertyValue);
        }
    }

    public List<OlapCellPropertyValue> getCellPropertyValues() {
        return this.cellPropertyValues;
    }

    @Nullable
    public OlapCellPropertyValue getCellPropertyValue(OlapCellProperty property) {
        return this.cellProperties.get(property);
    }

    public void addCellPropertyValue(OlapStringMdxCellPropertyValue cellPropertyValue) {
        this.cellProperties.put(cellPropertyValue.getProperty(), cellPropertyValue);
        this.cellPropertyValues.add(cellPropertyValue);
    }

    @Nullable
    public String getCaption(Locale locale) {
        if (this.caption == null) {
            return null;
        }
        return this.caption.get(locale);
    }

    @Nullable
    public String getDescription(Locale locale) {
        return this.description;
    }

    @Nullable
    public String getDisplayFolder() {
        return this.displayFolder;
    }

    @Nullable
    public String getAssociatedMeasureGroup() {
        return this.associatedMeasureGroup;
    }

    @Nullable
    public List<OlapEntityIdentifier> getNonEmptyBehavior() {
        return this.nonEmptyBehavior;
    }

    public int getVisible() {
        return this.visible;
    }

    public int getSolveOrder() {
        return this.solveOrder;
    }

    @Nullable
    public OlapScopeIsolation getScopeIsolation() {
        return this.scopeIsolation;
    }

    @Nullable
    public OlapAggregationType getAggregationType() {
        return this.aggregationType;
    }

    public boolean isEmptyIsZeroDefined() {
        return this.emptyIsZero != null;
    }

    public boolean isEmptyIsZero() {
        return this.emptyIsZero != null && this.emptyIsZero != false;
    }

    public void setEmptyIsZero(@Nullable Boolean emptyIsZero) {
        this.emptyIsZero = emptyIsZero;
    }

    public boolean isFormatStringDefined() {
        return this.cellProperties.get(OlapIntrinsicCellProperties.FORMAT_STRING) != null;
    }

    @Nullable
    public OlapCellPropertyValue getFormatString() {
        return this.cellProperties.get(OlapIntrinsicCellProperties.FORMAT_STRING);
    }

    public void setFormatString(OlapCellPropertyValue value) {
        this.cellProperties.put(OlapIntrinsicCellProperties.FORMAT_STRING, value);
        this.cellPropertyValues.add(value);
    }

    @Nullable
    public Boolean isCached() {
        return this.isCached;
    }

    public static class OlapLocalizedCaption {
        private static final Pattern pattern = Pattern.compile("(?:([^:]+):)?(.*)");
        final String debug;
        @Nullable
        private String defaultCaption;
        private Map<String, String> captions = new HashMap<String, String>();

        public OlapLocalizedCaption(@Nullable String definition) {
            this.debug = definition;
            if (definition == null) {
                return;
            }
            this.defaultCaption = "";
            String replacedDef = definition.replace("\\\\", "FPY%v!aiE");
            if (replacedDef.startsWith("\\")) {
                String[] split;
                for (String cap : split = replacedDef.split("\\\\")) {
                    Matcher match;
                    if (CdStringUtils.isNullOrBlank((String)cap) || !(match = pattern.matcher(cap)).matches() || match.groupCount() < 2) continue;
                    String locale = match.group(1);
                    String localizedCaption = match.group(2).replace("FPY%v!aiE", "\\");
                    if (CdStringUtils.isNullOrBlank((String)locale)) {
                        this.defaultCaption = localizedCaption;
                        continue;
                    }
                    this.captions.put(locale, localizedCaption);
                }
            } else {
                this.defaultCaption = definition;
            }
        }

        public String get(Locale locale) {
            if (this.captions.isEmpty()) {
                return this.defaultCaption;
            }
            String caption = this.captions.get(locale.toString());
            if (caption != null) {
                return caption;
            }
            caption = this.captions.get(locale.getLanguage());
            if (caption != null) {
                return caption;
            }
            return this.defaultCaption;
        }
    }
}

