/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.permissions;

import crazydev.iccube.authorizationx.permissions.schema.OlapRoleDefaultCalcMembers;
import crazydev.iccube.authorizationx.permissions.schema.OlapRoleDefaultMembers;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionsPermission;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.facts.OlapFactMeasureGroupSurrogate;
import crazydev.iccube.olap.schema.OlapSchema;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

public abstract class OlapBaseSchemaPermission
implements IOlapSchemaPermission {
    private final String uuid = UUID.randomUUID().toString();
    protected final OlapSchema schema;
    private final Map<OlapCube, OlapRoleDefaultCalcMembers> calcMembersDefaults = new ConcurrentHashMap<OlapCube, OlapRoleDefaultCalcMembers>();
    private final Map<OlapCube, OlapRoleDefaultMembers> cubeDefaults = new ConcurrentHashMap<OlapCube, OlapRoleDefaultMembers>();
    private final Map<OlapFactMeasureGroupSurrogate, OlapRoleDefaultMembers> measureGroupDefaults = new ConcurrentHashMap<OlapFactMeasureGroupSurrogate, OlapRoleDefaultMembers>();

    public OlapBaseSchemaPermission(OlapSchema schema) {
        this.schema = schema;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public OlapRoleDefaultCalcMembers getDefaultAsCalcMembers(OlapCube cube) {
        OlapRoleDefaultCalcMembers defaults = this.calcMembersDefaults.computeIfAbsent(cube, key -> this.createDefaultAsCalcMembers(cube));
        return defaults;
    }

    private OlapRoleDefaultCalcMembers createDefaultAsCalcMembers(OlapCube cube) {
        IOlapDimensionsPermission dimensionsPermissions = this.getDimensionsPermissions(cube);
        OlapRoleDefaultCalcMembers defaults = OlapRoleDefaultCalcMembers.createDefaultAsCalcMembers(dimensionsPermissions, cube);
        return defaults;
    }

    @Override
    public OlapRoleDefaultMembers getDefaults(OlapCube cube, @Nullable OlapFactMeasureGroupSurrogate measureGroup) {
        if (measureGroup != null) {
            OlapRoleDefaultMembers defaults = this.measureGroupDefaults.computeIfAbsent(measureGroup, key -> this.createDefaults(cube, measureGroup));
            return defaults;
        }
        OlapRoleDefaultMembers defaults = this.cubeDefaults.computeIfAbsent(cube, key -> this.createDefaults(cube, null));
        return defaults;
    }

    private OlapRoleDefaultMembers createDefaults(OlapCube cube, @Nullable OlapFactMeasureGroupSurrogate measureGroup) {
        IOlapDimensionsPermission permissions = this.getDimensionsPermissions(cube);
        List<OlapDimension> dimensions = measureGroup == null ? cube.getIndexingDimensions() : measureGroup.getIndexingDimensions();
        OlapRoleDefaultMembers defaults = OlapRoleDefaultMembers.createDefaults(permissions, dimensions);
        return defaults;
    }
}

