/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.memory.autoexist;

import crazydev.common.collection.CdAction;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.system.CdRamUsageEstimator;
import crazydev.iccube.builder.OlapBuilderBaseToNoBaseMapper;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapHollowableMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.memory.IOlapAutoExistBitmapProvider;
import crazydev.iccube.olap.entity.memory.autoexist.OlapAutoExistImmutableContainer;
import crazydev.iccube.olap.index.bitmap.OlapBitmap;
import crazydev.iccube.olap.index.bitmap.OlapEmptyBitmap;
import crazydev.iccube.olap.index.bitmap.OlapOneBitmap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.mutable.MutableLong;
import org.jetbrains.annotations.NotNull;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class OlapAutoExistGutsContainer {
    private static long SHALLOW_SIZE_OF = -1L;
    private final Map<OlapHierarchy, ContainerPerHierarchy> containers = new ConcurrentHashMap<OlapHierarchy, ContainerPerHierarchy>();

    public IOlapAutoExistBitmapProvider getContainer(OlapHierarchy hierarchy) {
        return this.containers.computeIfAbsent(hierarchy, h -> new ContainerPerHierarchy(hierarchy));
    }

    public void build(OlapBuilderContext context, OlapBuilderBaseToNoBaseMapper mapper, Map<OlapHollowableMember, OlapMember> hollowRemapping) {
        hollowRemapping.forEach((formerHollow, factMember) -> {
            OlapHierarchy hierarchy = formerHollow.getHierarchy();
            if (!hierarchy.isBase()) {
                ContainerPerHierarchy c = this.containers.get(hierarchy);
                c.cloneBitMap((OlapMember)formerHollow, (OlapMember)factMember);
            }
        });
        this.containers.forEach((hierarchy, container) -> container.buildAutoExists(mapper.get(container.hierarchy)));
        this.trimAfterLoad(context);
    }

    private void trimAfterLoad(OlapBuilderContext context) {
        this.containers.values().forEach(c -> c.trimAfterLoad(context));
    }

    public long sizeOf() {
        long size = SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
        for (ContainerPerHierarchy hierarchy : this.containers.values()) {
            size += hierarchy.sizeOf();
        }
        return size;
    }

    public long sizeOf(OlapHierarchy hierarchy) {
        ContainerPerHierarchy container = this.containers.get(hierarchy);
        return container == null ? 0L : container.sizeOf();
    }

    private static class ContainerPerHierarchy
    implements IOlapAutoExistBitmapProvider {
        private static final long SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)new ContainerPerHierarchy(null)) + CdRamUsageEstimator.shallowSizeOf(new HashMap());
        private final OlapHierarchy hierarchy;
        private final Int2ObjectOpenHashMap<MutableRoaringBitmap> mutable = new Int2ObjectOpenHashMap();
        private OlapAutoExistImmutableContainer immutableContainer;

        public ContainerPerHierarchy(OlapHierarchy hierarchy) {
            this.hierarchy = hierarchy;
        }

        public long sizeOf() {
            long size = SHALLOW_SIZE_OF;
            size += this.immutableContainer == null ? 0L : this.immutableContainer.sizeOf();
            return size += this.mutable.values().stream().mapToLong(MutableRoaringBitmap::sizeOf).sum();
        }

        private static int getMapIndex(OlapMember formerHollow) {
            return formerHollow.getUniqueHierarchyMemberIndex();
        }

        @Override
        @NotNull
        public OlapBitmap getAutoExistBitmap(OlapMember member) {
            int memberIdx = ContainerPerHierarchy.getMapIndex(member);
            OlapBitmap bitmap = (OlapBitmap)this.mutable.get(memberIdx);
            if (bitmap == null && this.immutableContainer != null) {
                bitmap = this.immutableContainer.getBitmap(memberIdx);
            }
            return bitmap == null ? (member.getHierarchy().isBase() ? OlapOneBitmap.INSTANCE : OlapEmptyBitmap.EMPTY) : bitmap;
        }

        @Override
        public MutableRoaringBitmap createBaseMemberBitmap(OlapMember member) {
            if (!member.getHierarchy().isBase() || member.isAllMember() || member.getLevel().isTerminal()) {
                throw new RuntimeException("Wrong member" + member.getUniqueNameX());
            }
            if (this.immutableContainer != null && this.immutableContainer.contains(ContainerPerHierarchy.getMapIndex(member))) {
                throw new RuntimeException("Existing member" + member.getUniqueNameX());
            }
            MutableRoaringBitmap bitmap = MutableRoaringBitmap.bitmapOfOne(ContainerPerHierarchy.getMapIndex(member));
            this.mutable.put(ContainerPerHierarchy.getMapIndex(member), (Object)bitmap);
            return bitmap;
        }

        @Override
        public void addAutoExistRelation(OlapMember member, OlapMember child) {
            ImmutableRoaringBitmap immutable;
            int memberIdx = ContainerPerHierarchy.getMapIndex(member);
            MutableRoaringBitmap bitmap = (MutableRoaringBitmap)this.mutable.get(memberIdx);
            if (bitmap == null && this.immutableContainer != null && (immutable = this.immutableContainer.getBitmap(memberIdx)) != null) {
                bitmap = immutable.toMutableRoaringBitmap();
                this.mutable.put(memberIdx, (Object)bitmap);
            }
            if (bitmap == null) {
                bitmap = this.createBaseMemberBitmap(member);
            }
            bitmap.add(ContainerPerHierarchy.getMapIndex(child));
        }

        @Override
        public long getBitmapSize(OlapLevel level) {
            MutableLong count = new MutableLong();
            IntOpenHashSet set = new IntOpenHashSet();
            level.getDataHandler().forEachMember((CdAction<OlapMember>)((CdAction)m -> set.add(ContainerPerHierarchy.getMapIndex(m))));
            this.mutable.forEach((memberIdx, bitmap) -> {
                if (set.contains(memberIdx.intValue())) {
                    count.add((long)bitmap.serializedSizeInBytes());
                }
            });
            if (this.immutableContainer != null) {
                this.immutableContainer.forEachExistingMemberIdx(memberIdx -> {
                    if (set.contains(memberIdx)) {
                        count.add(this.immutableContainer.sizeOf(memberIdx));
                    }
                    return true;
                });
            }
            return count.longValue();
        }

        public void buildAutoExists(OlapBuilderBaseToNoBaseMapper.HierarchyMapper mapper) {
            if (mapper == null) {
                return;
            }
            mapper.forEach(this::buildBitmapsFor);
            this.mutable.values().forEach(MutableRoaringBitmap::trim);
        }

        public void trimAfterLoad(OlapBuilderContext context) {
            if (this.mutable.isEmpty()) {
                return;
            }
            this.immutableContainer = this.immutableContainer != null ? this.rebuild() : new OlapAutoExistImmutableContainer((Set<Integer>)this.mutable.keySet(), arg_0 -> this.mutable.get(arg_0));
            this.mutable.clear();
            if (!context.isIncrLoadActive()) {
                this.immutableContainer.trimAndFreeze();
            } else {
                this.immutableContainer.trim();
            }
        }

        private OlapAutoExistImmutableContainer rebuild() {
            HashSet<Integer> all = new HashSet<Integer>();
            this.immutableContainer.forEachExistingMemberIdx(all::add);
            all.addAll((Collection<Integer>)this.mutable.keySet());
            OlapAutoExistImmutableContainer newImmutable = new OlapAutoExistImmutableContainer(all, memberIdx -> {
                MutableRoaringBitmap roaringBitmap = (MutableRoaringBitmap)this.mutable.get(memberIdx);
                if (roaringBitmap != null) {
                    return roaringBitmap;
                }
                return this.immutableContainer.getBitmap(memberIdx);
            });
            return newImmutable;
        }

        private void buildBitmapsFor(OlapMember baseMember, OlapMember noBaseMember) {
            if (baseMember.getHierarchy().isParentChild() || baseMember.getLevel().isTerminal()) {
                noBaseMember.forEachAndAncestor((CdAction<OlapMember>)((CdAction)olapMember -> {
                    if (!olapMember.isAll() && !olapMember.isFactHollow()) {
                        MutableRoaringBitmap bitmap = (MutableRoaringBitmap)this.mutable.computeIfAbsent(ContainerPerHierarchy.getMapIndex(olapMember), t -> OlapBitmap.createBitmap());
                        bitmap.setBit(ContainerPerHierarchy.getMapIndex(baseMember));
                    }
                }));
            } else {
                OlapBitmap baseMemberBitmap = baseMember.getBaseMemberBitmap();
                noBaseMember.forEachAndAncestor((CdAction<OlapMember>)((CdAction)olapMember -> {
                    if (!olapMember.isAll() && !olapMember.isFactHollow()) {
                        MutableRoaringBitmap bitmap = (MutableRoaringBitmap)this.mutable.computeIfAbsent(ContainerPerHierarchy.getMapIndex(olapMember), t -> OlapBitmap.createBitmap());
                        bitmap.or((ImmutableRoaringBitmap)baseMemberBitmap);
                    }
                }));
            }
        }

        private void cloneBitMap(OlapMember formerHollow, OlapMember factMember) {
            OlapBitmap bitmap = factMember.getBaseMemberBitmap();
            if (!(bitmap instanceof MutableRoaringBitmap)) {
                Object error = "";
                try {
                    error = (bitmap != null ? bitmap.getClass().getName() : "<null>") + " : ";
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw new CdShouldNotBeHereProgrammingException((String)error + factMember.getUniqueNameX());
            }
            MutableRoaringBitmap roaringBitmap = (MutableRoaringBitmap)bitmap;
            this.mutable.put(ContainerPerHierarchy.getMapIndex(formerHollow), (Object)roaringBitmap.clone());
        }
    }
}

