/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.memory;

import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.memory.IOlapMemoryLevelMember;
import crazydev.iccube.olap.entity.memory.OlapLevelMemoryFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class OlapMemoryHierarchyLevelMembers {
    private final Map<OlapLevel, IOlapMemoryLevelMember> data = new HashMap<OlapLevel, IOlapMemoryLevelMember>();

    public IOlapMemoryLevelMember getOrCreateDataHandler(OlapLevel level) {
        IOlapMemoryLevelMember dataLevel = this.data.get(level);
        if (dataLevel == null) {
            dataLevel = OlapLevelMemoryFactory.createOlapMemoryLevelMember(level);
            this.data.put(level, dataLevel);
        }
        return dataLevel;
    }

    public void onFinishBuild(boolean incrLoad, boolean incrLoadActive) {
        for (IOlapMemoryLevelMember levelMemory : this.data.values()) {
            levelMemory.onFinishBuild(incrLoad, incrLoadActive);
        }
    }

    public void removeAllExcept(OlapLevel level) {
        ArrayList<OlapLevel> levels = new ArrayList<OlapLevel>(this.data.keySet());
        for (OlapLevel olapLevel : levels) {
            if (olapLevel == level) continue;
            this.data.remove(olapLevel);
        }
    }
}

