/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.memory;

import crazydev.common.collection.CdComparableArray;
import crazydev.common.collection.CdHolder;
import crazydev.common.collection.CdObject2IntHollowMap;
import crazydev.common.collection.CdPaginatedIntList;
import crazydev.common.collection.CdVisitor;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.enums.OlapMemberOrderByType;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapMemberKey;
import crazydev.iccube.olap.entity.memory.IOlapStringColumnForLevel;
import crazydev.iccube.olap.entity.memory.OlapBaseMemoryLevelMember;
import crazydev.iccube.olap.entity.memory.OlapMemoryKeyColumn;
import crazydev.iccube.olap.entity.properties.OlapMemberPropertiesValues;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.facts.column.columns.OlapFactMemberNameColumnId;
import crazydev.iccube.olap.facts.column.columns.OlapModifiedUtf8StringScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.IOlapFactListFactory;
import crazydev.iccube.olap.schema.stats.OlapLevelStats;
import crazydev.iccube.olap.util.OlapCaseInsensitiveName;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

class NewOlapMemoryLevelMember
extends OlapBaseMemoryLevelMember {
    private static final int DEFAULT_MISSING_VALUE = -1;
    private static final boolean CHECK = false;
    private final boolean nameUpperCaseUnique;
    protected IOlapStringColumnForLevel<String> nameColumn;
    protected OlapMemoryKeyColumn keyColumn;
    private CdPaginatedIntList nameSorted;
    private CdPaginatedIntList keySorted;
    private MapForUpperCaseString nameMap;
    private MapForKey keyMap;
    private int numberOfCollidingUpperCaseNames;
    private int numberOfCollidingKeys;
    private boolean sameKeyAndStringColumn;
    private int lookupKeyCost;
    private int lookupNameCost;

    protected NewOlapMemoryLevelMember(OlapLevel level) {
        super(level);
        this.nameUpperCaseUnique = level.isNamesUniqueFlag();
    }

    @Override
    protected void doInit() {
        IOlapFactListFactory listFactory = this.dimension.getListFactory();
        this.nameColumn = new OlapModifiedUtf8StringScalarEntityFactColumn(listFactory, new OlapFactMemberNameColumnId(this.level), OlapBuilderInputType.STRING);
        this.nameSorted = new CdPaginatedIntList();
        this.keyColumn = new OlapMemoryKeyColumn(listFactory, this.level);
        this.keySorted = new CdPaginatedIntList();
        if (!this.level.getDefinedKeyTypes().isEmpty()) {
            this.keyColumn.init(this.level.getDefinedKeyTypes().toArray(new OlapBuilderInputType[0]));
        }
        this.nameMap = new MapForUpperCaseString(this);
        this.keyMap = new MapForKey(this);
    }

    @Override
    public void onProcessingDataCompleted(OlapBuilderContext context) {
        super.onProcessingDataCompleted(context);
        this.unmountKeymap();
        this.unmountNameMap();
    }

    @Override
    public int addIndex(OlapMember member, String name, @Nullable OlapMemberKey key, @Nullable OlapMemberPropertiesValues memberProperties, int uniqueHierarchyMemberIndex, @Nullable OlapMember parent) {
        int idx;
        if (name == null && key == null && memberProperties == null) {
            return -1;
        }
        int index = super.addIndex(member, name, key, memberProperties, uniqueHierarchyMemberIndex, parent);
        this.nameColumn.addNewValue(key, name);
        if (this.sameKeyAndStringColumn || key == null) {
            this.sameKeyAndStringColumn = true;
        } else {
            this.keyColumn.addValue(key);
        }
        if (this.nameMap != null) {
            this.numberOfCollidingUpperCaseNames += this.nameMap.put(name, index) == -1 ? 0 : 1;
            if (this.numberOfCollidingUpperCaseNames > 0) {
                this.unmountNameMap();
            }
        } else {
            idx = this.nameColumn.binarySearchIgnoreCase(this.nameSorted, name);
            if (idx < 0) {
                this.nameSorted.insert(-idx - 1, index);
            } else {
                this.nameSorted.insert(idx, index);
                ++this.numberOfCollidingUpperCaseNames;
            }
        }
        if (!this.sameKeyAndStringColumn && key != null && key.isValueKey()) {
            if (this.keyMap != null) {
                this.numberOfCollidingKeys += this.keyMap.put(key.getValue(), index) == -1 ? 0 : 1;
                if (this.numberOfCollidingKeys > 0) {
                    this.unmountKeymap();
                }
            } else {
                idx = this.keyColumn.binarySearchByKeyValues(null, this.keySorted, key.asJavaNativeValue());
                if (idx < 0) {
                    this.keySorted.insert(-idx - 1, index);
                } else {
                    this.keySorted.insert(idx, index);
                    ++this.numberOfCollidingKeys;
                }
            }
        }
        return index;
    }

    private void unmountNameMap() {
        if (this.nameColumn != null && this.nameMap != null) {
            Integer[] positions = new Integer[this.nameColumn.size()];
            for (int i = 0; i < positions.length; ++i) {
                positions[i] = i;
            }
            Arrays.parallelSort(positions, (row1, row2) -> {
                String row1String = this.nameColumn.getValueAsObject((int)row1);
                String row2String = this.nameColumn.getValueAsObject((int)row2);
                return row1String.compareToIgnoreCase(row2String);
            });
            this.nameSorted = new CdPaginatedIntList(positions);
        }
        this.nameMap = null;
    }

    private void unmountKeymap() {
        if (this.sameKeyAndStringColumn) {
            return;
        }
        if (this.keyColumn != null && this.keyMap != null) {
            Integer[] positions = this.keyColumn.sort(true);
            this.keySorted = new CdPaginatedIntList(positions);
        }
        this.keyMap = null;
    }

    private void checkKeyMap(Integer[] positions) {
        CdPaginatedIntList keySorted = new CdPaginatedIntList();
        IOlapFactListFactory listFactory = this.dimension.getListFactory();
        OlapMemoryKeyColumn newKeyColumn = new OlapMemoryKeyColumn(listFactory, this.level);
        for (int i = 0; i < this.keyColumn.size(); ++i) {
            OlapMemberKey key = this.keyColumn.getValue(i);
            newKeyColumn.addValue(key);
            int idx = newKeyColumn.binarySearchByKeyValues(null, keySorted, key.asJavaNativeValue());
            if (idx < 0) {
                keySorted.insert(-idx - 1, i);
                continue;
            }
            keySorted.insert(idx, i);
        }
        for (int i = 0; i < this.keyColumn.size(); ++i) {
            Integer pos;
            int colPos = keySorted.getInt(i);
            if (colPos == (pos = positions[i])) continue;
            Object keyValue1 = this.keyColumn.getKeyValue(colPos);
            Object keyValue2 = this.keyColumn.getKeyValue(pos);
            if (!(keyValue1 instanceof Comparable[] ? !Arrays.equals((Comparable[])keyValue1, (Comparable[])keyValue2) : !keyValue1.equals(keyValue2))) continue;
            throw new CdShouldNotBeHereProgrammingException();
        }
    }

    private void checkStrings(Integer[] positions) {
        CdPaginatedIntList nameSorted = new CdPaginatedIntList();
        IOlapFactListFactory listFactory = this.dimension.getListFactory();
        OlapModifiedUtf8StringScalarEntityFactColumn newNameColumn = new OlapModifiedUtf8StringScalarEntityFactColumn(listFactory, new OlapFactMemberNameColumnId(this.level), OlapBuilderInputType.STRING);
        for (int i = 0; i < this.nameColumn.size(); ++i) {
            String name = this.nameColumn.getValueAsObject(i);
            newNameColumn.addNewValue(name);
            int idx = newNameColumn.binarySearchIgnoreCase(nameSorted, name);
            if (idx < 0) {
                nameSorted.insert(-idx - 1, i);
                continue;
            }
            nameSorted.insert(idx, i);
        }
        for (int i = 0; i < this.keyColumn.size(); ++i) {
            Integer pos;
            int colPos = nameSorted.getInt(i);
            if (colPos == (pos = positions[i]) || this.nameColumn.getValueAsObject(colPos).equalsIgnoreCase(this.nameColumn.getValueAsObject(pos))) continue;
            throw new CdShouldNotBeHereProgrammingException();
        }
    }

    @Override
    public String getName(int dataHandlerIdx) {
        return this.nameColumn.getValueAsObject(dataHandlerIdx);
    }

    @Override
    public OlapMemberKey getKey(int dataHandlerIdx) {
        return this.keyColumn.getValue(dataHandlerIdx);
    }

    @Override
    public int naturalCompareWithKeyForCompare(int dataHandlerIdx, Object keyForCompare) {
        return this.keyColumn.naturalCompareWithKeyForCompare(dataHandlerIdx, keyForCompare);
    }

    @Override
    public boolean nameEqualsIgnoreCase(int dataHandlerIdx, String name) {
        return this.nameColumn.equalsIgnoreCase(dataHandlerIdx, name);
    }

    @Override
    @Nullable
    public Object getKeyValueForCompare(Object keyValue) {
        return this.keyColumn == null ? null : this.keyColumn.transformKeyValueForCompare(keyValue);
    }

    public OlapBuilderInputType getKeyType(int dataHandlerIdx) {
        return this.keyColumn.getKeyType(dataHandlerIdx);
    }

    @Override
    public Comparable getSingleKeyValue(int dataHandlerIdx) {
        return this.keyColumn.getKeySingleValue(dataHandlerIdx);
    }

    @Override
    @Nullable
    public OlapBuilderInputType[] getKeyType() {
        return this.keyColumn == null ? null : this.keyColumn.getTypes();
    }

    @Override
    @Nullable
    public OlapMember lookupMemberByNameIgnoreCase(String name) {
        if (this.nameMap != null) {
            return this.nameMap.getMember(name);
        }
        int pos = this.nameColumn == null ? -1 : this.nameColumn.binarySearchIgnoreCase(this.nameSorted, name);
        return pos < 0 ? null : this.getMember(this.nameSorted.getInt(pos));
    }

    @Override
    public void forEachMatchingNameIgnoreCase(String name, CdVisitor<OlapMember> visitor) {
        if (this.nameMap != null) {
            int idx = this.nameMap.get(name);
            if (idx == -1) {
                return;
            }
            visitor.visit((Object)this.getMember(idx));
            return;
        }
        if (this.nameColumn == null || this.nameColumn.size() == 0) {
            return;
        }
        int pos = this.nameColumn.binarySearchIgnoreCase(this.nameSorted, name);
        if (pos >= 0 && visitor.visit((Object)this.getMember(this.nameSorted.getInt(pos)))) {
            int keyIdx;
            int keyIdx2;
            int down = pos;
            while (--down >= 0 && OlapCaseInsensitiveName.equals(name, this.nameColumn.getValueAsObject(keyIdx2 = this.nameSorted.getInt(down)))) {
                OlapMember olapMember = this.getMember(keyIdx2);
                if (visitor.visit((Object)olapMember)) continue;
                return;
            }
            int up = pos;
            while (++up <= this.nameSorted.size() - 1 && OlapCaseInsensitiveName.equals(name, this.nameColumn.getValueAsObject(keyIdx = this.nameSorted.getInt(up)))) {
                OlapMember olapMember = this.getMember(keyIdx);
                if (visitor.visit((Object)olapMember)) continue;
                return;
            }
        }
    }

    @Override
    @Nullable
    public OlapMember lookupMemberByKeyValue(Object memberKeyArray) {
        if (this.keyMap != null) {
            return this.keyMap.getMember(this.toComparableKey(memberKeyArray));
        }
        if (this.keyColumn == null || this.keyColumn.size() == 0) {
            return null;
        }
        int pos = this.keyColumn.binarySearchByKeyValues(null, this.keySorted, memberKeyArray);
        if (pos < 0) {
            return null;
        }
        int keySortedIndex = this.keySorted.getInt(pos);
        return this.getMember(keySortedIndex);
    }

    @Override
    @Nullable
    public OlapMember lookupMemberByKeyValue(Comparable memberKeyCdArray) {
        if (this.keyMap != null) {
            return this.keyMap.getMember(memberKeyCdArray);
        }
        if (this.keyColumn == null || this.keyColumn.size() == 0) {
            return null;
        }
        Object memberOldKey = this.toObjectKey(memberKeyCdArray);
        int pos = this.keyColumn.binarySearchByKeyValues(null, this.keySorted, memberOldKey);
        if (pos < 0) {
            return null;
        }
        int keySortedIndex = this.keySorted.getInt(pos);
        return this.getMember(keySortedIndex);
    }

    @Override
    @Nullable
    public OlapMember lookupMemberByKey4Check(OlapMember parentMember, Comparable memberKeyCdArray, String hintMemberName) {
        if (this.keyMap != null) {
            return this.keyMap.getMember(memberKeyCdArray);
        }
        if (this.nameMap != null) {
            OlapMember f = this.nameMap.getMember(hintMemberName);
            if (f != null && OlapMember.equal(parentMember, f.getParent()) && this.sameKey(f, memberKeyCdArray)) {
                return f;
            }
            if (this.nameUpperCaseUnique) {
                return null;
            }
        }
        if (parentMember == null) {
            return this.lookupMemberByKeyValue(memberKeyCdArray);
        }
        int childrenCount = parentMember.getChildrenCount();
        if (childrenCount == 0) {
            return null;
        }
        boolean binarySearchOnParent = parentMember.getLevel().getNextLevel() == this.level && this.level.getOrderBy() == OlapMemberOrderByType.BY_KEY;
        Object keyValue = this.toObjectKey(memberKeyCdArray);
        if (!binarySearchOnParent && childrenCount > 16 && childrenCount > this.getBinarySearchCost() + this.lookupKeyCost) {
            MutableInt countEquals = new MutableInt();
            CdHolder holder = new CdHolder();
            CdHolder matchingKey = new CdHolder();
            this.forEachMatchingKeyValue(null, keyValue, (CdVisitor<OlapMember>)((CdVisitor)olapMember -> {
                countEquals.increment();
                if (OlapMember.equal(olapMember.getParent(), parentMember)) {
                    holder.item = olapMember;
                    return false;
                }
                matchingKey.item = olapMember;
                return true;
            }));
            this.lookupKeyCost = Math.max(this.lookupKeyCost, countEquals.intValue());
            return holder.item == null ? (OlapMember)matchingKey.item : (OlapMember)holder.item;
        }
        return parentMember.lookupChildByKeyValue(this.level, keyValue);
    }

    @Override
    protected OlapMember lookupChildByNameIgnoreCase4Check(OlapMember parent, String lookupChildName) {
        if (this.nameMap != null) {
            OlapMember f = this.nameMap.getMember(lookupChildName);
            return f == null || !OlapMember.equal(f.getParent(), parent) ? null : f;
        }
        int childrenCount = parent.getChildrenCount();
        if (childrenCount == 0) {
            return null;
        }
        if (childrenCount > 16 && childrenCount > this.getBinarySearchCost() + this.lookupKeyCost) {
            MutableInt countEquals = new MutableInt();
            CdHolder holder = new CdHolder();
            this.forEachMatchingNameIgnoreCase(lookupChildName, (CdVisitor<OlapMember>)((CdVisitor)olapMember -> {
                countEquals.increment();
                if (OlapMember.equal(olapMember.getParent(), parent)) {
                    holder.item = olapMember;
                    return false;
                }
                return true;
            }));
            this.lookupNameCost = Math.max(this.lookupNameCost, countEquals.intValue());
            return (OlapMember)holder.item;
        }
        return parent.lookupChildByNameIgnoreCase(lookupChildName);
    }

    @Override
    public void forEachMatchingKeyValue(@Nullable IOlapEvaluationExceptionContext context, Object memberKeyValue, CdVisitor<OlapMember> visitor) {
        if (this.keyMap != null) {
            OlapMember member;
            int idx = this.keyMap.getInt(this.toComparableKey(memberKeyValue));
            OlapMember olapMember = member = idx == -1 ? null : this.getMember(idx);
            if (member != null) {
                visitor.visit((Object)member);
            }
            return;
        }
        if (this.keyColumn == null || this.keyColumn.size() == 0) {
            return;
        }
        int pos = this.keyColumn.binarySearchByKeyValues(context, this.keySorted, memberKeyValue);
        if (pos >= 0 && visitor.visit((Object)this.getMember(this.keySorted.getInt(pos)))) {
            int idx;
            Object lookupKeyValue;
            int idx2;
            Object lookupKeyValue2;
            int down = pos;
            while (--down >= 0 && memberKeyValue.equals(lookupKeyValue2 = this.keyColumn.getKeyValue(idx2 = this.keySorted.getInt(down)))) {
                OlapMember olapMember = this.getMember(idx2);
                if (visitor.visit((Object)olapMember)) continue;
                return;
            }
            int up = pos;
            while (++up <= this.keySorted.size() - 1 && memberKeyValue.equals(lookupKeyValue = this.keyColumn.getKeyValue(idx = this.keySorted.getInt(up)))) {
                OlapMember olapMember = this.getMember(idx);
                if (visitor.visit((Object)olapMember)) continue;
                return;
            }
        }
    }

    @Override
    public boolean isKeyType(Class<?> clazz) {
        return this.keyColumn.isType(clazz);
    }

    protected Comparable toComparableKey(Object memberKeyValue) {
        return memberKeyValue.getClass().isArray() ? new CdComparableArray((Comparable[])memberKeyValue) : (Comparable)memberKeyValue;
    }

    @Override
    protected void doTrim() {
        if (this.nameColumn != null) {
            this.nameColumn.trimToSize();
        }
        if (this.keyColumn != null) {
            this.keyColumn.trimToSize();
        }
        if (this.keySorted != null) {
            this.keySorted.trimToSize();
        }
        if (this.nameSorted != null) {
            this.nameSorted.trimToSize();
        }
    }

    public int getBinarySearchCost() {
        int size = this.getMemberCount();
        return size == 0 ? 0 : 31 - Integer.numberOfLeadingZeros(size);
    }

    @Override
    public OlapLevelStats createStats() {
        OlapLevelStats stats = super.createStats();
        long nameSize = this.nameColumn != null ? this.nameColumn.sizeOf() : 0L;
        long nameSortedSize = (this.nameSorted != null ? this.nameSorted.sizeOf() : 0L) + (this.nameMap != null ? this.nameMap.sizeOf() : 0L);
        long keySize = this.keyColumn != null ? this.keyColumn.sizeOf() : 0L;
        long keySortedSize = (this.keySorted != null ? this.keySorted.sizeOf() : 0L) + (this.keyMap != null ? this.keyMap.sizeOf() : 0L);
        return stats.setNameAnKeySize(nameSize, nameSortedSize, keySize, keySortedSize);
    }

    @Override
    public OlapLevelStats createIncrLoadStats() {
        return new OlapLevelStats(this.level.getName(OlapNameContext.DEFAULT_VALUES), this.level.getMemberCount(), 0L, 0L, 0L, 0L, 0L, 0L, this.level.isHollow());
    }

    public String toString() {
        return this.level.getNameX();
    }

    public class MapForUpperCaseString
    extends CdObject2IntHollowMap<String> {
        final /* synthetic */ NewOlapMemoryLevelMember this$0;

        MapForUpperCaseString(NewOlapMemoryLevelMember this$0) {
            NewOlapMemoryLevelMember newOlapMemoryLevelMember = this$0;
            Objects.requireNonNull(newOlapMemoryLevelMember);
            this.this$0 = newOlapMemoryLevelMember;
        }

        public int get(String k) {
            return super.get((Object)k.toUpperCase());
        }

        public int put(String k, int v) {
            return super.put((Object)k.toUpperCase(), v);
        }

        @Nullable
        private OlapMember getMember(String key) {
            if (this.size == 0) {
                return null;
            }
            int formerIdx = this.get(key);
            if (formerIdx == -1) {
                return null;
            }
            return this.this$0.getMember(formerIdx);
        }

        protected int hashOnKey(int key) {
            String valueAsObject = this.this$0.nameColumn.getValueAsObject(key);
            return this.secondHash(valueAsObject.toUpperCase().hashCode());
        }

        protected int hashOnKey(String key) {
            return this.secondHash(key.hashCode());
        }

        protected boolean equals(String first, int secondIdx) {
            return this.this$0.nameColumn.equalsIgnoreCase(secondIdx, first);
        }

        public int getInt(String memberKeyValue) {
            return this.get(memberKeyValue);
        }
    }

    class MapForKey
    extends CdObject2IntHollowMap<Object> {
        final /* synthetic */ NewOlapMemoryLevelMember this$0;

        MapForKey(NewOlapMemoryLevelMember this$0) {
            NewOlapMemoryLevelMember newOlapMemoryLevelMember = this$0;
            Objects.requireNonNull(newOlapMemoryLevelMember);
            this.this$0 = newOlapMemoryLevelMember;
        }

        public int put(Object k, int v) {
            return super.put(k, v);
        }

        @Nullable
        public OlapMember getMember(Object key) {
            if (this.size == 0) {
                return null;
            }
            int formerIdx = this.get(key);
            if (formerIdx == -1) {
                return null;
            }
            return this.this$0.getMember(formerIdx);
        }

        protected int hashOnKey(int key) {
            return this.hashOnKey(this.this$0.keyColumn.getComparableKey(key));
        }

        protected int hashOnKey(Object key) {
            return this.secondHash(key.hashCode());
        }

        protected boolean equals(Object first, int secondIdx) {
            return first.equals(this.this$0.keyColumn.getComparableKey(secondIdx));
        }

        public int getInt(Object memberKeyValue) {
            return this.get(memberKeyValue);
        }
    }
}

