/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.memory;

import crazydev.common.collection.CdAction;
import crazydev.common.collection.CdArrays;
import crazydev.common.system.CdRamUsageEstimator;
import crazydev.iccube.common.CdCompressedIntIntMap;
import crazydev.iccube.common.CdIntIntMapReader;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class FactIndexingMembersHolder {
    private static long SHALLOW_SIZE_OF = -1L;
    private final OlapLevel[] levels;
    private final CdIntIntMapReader[] mapReaders;
    @Nullable
    private ArrayList<OlapMember> members;
    private IntArrayList removedMembers = new IntArrayList();

    public FactIndexingMembersHolder(OlapLevel[] levels) {
        this(levels, new CdIntIntMapReader[levels.length]);
    }

    public FactIndexingMembersHolder(OlapLevel[] aLevel, CdIntIntMapReader[] aMapReaders) {
        this.levels = aLevel;
        this.mapReaders = aMapReaders;
    }

    public long sizeOf(boolean b) {
        long size = SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
        for (CdIntIntMapReader mapReader : this.mapReaders) {
            size += mapReader.sizeOf();
        }
        return size;
    }

    public static FactIndexingMembersHolder build(CdAction<CdAction<OlapMember>> forEachMember) {
        HashMap fIndexing = new HashMap();
        forEachMember.apply(member -> {
            OlapMember fMember = member.getDefinedFactIndexingMember();
            if (fMember != null) {
                CdCompressedIntIntMap.MapIntInt m = fIndexing.computeIfAbsent(fMember.getLevel(), l -> new CdCompressedIntIntMap.MapIntInt());
                FactIndexingMembersHolder.putInMap(m, member, fMember);
            }
        });
        OlapLevel[] fIndexingLevels = fIndexing.keySet().toArray(new OlapLevel[0]);
        FactIndexingMembersHolder fmembers = new FactIndexingMembersHolder(fIndexingLevels);
        for (int i = 0; i < fIndexingLevels.length; ++i) {
            OlapLevel level = fIndexingLevels[i];
            CdCompressedIntIntMap.MapIntInt mapping = (CdCompressedIntIntMap.MapIntInt)fIndexing.get(level);
            fmembers.addMap(i, CdCompressedIntIntMap.compress(mapping));
        }
        return fmembers;
    }

    private static void putInMap(CdCompressedIntIntMap.MapIntInt m, OlapMember member, OlapMember fMember) {
        m.put(member.getDataHandlerIdx(), fMember.getDataHandlerIdx() + 1);
    }

    private void addMap(int i, CdIntIntMapReader compress) {
        this.mapReaders[i] = compress;
    }

    @Nullable
    public OlapMember getFactMember(int dataHandlerIdx) {
        for (int i = 0; i < this.levels.length; ++i) {
            CdIntIntMapReader map = this.mapReaders[i];
            int fDataHandlerIndex = map.getValue(dataHandlerIdx);
            if (fDataHandlerIndex == 0) continue;
            return this.levels[i].getDataHandler().getMember(fDataHandlerIndex - 1);
        }
        return null;
    }

    public void addIncrementalLoadMember(OlapMember member) {
        if (this.members == null) {
            this.members = new ArrayList();
        }
        this.members.add(member);
    }

    public void removeFactIndexingMember(int dataHandlerIdx) {
        this.removedMembers.add(dataHandlerIdx);
    }

    public FactIndexingMembersHolder onNewMembers() {
        if (this.members == null && this.removedMembers.isEmpty()) {
            return this;
        }
        List<OlapMember> membersWithFact = this.members == null ? Collections.emptyList() : this.members.stream().filter(m -> m.getDefinedFactIndexingMember() != null).toList();
        this.members = null;
        if (membersWithFact.isEmpty() && this.removedMembers.isEmpty()) {
            return this;
        }
        List<OlapLevel> memberFactLevels = membersWithFact.stream().map(me -> me.getFactIndexingMember().getLevel()).toList();
        List<OlapLevel> newFactLevels = memberFactLevels.stream().filter(l -> !CdArrays.contains((Object)l, (Object[])this.levels)).toList();
        FactIndexingMembersHolder fim = this;
        if (!newFactLevels.isEmpty()) {
            fim = this.onNewLevels(newFactLevels);
        }
        for (int i = 0; i < fim.mapReaders.length; ++i) {
            CdIntIntMapReader reader = fim.mapReaders[i];
            if (!(reader instanceof CdCompressedIntIntMap.BitList)) continue;
            CdCompressedIntIntMap.BitList bitList = (CdCompressedIntIntMap.BitList)reader;
            CdCompressedIntIntMap.MapIntInt map = new CdCompressedIntIntMap.MapIntInt();
            bitList.forEachNotZeroKeyValue((arg_0, arg_1) -> ((CdCompressedIntIntMap.MapIntInt)map).put(arg_0, arg_1));
            fim.mapReaders[i] = map;
        }
        FactIndexingMembersHolder casseCouille = fim;
        this.removedMembers.forEach(dataHandlerIdx -> {
            for (int i = 0; i < casseCouille.mapReaders.length; ++i) {
                CdCompressedIntIntMap.MapIntInt mapReader = (CdCompressedIntIntMap.MapIntInt)casseCouille.mapReaders[i];
                mapReader.remove(dataHandlerIdx);
            }
        });
        this.removedMembers = new IntArrayList();
        membersWithFact.forEach(member -> {
            OlapMember fMember = member.getDefinedFactIndexingMember();
            int index = CdArrays.indexOf((Object[])casseCouille.levels, (Object)fMember.getLevel());
            FactIndexingMembersHolder.putInMap((CdCompressedIntIntMap.MapIntInt)casseCouille.mapReaders[index], member, fMember);
        });
        for (int i = 0; i < fim.mapReaders.length; ++i) {
            fim.mapReaders[i] = CdCompressedIntIntMap.compress((CdCompressedIntIntMap.MapIntInt)fim.mapReaders[i]);
        }
        return fim;
    }

    private FactIndexingMembersHolder onNewLevels(List<OlapLevel> newFactLevels) {
        OlapLevel[] aLevel = new OlapLevel[this.levels.length + newFactLevels.size()];
        CdIntIntMapReader[] aReaders = new CdIntIntMapReader[aLevel.length];
        System.arraycopy(this.levels, 0, aLevel, 0, this.levels.length);
        System.arraycopy(this.mapReaders, 0, aReaders, 0, this.levels.length);
        int i = this.levels.length;
        int j = 0;
        while (i < aLevel.length) {
            aLevel[i] = newFactLevels.get(j);
            aReaders[i] = new CdCompressedIntIntMap.MapIntInt();
            ++i;
            ++j;
        }
        FactIndexingMembersHolder fim = new FactIndexingMembersHolder(aLevel, aReaders);
        return fim;
    }
}

