/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.member;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.system.CdRamUsageEstimator;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.cluster.shared.schema.S_MeasureDef;
import crazydev.iccube.cluster.shared.schema.S_MeasureIndex;
import crazydev.iccube.cluster.shared.schema.S_MeasureRef;
import crazydev.iccube.cluster.shared.schema.S_UserMeasureDef;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.olap.component.naming.ONames;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapMemberRank;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperties;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapUserMeasureMember
extends OlapMeasureMember {
    private static long SHALLOW_SIZE_OF = -1L;
    private final boolean definedAtSelectLevel;
    private final List<OlapMeasureMember> refMeasures;
    private S_MeasureDef def;
    private int positionInAnchor = -1;

    public OlapUserMeasureMember(OlapLevel level, IOlapBuilderBaseFactsDef measureGroup, String name, OlapAggregationType hierarchyAggregationType, @Nullable OlapHierarchy rollupHierarchy, boolean emptyIsZero, OlapBuilderInputType cubeDataType, OlapCellProperties cellProperties, boolean definedAtSelectLevel, List<OlapMeasureMember> refMeasures) {
        super(level, S_MeasureIndex.NOT_USED, name, measureGroup, cubeDataType, hierarchyAggregationType, emptyIsZero, (level_, index_, name_, measureGroup_, cubeDataType_, hierarchyAggregationType_, emptyIsZero_) -> new OlapUserMeasureMember(level_, index_, name_, measureGroup_, cubeDataType_, hierarchyAggregationType_, emptyIsZero_, definedAtSelectLevel, refMeasures));
        this.setRollupHierarchy(rollupHierarchy);
        this.setCellProperties(cellProperties);
        this.definedAtSelectLevel = definedAtSelectLevel;
        this.refMeasures = refMeasures;
    }

    protected OlapUserMeasureMember(OlapLevel level, S_MeasureIndex index, String name, IOlapBuilderBaseFactsDef measureGroup, OlapBuilderInputType cubeDataType, OlapAggregationType hierarchyAggregationType, boolean emptyIsZero, boolean definedAtSelectLevel, List<OlapMeasureMember> refMeasures) {
        super(level, index, name, measureGroup, cubeDataType, hierarchyAggregationType, emptyIsZero, null);
        this.definedAtSelectLevel = definedAtSelectLevel;
        this.refMeasures = refMeasures;
    }

    @Override
    protected long shallowSizeOf() {
        return SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
    }

    private S_MeasureDef setupMeasureDef() {
        ArrayList<S_MeasureDef> refMeasureDefs = new ArrayList<S_MeasureDef>();
        for (OlapMeasureMember refMeasure : this.refMeasures) {
            S_MeasureRef mRef = refMeasure.resolveClusterMeasureRef();
            S_MeasureDef mDef = (S_MeasureDef)mRef.getReferenced();
            refMeasureDefs.add(mDef);
        }
        return new S_UserMeasureDef(this.getNameX(), this.hierarchyAggregationType, refMeasureDefs, this.emptyIsZero, this.emptyIsZeroAsDouble);
    }

    @Override
    public boolean isDefinedAtSelectStatementLevel() {
        return this.definedAtSelectLevel;
    }

    @Override
    public boolean hasPositionInAnchor() {
        return this.positionInAnchor != -1;
    }

    @Override
    public void setPositionInAnchor(int position) {
        if (this.hasPositionInAnchor()) {
            throw new CdProgrammingException("Duplicated rank setup for calc. member : " + ONames.uname4Log(this));
        }
        this.positionInAnchor = position;
    }

    @Override
    public OlapMemberRank getRank() {
        if (this.positionInAnchor == -1) {
            throw new RuntimeException("internal error: missing rank for calc. member : " + ONames.uname4Log(this));
        }
        OlapMember myParent = this.getParent();
        if (myParent == null) {
            if (this.getLevel().getDepth() != 0) {
                throw new RuntimeException("internal error: inconsistent level for calc. member : " + ONames.uname4Log(this));
            }
            return new OlapMemberRank(this.positionInAnchor);
        }
        OlapMemberRank parentRank = myParent.getRank();
        return new OlapMemberRank(parentRank, this.positionInAnchor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected S_MeasureRef resolveClusterMeasureRef() {
        List<OlapMeasureMember> list = this.refMeasures;
        synchronized (list) {
            if (this.def == null) {
                this.def = this.setupMeasureDef();
            }
            return this.def.getRef();
        }
    }

    public List<OlapMeasureMember> getRefMeasures() {
        return this.refMeasures;
    }

    public void setupCellProperties() {
        if (this.cellProperties == null) {
            return;
        }
        OlapInstr.inheritFormatString(this.cellProperties, this.refMeasures);
        OlapInstr.inheritEmptyIsZero(this.cellProperties, this.refMeasures);
        if (this.cellProperties.isEmptyIsZero()) {
            this.emptyIsZero = true;
        }
    }
}

