/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.member;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapCalculatedMember;
import crazydev.iccube.olap.entity.member.OlapCalculatedMemberDeclarationOrder;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperties;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.localization.OlapSchemaLocalization;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public class OlapSchemaCalculatedMember
extends OlapCalculatedMember {
    private final OlapCalculatedMemberDeclarationOrder declarationOrder;
    private volatile boolean invalid;

    protected OlapSchemaCalculatedMember(String name, OlapLevel anchor, OlapInstrLocationRange idRange, OlapInstr formula, OlapCellProperties cellProperties, @Nullable String definedUniqueName) {
        super(name, anchor, idRange, formula, cellProperties, definedUniqueName);
        this.declarationOrder = this.setupDeclarationOrder(cellProperties);
    }

    protected OlapSchemaCalculatedMember(String name, OlapMember anchor, OlapInstrLocationRange idRange, OlapInstr formula, OlapCellProperties cellProperties, @Nullable String definedUniqueName) {
        super(name, anchor, idRange, formula, cellProperties, definedUniqueName);
        this.declarationOrder = this.setupDeclarationOrder(cellProperties);
    }

    private OlapCalculatedMemberDeclarationOrder setupDeclarationOrder(OlapCellProperties cellProperties) {
        OlapSchema schema = this.getDimension().getSchema();
        long nextCalcMemberDeclarationOrder = schema.getNextCalcMemberDeclarationOrder();
        return new OlapCalculatedMemberDeclarationOrder(this, false, this.isMeasure(), nextCalcMemberDeclarationOrder);
    }

    @Override
    public OlapCalculatedMemberDeclarationOrder getDeclarationOrder() {
        return this.declarationOrder;
    }

    @Override
    @Nullable
    protected String doGetCaption(Locale locale) {
        OlapSchema schema = this.getDimension().getSchema();
        OlapSchemaLocalization localization = schema.getLocalization();
        String myCaption = localization.getSchemaCalculatedMemberCaption(locale, this);
        if (CdStringUtils.isNotNullAndNotBlank((String)myCaption)) {
            return myCaption;
        }
        return super.doGetCaption(locale);
    }

    @Override
    @Nullable
    public String getDescription(Locale locale) {
        OlapSchema schema = this.getDimension().getSchema();
        OlapSchemaLocalization localization = schema.getLocalization();
        String descriptionL = localization.getSchemaCalculatedMemberDescription(locale, this);
        if (CdStringUtils.isNotNullAndNotBlank((String)descriptionL)) {
            return descriptionL;
        }
        return super.getDescription(locale);
    }

    @Override
    public boolean isDefinedAtSelectStatementLevel() {
        return false;
    }

    public void invalidateFormula() {
        this.invalid = true;
    }

    public boolean isFormulaValid() {
        return !this.invalid;
    }
}

