/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.member;

import crazydev.common.collection.CdAction;
import crazydev.common.system.CdRamUsageEstimator;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.olap.component.naming.ONames;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapMemberKey;
import crazydev.iccube.olap.entity.member.OlapMemberWithChildren;
import crazydev.iccube.olap.entity.properties.OlapMemberPropertiesValues;
import crazydev.iccube.olap.index.bitmap.OlapBitmap;
import org.jetbrains.annotations.Nullable;

public class OlapNoBaseRegularMember
extends OlapMemberWithChildren {
    private static long SHALLOW_SIZE_OF = -1L;

    protected OlapNoBaseRegularMember(OlapBuilderContext context, OlapLevel level, @Nullable OlapMember parent, @Nullable String name, @Nullable OlapMemberKey key, @Nullable OlapMemberPropertiesValues propertiesValues) {
        super(context, level, parent, name, key, propertiesValues);
    }

    @Override
    protected long shallowSizeOf() {
        return SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
    }

    @Override
    protected boolean needsBitmapAtOlapMemberLevel(OlapLevel level) {
        return false;
    }

    @Override
    @Nullable
    public OlapBitmap getBaseMemberBitmap() {
        if (this.isFactHollow()) {
            return this.getFactIndexingMember().getBaseMemberBitmap();
        }
        return this.dataHandler.getAutoExist(this);
    }

    @Override
    protected void addChildBitMap(OlapMember child) {
    }

    @Override
    public OlapMember addBaseHierarchyChild(OlapBuilderContext context, OlapMember mainHierChild) {
        if (mainHierChild.getHierarchy() == this.getHierarchy()) {
            throw new RuntimeException("internal error : inconsistent base child hierarchy (1) : this:" + ONames.uname4Log(this) + " child: " + ONames.uname4Log(mainHierChild));
        }
        if (!mainHierChild.getHierarchy().isBase()) {
            throw new RuntimeException("internal error : inconsistent base child hierarchy (2) : this:" + ONames.uname4Log(this) + " child: " + ONames.uname4Log(mainHierChild));
        }
        return this.doAddBaseHierarchyChild(context, mainHierChild);
    }

    public OlapMember doAddBaseHierarchyChild(OlapBuilderContext context, OlapMember mainHierChild) {
        OlapMember parent;
        if (this.mightBeHollow() && !mainHierChild.getHierarchy().isParentChild() && !this.getHierarchy().isParentChild() && this.isLastLevel4Hollow() && !mainHierChild.isAll() && this.dataHandler.mightBeHollow(this.dataHandlerIdx)) {
            OlapMember factMember = this.getDefinedFactIndexingMember();
            if (factMember == null) {
                this.setFactIndexingMember(context, mainHierChild);
            } else if (!OlapMember.equal(factMember, mainHierChild)) {
                this.removeFactHollow(context);
                this.dataHandler.setCanNotBeHollow(this.dataHandlerIdx);
            }
        }
        if ((parent = this.getParent()) != null) {
            parent.addBaseHierarchyChild(context, mainHierChild);
        }
        return mainHierChild;
    }

    protected boolean mightBeHollow() {
        return true;
    }

    private boolean isLastLevel4Hollow() {
        return !this.getHierarchy().isParentChild() && this.getLevel().isLast() && this.getHierarchy().mightBeFactHollow();
    }

    @Override
    protected boolean mightBeFactHollow() {
        return this.isLastLevel4Hollow() || super.mightBeFactHollow();
    }

    @Override
    void handleFactHollowOnAddChild(OlapBuilderContext context, OlapMember child) {
        if (this.isLastLevel4Hollow()) {
            return;
        }
        super.handleFactHollowOnAddChild(context, child);
    }

    @Override
    public boolean forEachNoBaseTerminalMember(OlapMember baseMember, CdAction<OlapMember> action) {
        boolean ret = false;
        if (this.isAll() || this.getBaseMemberBitmap().getBit(baseMember.getUniqueHierarchyMemberIndex())) {
            for (OlapMember child : this.getChildren()) {
                ret |= child.forEachNoBaseTerminalMember(baseMember, action);
            }
            if (!ret) {
                action.apply((Object)this);
                ret = true;
            }
        }
        return ret;
    }
}

