/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.member;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.system.CdRamUsageEstimator;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapMemberKey;
import crazydev.iccube.olap.entity.member.OlapNoBaseTerminalMember;
import crazydev.iccube.olap.entity.memory.IOlapMemoryLevelMember;
import crazydev.iccube.olap.entity.properties.OlapMemberPropertiesValues;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OlapNoBaseHollowTerminalMember
extends OlapNoBaseTerminalMember {
    private static long SHALLOW_SIZE_OF = -1L;

    protected OlapNoBaseHollowTerminalMember(OlapBuilderContext context, OlapLevel level, @Nullable OlapMember parent, @Nullable String name, @Nullable OlapMemberKey key, OlapMemberPropertiesValues propertiesValues) {
        super(context, level, parent, name, key, propertiesValues);
    }

    public OlapNoBaseHollowTerminalMember(IOlapMemoryLevelMember dataHandler, int dataHandlerIdx, int uniqueHierarchyMemberIndex) {
        super(dataHandler, dataHandlerIdx, uniqueHierarchyMemberIndex);
    }

    @Override
    protected long shallowSizeOf() {
        return SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
    }

    @Override
    protected void updateFactIndexingMember(OlapBuilderContext context, OlapMember mainHierChild) {
        OlapMember matchingMember = mainHierChild.getAncestor(this.getLevel().getHollowLevel());
        if (matchingMember == null) {
            throw new CdShouldNotBeHereProgrammingException();
        }
        OlapMember factMember = this.getDefinedFactIndexingMember();
        if (factMember == null) {
            this.setDefinedIndexingMember(matchingMember);
        } else if (!OlapMember.equal(factMember, matchingMember)) {
            throw new CdShouldNotBeHereProgrammingException();
        }
    }

    @Override
    @NotNull
    public OlapMember getFactIndexingMember() {
        OlapMember member = this.getDefinedFactIndexingMember();
        if (member == null) {
            throw new CdShouldNotBeHereProgrammingException();
        }
        return member.getFactIndexingMember();
    }

    @Override
    public boolean isFactHollow() {
        return true;
    }

    @Override
    public boolean isStructuralFactHollow() {
        return true;
    }
}

